/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.limegroup.bittorrent.BTMetaInfo;
import com.limegroup.bittorrent.ManagedTorrent;
import com.limegroup.bittorrent.TorrentEvent;
import com.limegroup.bittorrent.TorrentEventListener;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.uploader.UploadType;
import com.limegroup.gnutella.util.EventDispatcher;
import java.net.InetAddress;
import java.net.InetSocketAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTUploader
implements Uploader,
TorrentEventListener {
    private final ManagedTorrent _torrent;
    private final BTMetaInfo _info;
    private long startTime;
    private long stopTime;
    private final EventDispatcher<TorrentEvent, TorrentEventListener> dispatcher;
    private final ActivityCallback activityCallback;

    BTUploader(ManagedTorrent torrent, BTMetaInfo info, EventDispatcher<TorrentEvent, TorrentEventListener> dispatcher, ActivityCallback activityCallback) {
        this._torrent = torrent;
        this._info = info;
        this.dispatcher = dispatcher;
        this.activityCallback = activityCallback;
        dispatcher.addEventListener(this);
    }

    @Override
    public void stop() {
        TorrentEvent stopping = new TorrentEvent(this, TorrentEvent.Type.STOP_REQUESTED, this._torrent);
        this.dispatcher.dispatchEvent(stopping);
    }

    @Override
    public String getFileName() {
        return this._info.getName();
    }

    @Override
    public long getFileSize() {
        return this._info.getFileSystem().getTotalSize();
    }

    @Override
    public FileDesc getFileDesc() {
        return this._info.getFileDesc();
    }

    @Override
    public int getIndex() {
        return 0 - Math.abs(this._info.getURN().hashCode());
    }

    @Override
    public long amountUploaded() {
        return this._torrent.getTotalUploaded();
    }

    @Override
    public long getTotalAmountUploaded() {
        return this._torrent.getTotalUploaded();
    }

    @Override
    public String getHost() {
        return "";
    }

    @Override
    public Uploader.UploadStatus getState() {
        if (!this._torrent.isActive()) {
            if (this._torrent.isComplete() && this._torrent.getRatio() > 1.0f) {
                return Uploader.UploadStatus.COMPLETE;
            }
            return Uploader.UploadStatus.INTERRUPTED;
        }
        if (this._torrent.isUploading()) {
            return Uploader.UploadStatus.UPLOADING;
        }
        if (this._torrent.isSuspended()) {
            return Uploader.UploadStatus.SUSPENDED;
        }
        return Uploader.UploadStatus.WAITING_REQUESTS;
    }

    @Override
    public Uploader.UploadStatus getLastTransferState() {
        return Uploader.UploadStatus.UPLOADING;
    }

    @Override
    public boolean isChatEnabled() {
        return false;
    }

    @Override
    public boolean isBrowseHostEnabled() {
        return false;
    }

    @Override
    public int getGnutellaPort() {
        return 0;
    }

    @Override
    public String getUserAgent() {
        return "";
    }

    @Override
    public int getQueuePosition() {
        return 0;
    }

    @Override
    public boolean isInactive() {
        switch (this._torrent.getState()) {
            case PAUSED: 
            case STOPPED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void measureBandwidth() {
        this._torrent.measureBandwidth();
    }

    @Override
    public float getMeasuredBandwidth() throws InsufficientDataException {
        if (!this._torrent.isActive()) {
            return 0.0f;
        }
        return this._torrent.getMeasuredBandwidth(false);
    }

    @Override
    public void handleTorrentEvent(TorrentEvent evt) {
        if (evt.getTorrent() != this._torrent) {
            return;
        }
        switch (evt.getType()) {
            case STARTED: {
                this.torrentStarted();
                break;
            }
            case STOP_APPROVED: {
                this._torrent.stop();
                break;
            }
            case STOPPED: {
                this.torrentStopped();
                this.dispatcher.removeEventListener(this);
                break;
            }
        }
    }

    @Override
    public float getAverageBandwidth() {
        long now = this.stopTime > 0L ? this.stopTime : System.currentTimeMillis();
        long runTime = now - this.startTime;
        return runTime > 0L ? (float)(this.getTotalAmountUploaded() / runTime) : 0.0f;
    }

    private void torrentStarted() {
        this.startTime = System.currentTimeMillis();
        this.stopTime = 0L;
        this.activityCallback.addUpload(this);
    }

    private void torrentStopped() {
        this.activityCallback.removeUpload(this);
        this.stopTime = System.currentTimeMillis();
    }

    @Override
    public String getCustomIconDescriptor() {
        if (this._info.getFileSystem().getFiles().size() == 1) {
            return null;
        }
        return "";
    }

    @Override
    public UploadType getUploadType() {
        return UploadType.SHARED_FILE;
    }

    @Override
    public boolean isTLSCapable() {
        return false;
    }

    @Override
    public String getAddress() {
        return "torrent upload";
    }

    @Override
    public InetAddress getInetAddress() {
        return null;
    }

    @Override
    public int getPort() {
        return -1;
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        return null;
    }
}

