/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.limegroup.bittorrent.BTLink;
import com.limegroup.bittorrent.BTLinkManager;
import com.limegroup.bittorrent.BTLinkManagerFactory;
import com.limegroup.bittorrent.BTMetaInfo;
import com.limegroup.bittorrent.ManagedTorrent;
import com.limegroup.bittorrent.Torrent;
import com.limegroup.bittorrent.TorrentContext;
import com.limegroup.bittorrent.TorrentEvent;
import com.limegroup.bittorrent.TorrentEventListener;
import com.limegroup.bittorrent.TorrentLocation;
import com.limegroup.bittorrent.TorrentManager;
import com.limegroup.bittorrent.choking.Choker;
import com.limegroup.bittorrent.choking.ChokerFactory;
import com.limegroup.bittorrent.disk.DiskManagerListener;
import com.limegroup.bittorrent.disk.TorrentDiskManager;
import com.limegroup.bittorrent.handshaking.BTConnectionFetcher;
import com.limegroup.bittorrent.handshaking.BTConnectionFetcherFactory;
import com.limegroup.bittorrent.messages.BTHave;
import com.limegroup.bittorrent.settings.BittorrentSettings;
import com.limegroup.bittorrent.tracking.TrackerManager;
import com.limegroup.bittorrent.tracking.TrackerManagerFactory;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.auth.ContentResponseData;
import com.limegroup.gnutella.auth.ContentResponseObserver;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.EventDispatcher;
import com.limegroup.gnutella.util.StrictIpPortSet;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.concurrent.SyncWrapper;
import org.limewire.io.DiskException;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.service.ErrorService;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedTorrentImpl
implements ManagedTorrent,
DiskManagerListener {
    private static final Log LOG = LogFactory.getLog(ManagedTorrentImpl.class);
    private static final ExecutorService DEFAULT_DISK_INVOKER = ExecutorsHelper.newProcessingQueue("ManagedTorrent");
    private final ScheduledExecutorService networkInvoker;
    private ExecutorService diskInvoker = DEFAULT_DISK_INVOKER;
    private Set<TorrentLocation> _peers;
    private BTMetaInfo _info;
    private volatile TorrentDiskManager _folder;
    private final TrackerManager trackerManager;
    private final BTConnectionFetcherFactory connectionFetcherFactory;
    private volatile BTConnectionFetcher _connectionFetcher;
    private final BTLinkManager linkManager;
    private final ChokerFactory chokerFactory;
    private Choker choker;
    private final SyncWrapper<Torrent.TorrentState> state = new SyncWrapper<Torrent.TorrentState>(Torrent.TorrentState.QUEUED);
    private volatile long totalDown;
    private final EventDispatcher<TorrentEvent, TorrentEventListener> dispatcher;
    private final TorrentContext context;
    private final NetworkManager networkManager;
    private final ContentManager contentManager;
    private final IPFilter ipFilter;
    private final TorrentManager torrentManager;
    private final FileManager fileManager;
    private final NetworkInstanceUtils networkInstanceUtils;
    private AtomicBoolean firstChunkVerifiedEventDispatched;

    ManagedTorrentImpl(TorrentContext context, EventDispatcher<TorrentEvent, TorrentEventListener> dispatcher, ScheduledExecutorService networkInvoker, NetworkManager networkManager, TrackerManagerFactory trackerManagerFactory, ChokerFactory chokerFactory, BTLinkManagerFactory linkManagerFactory, BTConnectionFetcherFactory connectionFetcherFactory, ContentManager contentManager, IPFilter ipFilter, TorrentManager torrentManager, FileManager fileManager, NetworkInstanceUtils networkInstanceUtils) {
        this.context = context;
        this.networkInvoker = networkInvoker;
        this.dispatcher = dispatcher;
        this.networkManager = networkManager;
        this.chokerFactory = chokerFactory;
        this.connectionFetcherFactory = connectionFetcherFactory;
        this.contentManager = contentManager;
        this.ipFilter = ipFilter;
        this.torrentManager = torrentManager;
        this.fileManager = fileManager;
        this.networkInstanceUtils = networkInstanceUtils;
        this._info = context.getMetaInfo();
        this._folder = this.getContext().getDiskManager();
        this._peers = Collections.emptySet();
        this.linkManager = linkManagerFactory.getLinkManager();
        this.trackerManager = trackerManagerFactory.getTrackerManager(this);
        this.firstChunkVerifiedEventDispatched = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setScraping() {
        Object object = this.state.getLock();
        synchronized (object) {
            if (this.state.get() == Torrent.TorrentState.WAITING_FOR_TRACKER) {
                this.state.set(Torrent.TorrentState.SCRAPING);
            }
        }
    }

    @Override
    public byte[] getInfoHash() {
        return this._info.getInfoHash();
    }

    @Override
    public BTMetaInfo getMetaInfo() {
        return this._info;
    }

    @Override
    public TorrentContext getContext() {
        return this.context;
    }

    @Override
    public boolean isComplete() {
        return this.state.get() != Torrent.TorrentState.DISK_PROBLEM && this._folder.isComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("requesting torrent start", new Exception());
        }
        Object object = this.state.getLock();
        synchronized (object) {
            if (this.state.get() != Torrent.TorrentState.QUEUED) {
                throw new IllegalStateException("torrent should be queued but is " + (Object)((Object)this.state.get()));
            }
        }
        this.dispatchEvent(TorrentEvent.Type.STARTING);
        this.diskInvoker.execute(new Runnable(){

            public void run() {
                if (ManagedTorrentImpl.this.state.get() != Torrent.TorrentState.QUEUED) {
                    return;
                }
                LOG.debug("executing torrent start");
                ManagedTorrentImpl.this.initializeTorrent();
                ManagedTorrentImpl.this.initializeFolder();
                if (ManagedTorrentImpl.this.state.get() == Torrent.TorrentState.DISK_PROBLEM) {
                    return;
                }
                ManagedTorrentImpl.this.dispatchEvent(TorrentEvent.Type.STARTED);
                Torrent.TorrentState s = (Torrent.TorrentState)((Object)ManagedTorrentImpl.this.state.get());
                if (s == Torrent.TorrentState.SEEDING || s == Torrent.TorrentState.VERIFYING) {
                    return;
                }
                ManagedTorrentImpl.this.validateTorrent();
                ManagedTorrentImpl.this.startConnecting();
            }
        });
    }

    private void validateTorrent() {
        ContentResponseObserver observer = new ContentResponseObserver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleResponse(URN urn, ContentResponseData response) {
                if (response != null && !response.isOK() && urn.equals(ManagedTorrentImpl.this.context.getMetaInfo().getURN())) {
                    ManagedTorrentImpl managedTorrentImpl = ManagedTorrentImpl.this;
                    synchronized (managedTorrentImpl) {
                        boolean wasActive;
                        Object object = ManagedTorrentImpl.this.state.getLock();
                        synchronized (object) {
                            wasActive = ManagedTorrentImpl.this.isActive();
                            ManagedTorrentImpl.this.state.set(Torrent.TorrentState.INVALID);
                        }
                        if (wasActive) {
                            ManagedTorrentImpl.this.stopImpl();
                        }
                    }
                }
            }
        };
        this.contentManager.request(this.context.getMetaInfo().getURN(), observer, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startConnecting() {
        boolean shouldFetch = false;
        Object object = this.state.getLock();
        synchronized (object) {
            if (this.state.get() != Torrent.TorrentState.QUEUED) {
                return;
            }
            if (this._peers.size() > 0) {
                this.state.set(Torrent.TorrentState.CONNECTING);
                shouldFetch = true;
            } else {
                this.state.set(Torrent.TorrentState.SCRAPING);
            }
        }
        if (shouldFetch) {
            this._connectionFetcher.fetch();
        }
        this.trackerManager.announceStart();
        this.choker.start();
    }

    @Override
    public synchronized void stop() {
        if (!this.isActive()) {
            throw new IllegalStateException("torrent cannot be stopped in state " + (Object)((Object)this.state.get()));
        }
        this.state.set(Torrent.TorrentState.STOPPED);
        this.stopImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void diskExceptionHappened(DiskException e) {
        Object object = this.state.getLock();
        synchronized (object) {
            if (this.state.get() == Torrent.TorrentState.DISK_PROBLEM) {
                return;
            }
            this.state.set(Torrent.TorrentState.DISK_PROBLEM);
        }
        this.stopImpl();
        if (BittorrentSettings.REPORT_DISK_PROBLEMS.getBoolean()) {
            ErrorService.error(e);
        }
    }

    private synchronized void stopImpl() {
        if (!this.stopState()) {
            throw new IllegalStateException("stopping in wrong state " + (Object)((Object)this.state.get()));
        }
        this._folder.close();
        String description = null;
        if (this.state.get() != Torrent.TorrentState.TRACKER_FAILURE) {
            this.trackerManager.announceStop();
        } else {
            description = this.trackerManager.getLastFailureReason();
        }
        if (!this._folder.isComplete()) {
            Runnable saver = new Runnable(){

                public void run() {
                    try {
                        ManagedTorrentImpl.this.saveInfoMapInIncomplete();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            this.diskInvoker.execute(saver);
        }
        Runnable closer = new Runnable(){

            public void run() {
                ManagedTorrentImpl.this.choker.shutdown();
                ManagedTorrentImpl.this.linkManager.shutdown();
                ManagedTorrentImpl.this._connectionFetcher.shutdown();
            }
        };
        this.networkInvoker.execute(closer);
        this.dispatchEvent(TorrentEvent.Type.STOPPED, description);
        LOG.debug("Torrent stopped!");
    }

    private void saveInfoMapInIncomplete() throws IOException {
        String path = this.context.getFileSystem().getBaseFile().getParent() + File.separator + ".dat" + this.context.getFileSystem().getName();
        FileUtils.writeObject(path, (Object)this.context.getMetaInfo().toMemento());
    }

    private void dispatchEvent(TorrentEvent.Type type, String description) {
        TorrentEvent evt = new TorrentEvent(this, type, this, description);
        this.dispatcher.dispatchEvent(evt);
    }

    private void dispatchEvent(TorrentEvent.Type type) {
        this.dispatchEvent(type, null);
    }

    private boolean stopState() {
        switch (this.state.get()) {
            case PAUSED: 
            case STOPPED: 
            case DISK_PROBLEM: 
            case TRACKER_FAILURE: 
            case INVALID: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void pause() {
        boolean wasActive = false;
        Object object = this.state.getLock();
        synchronized (object) {
            if (!this.isActive() && this.state.get() != Torrent.TorrentState.QUEUED) {
                return;
            }
            wasActive = this.isActive();
            this.state.set(Torrent.TorrentState.PAUSED);
        }
        if (wasActive) {
            this.stopImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resume() {
        Object object = this.state.getLock();
        synchronized (object) {
            switch (this.state.get()) {
                case PAUSED: 
                case STOPPED: 
                case TRACKER_FAILURE: {
                    this.state.set(Torrent.TorrentState.QUEUED);
                    return true;
                }
            }
            return false;
        }
    }

    @Override
    public void linkClosed(BTLink btc) {
        if (btc.isWorthRetrying()) {
            TorrentLocation ep = new TorrentLocation(btc.getEndpoint());
            ep.strike();
            this._peers.add(ep);
        }
        this.removeConnection(btc);
        if (!this.needsMoreConnections()) {
            return;
        }
        Torrent.TorrentState s = this.state.get();
        if (s == Torrent.TorrentState.DOWNLOADING || s == Torrent.TorrentState.CONNECTING) {
            this._connectionFetcher.fetch();
        }
    }

    @Override
    public void linkInterested(BTLink interested) {
        if (!interested.isChoked()) {
            this.rechoke();
        }
    }

    @Override
    public void linkNotInterested(BTLink notInterested) {
        if (!notInterested.isChoked()) {
            this.rechoke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trackerRequestFailed() {
        Object object = this.state.getLock();
        synchronized (object) {
            if (this.state.get() == Torrent.TorrentState.SCRAPING) {
                this.state.set(Torrent.TorrentState.WAITING_FOR_TRACKER);
            }
        }
        if (BittorrentSettings.TORRENT_ALTLOC_SEARCH.getValue()) {
            this.dispatchEvent(TorrentEvent.Type.TRACKER_FAILED);
        }
    }

    private void initializeTorrent() {
        this._peers = Collections.synchronizedSet(new StrictIpPortSet());
        this.choker = this.chokerFactory.getChoker(this.linkManager, false);
        this._connectionFetcher = this.connectionFetcherFactory.getBTConnectionFetcher(this);
    }

    private void initializeFolder() {
        try {
            this._folder.open(this);
            this.saveInfoMapInIncomplete();
        }
        catch (IOException ioe) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("unrecoverable error", ioe);
            }
            this.state.set(Torrent.TorrentState.DISK_PROBLEM);
            return;
        }
        if (this._folder.isComplete()) {
            this.completeTorrentDownload();
        } else if (this._folder.isVerifying()) {
            this.state.set(Torrent.TorrentState.VERIFYING);
        }
    }

    @Override
    public void verificationComplete() {
        this.diskInvoker.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = ManagedTorrentImpl.this.state.getLock();
                synchronized (object) {
                    if (ManagedTorrentImpl.this.state.get() != Torrent.TorrentState.VERIFYING) {
                        return;
                    }
                    ManagedTorrentImpl.this.state.set(Torrent.TorrentState.QUEUED);
                }
                ManagedTorrentImpl.this.startConnecting();
                if (ManagedTorrentImpl.this._folder.isComplete()) {
                    ManagedTorrentImpl.this.completeTorrentDownload();
                }
            }
        });
    }

    @Override
    public void chunkVerified(int in) {
        if (this.firstChunkVerifiedEventDispatched.compareAndSet(false, true) && !this._info.isPrivate() && SharingSettings.SHARE_TORRENT_META_FILES.getValue() && BittorrentSettings.TORRENT_AUTO_PUBLISH.getValue()) {
            this.dispatchEvent(TorrentEvent.Type.FIRST_CHUNK_VERIFIED);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("got completed chunk " + in);
        }
        if (this._folder.isVerifying()) {
            return;
        }
        final BTHave have = new BTHave(in);
        Runnable haveNotifier = new Runnable(){

            public void run() {
                ManagedTorrentImpl.this.linkManager.sendHave(have);
            }
        };
        this.networkInvoker.execute(haveNotifier);
        if (this._folder.isComplete()) {
            LOG.info("file is complete");
            this.diskInvoker.execute(new Runnable(){

                public void run() {
                    if (ManagedTorrentImpl.this.isDownloading()) {
                        ManagedTorrentImpl.this.completeTorrentDownload();
                    }
                }
            });
        }
    }

    @Override
    public Torrent.TorrentState getState() {
        return this.state.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEndpoint(TorrentLocation to) {
        if (this._peers.contains(to) || this.linkManager.isConnectedTo(to)) {
            return;
        }
        if (!this.ipFilter.allow(to.getAddress())) {
            return;
        }
        if (this.networkInstanceUtils.isMe(to.getAddress(), to.getPort())) {
            return;
        }
        if (this._peers.add(to)) {
            Object object = this.state.getLock();
            synchronized (object) {
                if (this.state.get() == Torrent.TorrentState.SCRAPING) {
                    this.state.set(Torrent.TorrentState.CONNECTING);
                }
            }
            this._connectionFetcher.fetch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopVoluntarily() {
        boolean stop = false;
        Object object = this.state.getLock();
        synchronized (object) {
            if (!this.isActive()) {
                return;
            }
            if (this.state.get() != Torrent.TorrentState.SEEDING) {
                this.state.set(Torrent.TorrentState.TRACKER_FAILURE);
                stop = true;
            }
        }
        if (stop) {
            this.stopImpl();
        }
    }

    @Override
    public boolean needsMoreConnections() {
        if (!this.isActive()) {
            return false;
        }
        if (this.isComplete() && this.torrentManager.hasNonSeeding()) {
            return false;
        }
        int limit = this.torrentManager.getMaxTorrentConnections();
        if (this.networkManager.acceptedIncomingConnection()) {
            limit = limit * 3 / 5;
        }
        return this.linkManager.getNumConnections() < limit;
    }

    @Override
    public boolean shouldAddConnection(TorrentLocation loc) {
        if (this.linkManager.isConnectedTo(loc)) {
            return false;
        }
        return this.linkManager.getNumConnections() < this.torrentManager.getMaxTorrentConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addConnection(BTLink btc) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("trying to add connection " + btc.toString());
        }
        boolean shouldAdd = false;
        Object object = this.state.getLock();
        synchronized (object) {
            switch (this.state.get()) {
                case CONNECTING: 
                case SCRAPING: 
                case WAITING_FOR_TRACKER: {
                    this.state.set(Torrent.TorrentState.DOWNLOADING);
                    this.dispatchEvent(TorrentEvent.Type.DOWNLOADING);
                }
                case DOWNLOADING: 
                case SEEDING: {
                    shouldAdd = true;
                }
            }
        }
        if (!shouldAdd) {
            return false;
        }
        this.linkManager.addLink(btc);
        this._peers.remove(btc.getEndpoint());
        if (LOG.isDebugEnabled()) {
            LOG.debug("added connection " + btc.toString());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnection(BTLink btc) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("removing connection " + btc.toString());
        }
        this.linkManager.removeLink(btc);
        if (btc.isUploading()) {
            this.rechoke();
        }
        boolean connectionsEmpty = this.linkManager.getNumConnections() == 0;
        boolean peersEmpty = this._peers.isEmpty();
        Object object = this.state.getLock();
        synchronized (object) {
            if (connectionsEmpty && this.state.get() == Torrent.TorrentState.DOWNLOADING) {
                if (peersEmpty) {
                    this.state.set(Torrent.TorrentState.WAITING_FOR_TRACKER);
                } else {
                    this.state.set(Torrent.TorrentState.CONNECTING);
                }
            }
        }
    }

    private synchronized void completeTorrentDownload() {
        Runnable r = new Runnable(){

            public void run() {
                ManagedTorrentImpl.this.linkManager.disconnectSeedsChokeRest();
                ManagedTorrentImpl.this._peers.clear();
            }
        };
        this.networkInvoker.execute(r);
        try {
            this.saveFiles();
        }
        catch (IOException failed) {
            this.diskExceptionHappened(new DiskException(failed));
            return;
        }
        this.state.set(Torrent.TorrentState.SEEDING);
        this.choker.shutdown();
        this.choker = this.chokerFactory.getChoker(this.linkManager, true);
        this.choker.start();
        this.choker.rechoke();
        this.trackerManager.announceComplete();
        this.dispatchEvent(TorrentEvent.Type.COMPLETE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFiles() throws IOException {
        TorrentDiskManager torrentDiskManager = this._folder;
        synchronized (torrentDiskManager) {
            if (!this._folder.isOpen()) {
                return;
            }
            this._folder.close();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("folder closed");
        }
        this.state.set(Torrent.TorrentState.SAVING);
        this.context.getFileSystem().moveToCompleteFolder();
        if (!this._info.isPrivate()) {
            this.addToLibrary();
        }
        LOG.trace("saved files");
        this.context.initializeDiskManager(true);
        LOG.trace("initialized folder");
        this.context.getMetaInfo().resetFileDesc();
        this._folder = this.context.getDiskManager();
        if (LOG.isDebugEnabled()) {
            LOG.debug("new veryfing folder");
        }
        this._folder.open(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug("folder opened");
        }
    }

    private void addToLibrary() {
        boolean force = SharingSettings.SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES.getValue();
        File _completeFile = this.context.getFileSystem().getCompleteFile();
        if (_completeFile.isFile()) {
            if (force) {
                this.fileManager.addFileAlways(_completeFile);
            } else {
                this.fileManager.addFileIfShared(_completeFile);
            }
        } else if (_completeFile.isDirectory() && (force || this.fileManager.isFileInCompletelySharedDirectory(_completeFile))) {
            this.fileManager.addSharedFolder(_completeFile);
        }
    }

    @Override
    public long getNextTrackerRequestTime() {
        return this.trackerManager.getNextTrackerRequestTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TorrentLocation getTorrentLocation() {
        long now = System.currentTimeMillis();
        TorrentLocation ret = null;
        Set<TorrentLocation> set = this._peers;
        synchronized (set) {
            Iterator<TorrentLocation> iter = this._peers.iterator();
            while (iter.hasNext()) {
                TorrentLocation loc = iter.next();
                if (loc.isBusy(now)) continue;
                iter.remove();
                if (this.linkManager.isConnectedTo(loc)) continue;
                ret = loc;
                break;
            }
        }
        return ret;
    }

    private void rechoke() {
        this.choker.rechoke();
    }

    @Override
    public boolean isPaused() {
        return this.state.get() == Torrent.TorrentState.PAUSED;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ManagedTorrentImpl)) {
            return false;
        }
        ManagedTorrent mt = (ManagedTorrent)o;
        return Arrays.equals(mt.getInfoHash(), this.getInfoHash());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        Object object = this.state.getLock();
        synchronized (object) {
            if (this.isDownloading()) {
                return true;
            }
            switch (this.state.get()) {
                case SEEDING: 
                case VERIFYING: 
                case SAVING: {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPausable() {
        Object object = this.state.getLock();
        synchronized (object) {
            if (this.isDownloading()) {
                return true;
            }
            switch (this.state.get()) {
                case VERIFYING: 
                case QUEUED: {
                    return true;
                }
            }
        }
        return false;
    }

    boolean isDownloading() {
        switch (this.state.get()) {
            case CONNECTING: 
            case SCRAPING: 
            case WAITING_FOR_TRACKER: 
            case DOWNLOADING: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getNumConnections() {
        return this.linkManager.getNumConnections();
    }

    @Override
    public int getNumPeers() {
        return this._peers.size();
    }

    @Override
    public int getNumNonInterestingPeers() {
        return this.linkManager.getNumNonInterestingPeers();
    }

    @Override
    public int getNumChockingPeers() {
        return this.linkManager.getNumChockingPeers();
    }

    @Override
    public void countDownloaded(int amount) {
        this.totalDown += (long)amount;
    }

    @Override
    public long getTotalUploaded() {
        return this._info.getAmountUploaded();
    }

    @Override
    public long getTotalDownloaded() {
        return this.totalDown;
    }

    @Override
    public float getRatio() {
        return this._info.getRatio();
    }

    @Override
    public long getAmountLost() {
        return this._folder.getNumCorruptedBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNonBusyLocations() {
        long now = System.currentTimeMillis();
        Set<TorrentLocation> set = this._peers;
        synchronized (set) {
            for (TorrentLocation to : this._peers) {
                if (to.isBusy(now)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNextLocationRetryTime() {
        long soonest = Long.MAX_VALUE;
        long now = System.currentTimeMillis();
        Set<TorrentLocation> set = this._peers;
        synchronized (set) {
            TorrentLocation to;
            Iterator<TorrentLocation> i$ = this._peers.iterator();
            while (i$.hasNext() && (soonest = Math.min(soonest, (to = i$.next()).getWaitTime(now))) != 0L) {
            }
        }
        return soonest;
    }

    @Override
    public boolean shouldStop() {
        return this.linkManager.getNumConnections() == 0 && this._peers.size() == 0 && this.state.get() != Torrent.TorrentState.SEEDING;
    }

    @Override
    public BTConnectionFetcher getFetcher() {
        return this._connectionFetcher;
    }

    @Override
    public ScheduledExecutorService getNetworkScheduledExecutorService() {
        return this.networkInvoker;
    }

    @Override
    public void measureBandwidth() {
        this.linkManager.measureBandwidth();
    }

    @Override
    public float getMeasuredBandwidth(boolean downstream) {
        return this.linkManager.getMeasuredBandwidth(downstream);
    }

    @Override
    public int getTriedHostCount() {
        return this._connectionFetcher.getTriedHostCount();
    }

    @Override
    public boolean isUploading() {
        return this.linkManager.hasUploading();
    }

    @Override
    public boolean isSuspended() {
        return this.isComplete() && this.linkManager.hasInterested() && !this.linkManager.hasUnchoked();
    }
}

