/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.bittorrent.BTMetaInfo;
import com.limegroup.bittorrent.ManagedTorrent;
import com.limegroup.bittorrent.Torrent;
import com.limegroup.bittorrent.TorrentEvent;
import com.limegroup.bittorrent.TorrentEventListener;
import com.limegroup.bittorrent.TorrentFileSystem;
import com.limegroup.bittorrent.TorrentManager;
import com.limegroup.bittorrent.handshaking.IncomingConnectionHandler;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.library.SharingUtils;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.net.ConnectionDispatcher;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

@Singleton
public class TorrentManagerImpl
implements TorrentManager {
    private static final Log LOG = LogFactory.getLog(TorrentManagerImpl.class);
    private final Set<ManagedTorrent> _active = new HashSet<ManagedTorrent>();
    private final Set<ManagedTorrent> _seeding = new HashSet<ManagedTorrent>();
    private final Set<ManagedTorrent> _starting = new HashSet<ManagedTorrent>();
    private final List<TorrentEventListener> listeners = new CopyOnWriteArrayList<TorrentEventListener>();
    private final FileManager fileManager;
    private final ScheduledExecutorService threadPool;
    private final IncomingConnectionHandler incomingConnectionHandler;

    @Inject
    public TorrentManagerImpl(FileManager fileManager, @Named(value="backgroundExecutor") ScheduledExecutorService threadPool, IncomingConnectionHandler incomingConnectionHandler) {
        this.incomingConnectionHandler = incomingConnectionHandler;
        this.fileManager = fileManager;
        this.threadPool = threadPool;
        this.listeners.add(this);
    }

    public void initialize(ConnectionDispatcher dispatcher) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("initializing TorrentManager");
        }
        StringBuilder word = new StringBuilder();
        word.append('\u0013');
        word.append("BitTorrent");
        dispatcher.addConnectionAcceptor(this, false, word.toString());
        FileUtils.addFileLocker(this);
    }

    public boolean isBlocking() {
        return false;
    }

    private static int getMaxActiveTorrents() {
        if (OSUtils.isWindows() && !OSUtils.isGoodWindows()) {
            return 1;
        }
        int speed = ConnectionSettings.CONNECTION_SPEED.getValue();
        if (speed <= 56) {
            return 1;
        }
        if (speed <= 350) {
            return 3;
        }
        if (speed <= 1000) {
            return 3;
        }
        return 5;
    }

    public int getMaxTorrentConnections() {
        if (OSUtils.isWindows() && !OSUtils.isGoodWindows()) {
            return 30;
        }
        if (ConnectionSettings.CONNECTION_SPEED.getValue() <= 56) {
            return 40;
        }
        return 150;
    }

    public void addEventListener(TorrentEventListener listener) {
        if (!this.listeners.add(listener)) {
            throw new IllegalArgumentException("listener " + listener + " already registered");
        }
    }

    public void removeEventListener(TorrentEventListener listener) {
        this.listeners.remove(listener);
    }

    public void dispatchEvent(TorrentEvent evt) {
        for (TorrentEventListener l : this.listeners) {
            if (l == evt.getSource()) continue;
            l.handleTorrentEvent(evt);
        }
    }

    public void handleTorrentEvent(TorrentEvent evt) {
        if (evt.getSource() == this) {
            return;
        }
        ManagedTorrent t = evt.getTorrent();
        switch (evt.getType()) {
            case STARTING: {
                this.torrentStarting(t);
                break;
            }
            case STARTED: {
                this.torrentStarted(t);
                break;
            }
            case DOWNLOADING: {
                this.shareTorrent(t);
                break;
            }
            case STOPPED: {
                this.torrentStopped(t);
                break;
            }
            case COMPLETE: {
                this.torrentComplete(t);
                break;
            }
        }
    }

    public synchronized ManagedTorrent getTorrentForHash(byte[] infoHash) {
        for (ManagedTorrent torrent : this._active) {
            if (!Arrays.equals(torrent.getInfoHash(), infoHash)) continue;
            return torrent;
        }
        return null;
    }

    public synchronized ManagedTorrent getTorrentForURN(URN urn) {
        for (ManagedTorrent torrent : this._active) {
            if (!torrent.getMetaInfo().getURN().equals(urn)) continue;
            return torrent;
        }
        return null;
    }

    public void acceptConnection(String word, Socket sock) {
        this.incomingConnectionHandler.handleIncoming((AbstractNBSocket)sock, this);
    }

    private synchronized void torrentComplete(ManagedTorrent t) {
        assert (this._active.contains(t));
        this._seeding.add(t);
    }

    private synchronized void torrentStarting(ManagedTorrent t) {
        this._starting.add(t);
    }

    private synchronized void torrentStarted(ManagedTorrent t) {
        assert (this._starting.contains(t));
        this._starting.remove(t);
        if (this._seeding.remove(t)) {
            this._active.remove(t);
        }
        if (this._active.size() >= TorrentManagerImpl.getMaxActiveTorrents()) {
            Torrent best = null;
            for (ManagedTorrent torrent : this._seeding) {
                if (best != null && !(torrent.getRatio() > best.getRatio())) continue;
                best = torrent;
            }
            if (best != null) {
                best.stop();
            }
        }
        this._active.add(t);
    }

    private synchronized void torrentStopped(ManagedTorrent t) {
        this._active.remove(t);
        this.unshareTorrent(t, this._seeding.remove(t));
    }

    public synchronized boolean allowNewTorrent() {
        return this._starting.size() + this._active.size() - this._seeding.size() < TorrentManagerImpl.getMaxActiveTorrents();
    }

    public synchronized int getNumActiveTorrents() {
        return this._active.size();
    }

    public synchronized boolean hasNonSeeding() {
        return this._active.size() > this._seeding.size();
    }

    public boolean releaseLock(File file) {
        return this.killTorrentForFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean killTorrentForFile(File f) {
        Torrent found = null;
        TorrentManagerImpl torrentManagerImpl = this;
        synchronized (torrentManagerImpl) {
            for (ManagedTorrent t : this._active) {
                TorrentFileSystem system = t.getMetaInfo().getFileSystem();
                if (!system.conflicts(f) && !system.conflictsIncomplete(f)) continue;
                found = t;
                break;
            }
        }
        if (found != null) {
            found.stop();
            return true;
        }
        return false;
    }

    private synchronized void shareTorrent(ManagedTorrent t) {
        if (!SharingSettings.SHARE_TORRENT_META_FILES.getValue() || t.getMetaInfo().isPrivate()) {
            return;
        }
        final File f = this.getSharedTorrentMetaDataFile(t.getMetaInfo());
        Runnable r = new Runnable(){

            public void run() {
                if (SharingUtils.isFilePhysicallyShareable(f)) {
                    TorrentManagerImpl.this.fileManager.addFileForSession(f);
                }
            }
        };
        this.threadPool.execute(r);
    }

    private synchronized void unshareTorrent(ManagedTorrent t, boolean delete) {
        final File f = this.getSharedTorrentMetaDataFile(t.getMetaInfo());
        final boolean fdelete = delete || t.getState().equals((Object)Torrent.TorrentState.TRACKER_FAILURE);
        Runnable r = new Runnable(){

            public void run() {
                FileDesc fd = TorrentManagerImpl.this.fileManager.stopSharingFile(f);
                if (fd != null && fdelete) {
                    FileUtils.delete(fd.getFile(), false);
                } else {
                    f.setLastModified(System.currentTimeMillis());
                }
            }
        };
        this.threadPool.execute(r);
    }

    public File getSharedTorrentMetaDataFile(BTMetaInfo info) {
        String fileName = info.getFileSystem().getName().concat(".torrent");
        File f = new File(SharingUtils.APPLICATION_SPECIAL_SHARE, fileName);
        return f;
    }
}

