/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.bencoding;

import com.limegroup.bittorrent.bencoding.Token;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BEAbstractCollection<T>
extends Token<T> {
    protected boolean done;
    private Token<?> currentElement;

    public BEAbstractCollection(ReadableByteChannel chan) {
        super(chan);
        this.result = this.createCollection();
    }

    protected abstract T createCollection();

    protected abstract void add(Object var1);

    protected abstract Token<?> getNewElement() throws IOException;

    @Override
    protected boolean isDone() {
        return this.done;
    }

    @Override
    public void handleRead() throws IOException {
        if (this.isDone()) {
            throw new IllegalStateException("token is done, don't read to it");
        }
        while (true) {
            if (this.currentElement == null) {
                this.currentElement = this.getNewElement();
            }
            if (this.currentElement == null) {
                return;
            }
            if (this.currentElement.getResult() == Token.TERMINATOR) {
                this.done = true;
                return;
            }
            this.currentElement.handleRead();
            Object result = this.currentElement.getResult();
            if (result == null) {
                return;
            }
            if (result == Token.TERMINATOR) {
                this.done = true;
                return;
            }
            this.add(result);
            this.currentElement = null;
        }
    }
}

