/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.bencoding;

import com.limegroup.bittorrent.bencoding.BEBoolean;
import com.limegroup.bittorrent.bencoding.BEDictionary;
import com.limegroup.bittorrent.bencoding.BEList;
import com.limegroup.bittorrent.bencoding.BELong;
import com.limegroup.bittorrent.bencoding.BERational;
import com.limegroup.bittorrent.bencoding.BEString;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.limewire.util.BEncoder;
import org.limewire.util.BufferUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Token<T> {
    protected static final int INTERNAL = -1;
    public static final int LONG = 0;
    public static final int STRING = 1;
    public static final int LIST = 2;
    public static final int DICTIONARY = 3;
    public static final int BOOLEAN = 4;
    public static final int RATIONAL = 5;
    protected static final String ASCII = "ISO-8859-1";
    protected static final byte ZERO;
    protected static final byte NINE;
    protected final ReadableByteChannel chan;
    protected T result;
    static final EndElement TERMINATOR;

    public Token(ReadableByteChannel chan) {
        this.chan = chan;
    }

    public abstract void handleRead() throws IOException;

    protected abstract boolean isDone();

    public int getType() {
        return -1;
    }

    public T getResult() {
        if (!this.isDone()) {
            return null;
        }
        return this.result;
    }

    public static Token<?> getNextToken(ReadableByteChannel chan) throws IOException {
        byte[] b = new byte[1];
        ByteBuffer one_byte = ByteBuffer.wrap(b);
        int read = chan.read(one_byte);
        if (read == 0) {
            return null;
        }
        if (read == -1) {
            throw new EOFException("Could not read next Token");
        }
        if (b[0] == BEncoder.I) {
            return new BELong(chan);
        }
        if (b[0] == BEncoder.R) {
            return new BERational(chan);
        }
        if (b[0] == BEncoder.D) {
            return new BEDictionary(chan);
        }
        if (b[0] == BEncoder.L) {
            return new BEList(chan);
        }
        if (b[0] == BEncoder.E) {
            return TERMINATOR;
        }
        if (b[0] >= ZERO && b[0] <= NINE) {
            return new BEString(b[0], chan);
        }
        if (b[0] == BEncoder.TRUE || b[0] == BEncoder.FALSE) {
            return b[0] == BEncoder.TRUE ? BEBoolean.TRUE : BEBoolean.FALSE;
        }
        throw new IOException("unrecognized token type " + (char)b[0]);
    }

    public static Object parse(byte[] data) throws IOException {
        Token<?> t = Token.getNextToken(new BufferChannel(data));
        if (t == null) {
            return null;
        }
        t.handleRead();
        return t.getResult();
    }

    static {
        byte zero = 0;
        byte nine = 0;
        try {
            zero = "0".getBytes(ASCII)[0];
            nine = "9".getBytes(ASCII)[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ZERO = zero;
        NINE = nine;
        TERMINATOR = new EndElement();
    }

    private static class BufferChannel
    implements ReadableByteChannel {
        private final ByteBuffer src;

        BufferChannel(byte[] data) {
            this.src = ByteBuffer.wrap(data);
        }

        public int read(ByteBuffer dst) throws IOException {
            int ret = BufferUtils.transfer(this.src, dst, false);
            if (ret == 0 && !this.src.hasRemaining()) {
                return -1;
            }
            return ret;
        }

        public void close() throws IOException {
        }

        public boolean isOpen() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EndElement
    extends Token<EndElement> {
        EndElement() {
            super(null);
            this.result = this;
        }

        @Override
        public void handleRead() throws IOException {
        }

        @Override
        protected boolean isDone() {
            return true;
        }
    }
}

