/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.choking;

import com.limegroup.bittorrent.Chokable;
import com.limegroup.bittorrent.choking.Choker;
import com.limegroup.bittorrent.settings.BittorrentSettings;
import com.limegroup.gnutella.UploadServices;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.limewire.collection.NECallable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LeechChoker
extends Choker {
    private static final Comparator<Chokable> DOWNLOAD_SPEED_COMPARATOR = new Choker.SpeedComparator(true);

    LeechChoker(NECallable<List<? extends Chokable>> chokables, ScheduledExecutorService invoker, UploadServices uploadServices) {
        super(chokables, invoker, uploadServices);
    }

    @Override
    protected void rechokeImpl(boolean force) {
        List chokables = (List)this.chokablesSource.call();
        ArrayList<Chokable> fastest = new ArrayList<Chokable>(chokables.size());
        for (Chokable con : chokables) {
            if (!con.isInterested() || !con.shouldBeInterested() || !((double)con.getMeasuredBandwidth(true, false) > 0.256)) continue;
            fastest.add(con);
        }
        Collections.sort(fastest, DOWNLOAD_SPEED_COMPARATOR);
        int numFast = this.getNumUploads() - 1;
        for (int i = fastest.size() - 1; i >= numFast; --i) {
            fastest.remove(i);
        }
        int optimistic = Math.max(1, BittorrentSettings.TORRENT_MIN_UPLOADS.getValue() - fastest.size());
        Collections.shuffle(chokables);
        for (Chokable con : chokables) {
            if (fastest.remove(con)) {
                con.unchoke(this.round);
                continue;
            }
            if (optimistic > 0 && con.shouldBeInterested()) {
                boolean wasChoked = con.isChoked();
                con.unchoke(this.round);
                if (!con.isInterested() || !wasChoked) continue;
                --optimistic;
                continue;
            }
            con.choke();
        }
    }
}

