/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.choking;

import com.limegroup.bittorrent.Chokable;
import com.limegroup.bittorrent.choking.Choker;
import com.limegroup.gnutella.UploadServices;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.limewire.collection.NECallable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SeedChoker
extends Choker {
    private static final Comparator<Chokable> UPLOAD_SPEED_COMPARATOR = new Choker.SpeedComparator(false);
    private static final Comparator<Chokable> UNCHOKE_COMPARATOR = new UnchokeComparator();
    private int unchokesSinceLast;

    SeedChoker(NECallable<List<? extends Chokable>> chokables, ScheduledExecutorService invoker, UploadServices uploadServices) {
        super(chokables, invoker, uploadServices);
        this.round = Integer.MIN_VALUE;
    }

    private void initRound(List<? extends Chokable> chokables) {
        if (this.round >= 0) {
            return;
        }
        int maxRound = 0;
        for (Chokable chokable : chokables) {
            maxRound = Math.max(maxRound, chokable.getUnchokeRound());
        }
        this.round = maxRound;
    }

    @Override
    protected void rechokeImpl(boolean forceUnchokes) {
        List chokables = (List)this.chokablesSource.call();
        this.initRound(chokables);
        int numForceUnchokes = 0;
        if (forceUnchokes) {
            int x = (this.getNumUploads() + 2) / 3;
            numForceUnchokes = Math.max(0, x + this.round % 3) / 3 - this.unchokesSinceLast;
        }
        List<Chokable> preferred = new ArrayList();
        int newLimit = this.round - 3;
        for (Chokable con : chokables) {
            if (con.isChoked() || !con.isInterested() || !con.shouldBeInterested()) continue;
            if (con.getUnchokeRound() < newLimit) {
                con.clearUnchokeRound();
            }
            preferred.add(con);
        }
        int numKept = this.getNumUploads() - numForceUnchokes;
        if (preferred.size() > numKept) {
            Collections.sort(preferred, UNCHOKE_COMPARATOR);
            preferred = preferred.subList(0, numKept);
        }
        int numNonPref = this.getNumUploads() - preferred.size();
        this.unchokesSinceLast = forceUnchokes ? 0 : (this.unchokesSinceLast += numNonPref);
        for (Chokable con : chokables) {
            if (preferred.contains(con)) continue;
            if (!con.isInterested()) {
                con.choke();
                continue;
            }
            if (con.isChoked() && numNonPref > 0 && con.shouldBeInterested()) {
                con.unchoke(this.round);
                --numNonPref;
                continue;
            }
            if (numNonPref == 0 || !con.shouldBeInterested()) {
                con.choke();
                continue;
            }
            --numNonPref;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnchokeComparator
    implements Comparator<Chokable> {
        private UnchokeComparator() {
        }

        @Override
        public int compare(Chokable con1, Chokable con2) {
            if (con1 == con2) {
                return 0;
            }
            if (con1.getUnchokeRound() != con2.getUnchokeRound()) {
                return -1 * (con1.getUnchokeRound() - con2.getUnchokeRound());
            }
            return UPLOAD_SPEED_COMPARATOR.compare(con1, con2);
        }
    }
}

