/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.dht;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.bittorrent.ManagedTorrent;
import com.limegroup.bittorrent.TorrentEvent;
import com.limegroup.bittorrent.TorrentEventListener;
import com.limegroup.bittorrent.TorrentLocation;
import com.limegroup.bittorrent.TorrentManager;
import com.limegroup.bittorrent.dht.DHTPeerLocator;
import com.limegroup.bittorrent.dht.DHTPeerLocatorUtils;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.dht.DHTEvent;
import com.limegroup.gnutella.dht.DHTEventListener;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.dht.util.KUIDUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.InvalidDataException;
import org.limewire.mojito.EntityKey;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureAdapter;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.result.FindValueResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DHTPeerLocatorImpl
implements DHTPeerLocator {
    private static final Log LOG = LogFactory.getLog(DHTPeerLocator.class);
    private final Provider<DHTManager> dhtManager;
    private final Provider<TorrentManager> torrentManager;
    private final List<URN> torrentsWaitingForDHTList = new ArrayList<URN>();

    @Inject
    DHTPeerLocatorImpl(Provider<DHTManager> dhtManager, Provider<TorrentManager> torrentManager) {
        this.dhtManager = dhtManager;
        this.torrentManager = torrentManager;
    }

    @Override
    public void init() {
        this.torrentManager.get().addEventListener(new LocatorTorrentEventListener());
        this.dhtManager.get().addEventListener(new DHTEventListenerForLocator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void locatePeer(URN urn) {
        LOG.debug("In locatePeer");
        if (this.torrentManager.get().getTorrentForURN(urn) != null) {
            List<URN> list = this.torrentsWaitingForDHTList;
            synchronized (list) {
                if (!this.torrentsWaitingForDHTList.contains(urn)) {
                    LOG.debug("Passed Initial checks");
                    KUID key = KUIDUtils.toKUID(urn);
                    EntityKey eKey = EntityKey.createEntityKey(key, DHTPeerLocatorUtils.BT_PEER_TRIPLE);
                    DHTFuture<FindValueResult> future = this.dhtManager.get().get(eKey);
                    if (future == null) {
                        this.torrentsWaitingForDHTList.add(urn);
                    } else {
                        future.addDHTFutureListener(new LocatePeerResultHandler(urn));
                        LOG.debug("Future Listener added");
                    }
                }
            }
        }
    }

    private void dispatch(ManagedTorrent managedTorrent, DHTValueEntity entity) {
        DHTValue value = entity.getValue();
        LOG.debug("dispatch entered");
        try {
            TorrentLocation torLoc = DHTPeerLocatorUtils.decode(value.getValue());
            managedTorrent.addEndpoint(torLoc);
            if (LOG.isDebugEnabled()) {
                LOG.debug("IP:PORT of found: " + torLoc.getAddress() + ":" + torLoc.getPort());
            }
        }
        catch (IllegalArgumentException iae) {
            LOG.error("Invalid payload");
        }
        catch (InvalidDataException ide) {
            LOG.error("Invalid network information");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LocatePeerResultHandler
    extends DHTFutureAdapter<FindValueResult> {
        private final URN urn;

        public LocatePeerResultHandler(URN urn) {
            this.urn = urn;
        }

        @Override
        public void handleFutureSuccess(FindValueResult result) {
            LOG.debug("handle result");
            ManagedTorrent managedTorrent = ((TorrentManager)DHTPeerLocatorImpl.this.torrentManager.get()).getTorrentForURN(this.urn);
            if (result.isSuccess() && managedTorrent != null) {
                LOG.debug("successful result");
                for (DHTValueEntity dHTValueEntity : result.getEntities()) {
                    DHTPeerLocatorImpl.this.dispatch(managedTorrent, dHTValueEntity);
                }
                for (EntityKey entityKey : result.getEntityKeys()) {
                    DHTFuture<FindValueResult> future;
                    if (!entityKey.getDHTValueType().equals(DHTPeerLocatorUtils.BT_PEER_TRIPLE) || (future = ((DHTManager)DHTPeerLocatorImpl.this.dhtManager.get()).get(entityKey)) == null) continue;
                    try {
                        FindValueResult resultFromKey = (FindValueResult)future.get();
                        if (!resultFromKey.isSuccess()) continue;
                        for (DHTValueEntity dHTValueEntity : resultFromKey.getEntities()) {
                            DHTPeerLocatorImpl.this.dispatch(managedTorrent, dHTValueEntity);
                        }
                    }
                    catch (ExecutionException e) {
                        LOG.error("ExecutionException", e);
                    }
                    catch (InterruptedException e) {
                        LOG.error("InterruptedException", e);
                    }
                }
            }
        }
    }

    private class DHTEventListenerForLocator
    implements DHTEventListener {
        private DHTEventListenerForLocator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleDHTEvent(DHTEvent evt) {
            if (evt.getType() == DHTEvent.Type.CONNECTED) {
                List torrentsWaitingForDHTListCopy;
                LOG.debug("DHT available");
                List list = DHTPeerLocatorImpl.this.torrentsWaitingForDHTList;
                synchronized (list) {
                    torrentsWaitingForDHTListCopy = DHTPeerLocatorImpl.this.torrentsWaitingForDHTList;
                    DHTPeerLocatorImpl.this.torrentsWaitingForDHTList.clear();
                }
                for (int i = 0; i < torrentsWaitingForDHTListCopy.size(); ++i) {
                    DHTPeerLocatorImpl.this.locatePeer((URN)torrentsWaitingForDHTListCopy.get(i));
                }
            }
        }
    }

    private class LocatorTorrentEventListener
    implements TorrentEventListener {
        private LocatorTorrentEventListener() {
        }

        public void handleTorrentEvent(TorrentEvent evt) {
            if (evt.getType() == TorrentEvent.Type.TRACKER_FAILED) {
                LOG.debug("TRACKER_FAILED_EVENT");
                DHTPeerLocatorImpl.this.locatePeer(evt.getTorrent().getMetaInfo().getURN());
            }
        }
    }
}

