/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.dht;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.bittorrent.TorrentEvent;
import com.limegroup.bittorrent.TorrentEventListener;
import com.limegroup.bittorrent.TorrentLocation;
import com.limegroup.bittorrent.TorrentManager;
import com.limegroup.bittorrent.dht.DHTPeerLocatorUtils;
import com.limegroup.bittorrent.dht.DHTPeerPublisher;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.dht.DHTEvent;
import com.limegroup.gnutella.dht.DHTEventListener;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.dht.util.KUIDUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.NetworkUtils;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureAdapter;
import org.limewire.mojito.db.impl.DHTValueImpl;
import org.limewire.mojito.result.StoreResult;
import org.limewire.mojito.routing.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DHTPeerPublisherImpl
implements DHTPeerPublisher {
    private static final Log LOG = LogFactory.getLog(DHTPeerPublisher.class);
    private final Provider<DHTManager> dhtManager;
    private final Provider<ApplicationServices> applicationServices;
    private final Provider<NetworkManager> networkManager;
    private final Provider<TorrentManager> torrentManager;
    private final Map<URN, Long> publishedTorrents = new HashMap<URN, Long>();
    private final List<URN> torrentsWaitingForDHTList = new ArrayList<URN>();

    @Inject
    DHTPeerPublisherImpl(Provider<DHTManager> dhtManager, Provider<ApplicationServices> applicationServices, Provider<NetworkManager> networkManager, Provider<TorrentManager> torrentManager) {
        this.dhtManager = dhtManager;
        this.applicationServices = applicationServices;
        this.networkManager = networkManager;
        this.torrentManager = torrentManager;
    }

    @Override
    public void init() {
        this.torrentManager.get().addEventListener(new TorrentEventListenerForPublisher());
        this.dhtManager.get().addEventListener(new DHTEventListenerForPublisher());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publishYourself(URN urn) {
        LOG.debug("In publishYourself");
        if (this.networkManager.get().acceptedIncomingConnection() && this.torrentManager.get().getTorrentForURN(urn) != null && !this.isPublished(urn)) {
            List<URN> list = this.torrentsWaitingForDHTList;
            synchronized (list) {
                if (!this.torrentsWaitingForDHTList.contains(urn)) {
                    LOG.debug("Passed Initial checks");
                    try {
                        TorrentLocation torLoc = new TorrentLocation(InetAddress.getByName(NetworkUtils.ip2string(this.networkManager.get().getAddress())), this.networkManager.get().getPort(), this.applicationServices.get().getMyBTGUID());
                        byte[] msg = DHTPeerLocatorUtils.encode(torLoc);
                        KUID key = KUIDUtils.toKUID(urn);
                        if (msg.length != 0) {
                            DHTFuture<StoreResult> future = this.dhtManager.get().put(key, new DHTValueImpl(DHTPeerLocatorUtils.BT_PEER_TRIPLE, Version.ZERO, msg));
                            if (future == null) {
                                this.torrentsWaitingForDHTList.add(urn);
                            } else {
                                future.addDHTFutureListener(new PublishYourselfResultHandler(urn));
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("IP:PORT of peer published: " + torLoc.getAddress() + ":" + torLoc.getPort());
                                }
                            }
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        LOG.error("Invalid network information", iae);
                    }
                    catch (UnknownHostException uhe) {
                        LOG.error("Invalid IP address");
                    }
                }
            }
        }
    }

    private boolean isPublished(URN urn) {
        return this.publishedTorrents.containsKey(urn);
    }

    private void addAsPublished(URN urn, Long time) {
        this.publishedTorrents.put(urn, time);
        LOG.debug("published");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PublishYourselfResultHandler
    extends DHTFutureAdapter<StoreResult> {
        private final URN urn;

        public PublishYourselfResultHandler(URN urn) {
            this.urn = urn;
        }

        @Override
        public void handleFutureSuccess(StoreResult result) {
            DHTPeerPublisherImpl.this.addAsPublished(this.urn, new Long(System.currentTimeMillis()));
        }
    }

    private class DHTEventListenerForPublisher
    implements DHTEventListener {
        private DHTEventListenerForPublisher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleDHTEvent(DHTEvent evt) {
            if (evt.getType() == DHTEvent.Type.CONNECTED) {
                List torrentsWaitingForDHTListCopy;
                List list = DHTPeerPublisherImpl.this.torrentsWaitingForDHTList;
                synchronized (list) {
                    torrentsWaitingForDHTListCopy = DHTPeerPublisherImpl.this.torrentsWaitingForDHTList;
                    DHTPeerPublisherImpl.this.torrentsWaitingForDHTList.clear();
                }
                for (int i = 0; i < torrentsWaitingForDHTListCopy.size(); ++i) {
                    DHTPeerPublisherImpl.this.publishYourself((URN)torrentsWaitingForDHTListCopy.get(i));
                }
            }
        }
    }

    private class TorrentEventListenerForPublisher
    implements TorrentEventListener {
        private TorrentEventListenerForPublisher() {
        }

        public void handleTorrentEvent(TorrentEvent evt) {
            if (evt.getType() == TorrentEvent.Type.FIRST_CHUNK_VERIFIED) {
                LOG.debug("FIRST_CHUNK_VERIFIED_EVENT");
                DHTPeerPublisherImpl.this.publishYourself(evt.getTorrent().getMetaInfo().getURN());
            }
        }
    }
}

