/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.disk;

import com.limegroup.bittorrent.disk.RAFDiskController;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MMDiskController<F extends File>
extends RAFDiskController<F> {
    private static final Log LOG = LogFactory.getLog(MMDiskController.class);
    private Map<RandomAccessFile, MappedByteBuffer> bufMap;

    @Override
    public synchronized List<F> open(List<F> files, boolean complete, boolean isVerifying) throws IOException {
        List<F> ret = super.open(files, complete, isVerifying);
        this.bufMap = new HashMap<RandomAccessFile, MappedByteBuffer>(files.size());
        for (int i = 0; i < this._fos.length; ++i) {
            if (((File)this._files.get(i)).length() >= Integer.MAX_VALUE) continue;
            try {
                this.bufMap.put(this._fos[i], this._fos[i].getChannel().map(complete ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, 0L, ((File)this._files.get(i)).length()));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("mapped " + this._files.get(i));
                continue;
            }
            catch (IOException mapFailed) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("didn't map " + this._files.get(i), mapFailed);
            }
        }
        return ret;
    }

    @Override
    protected void writeImpl(RandomAccessFile f, long fileOffset, byte[] data, int offset, int length) throws IOException {
        MappedByteBuffer buf = this.getBuf(f);
        if (buf == null) {
            super.writeImpl(f, fileOffset, data, offset, length);
            return;
        }
        buf.position((int)fileOffset);
        buf.put(data, offset, length);
    }

    @Override
    protected int readImpl(RandomAccessFile raf, long fileOffset, byte[] dst, int offset, int length) throws IOException {
        MappedByteBuffer buf = this.getBuf(raf);
        if (buf == null) {
            return super.readImpl(raf, fileOffset, dst, offset, length);
        }
        buf.position((int)fileOffset);
        buf.get(dst, offset, length);
        return buf.position() - (int)fileOffset;
    }

    private synchronized MappedByteBuffer getBuf(RandomAccessFile f) {
        return this.bufMap.get(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        LOG.debug("closing...");
        boolean allCleaned = false;
        try {
            if (this.bufMap != null) {
                boolean cleaned = true;
                for (MappedByteBuffer mbb : this.bufMap.values()) {
                    this.safeForce(mbb);
                    cleaned = cleaned && MMDiskController.clean(mbb);
                }
                allCleaned = cleaned;
            }
        }
        finally {
            if (this.bufMap != null) {
                this.bufMap.clear();
            }
            if (!allCleaned) {
                System.gc();
            }
            super.close();
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.bufMap == null) {
            return;
        }
        for (MappedByteBuffer buf : this.bufMap.values()) {
            buf.force();
        }
        super.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized RandomAccessFile setReadOnly(RandomAccessFile raf, String path) throws IOException {
        MappedByteBuffer buf = this.bufMap.remove(raf);
        try {
            this.safeForce(buf);
        }
        finally {
            if (!MMDiskController.clean(buf)) {
                buf = null;
                System.gc();
            }
        }
        raf = super.setReadOnly(raf, path);
        buf = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, raf.length());
        this.bufMap.put(raf, buf);
        return raf;
    }

    private void safeForce(MappedByteBuffer buf) {
        try {
            buf.force();
        }
        catch (Exception iox) {
            if (iox instanceof IOException) {
                return;
            }
            RuntimeException r = iox instanceof RuntimeException ? (RuntimeException)iox : new RuntimeException(iox);
            throw r;
        }
    }

    public static boolean clean(final Object buffer) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    Method getCleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
                    if (getCleanerMethod == null) {
                        return false;
                    }
                    getCleanerMethod.setAccessible(true);
                    Object cleaner = getCleanerMethod.invoke(buffer, new Object[0]);
                    if (cleaner == null) {
                        return false;
                    }
                    Method cleanMethod = cleaner.getClass().getMethod("clean", new Class[0]);
                    cleanMethod.invoke(cleaner, new Object[0]);
                    return true;
                }
                catch (SecurityException e) {
                    LOG.warn("security", e);
                }
                catch (InvocationTargetException e) {
                    LOG.warn("invocation", e);
                }
                catch (NoSuchMethodException e) {
                    LOG.warn("no method", e);
                }
                catch (IllegalAccessException e) {
                    LOG.warn("illegal access", e);
                }
                return false;
            }
        });
    }
}

