/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.disk;

import com.limegroup.bittorrent.BTInterval;
import com.limegroup.bittorrent.BTMetaInfo;
import com.limegroup.bittorrent.BTPiece;
import com.limegroup.bittorrent.PieceReadListener;
import com.limegroup.bittorrent.TorrentContext;
import com.limegroup.bittorrent.TorrentFile;
import com.limegroup.bittorrent.TorrentFileSystem;
import com.limegroup.bittorrent.disk.DiskController;
import com.limegroup.bittorrent.disk.DiskManagerListener;
import com.limegroup.bittorrent.disk.TorrentDiskManager;
import com.limegroup.bittorrent.settings.BittorrentSettings;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.serial.BTDiskManagerMemento;
import com.limegroup.gnutella.downloader.serial.BTDiskManagerMementoImpl;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.MessageDigest;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.AndView;
import org.limewire.collection.BitField;
import org.limewire.collection.BitFieldSet;
import org.limewire.collection.BitSet;
import org.limewire.collection.IntervalSet;
import org.limewire.collection.MultiIterable;
import org.limewire.collection.NECallable;
import org.limewire.collection.NotView;
import org.limewire.collection.RRProcessingQueue;
import org.limewire.collection.Range;
import org.limewire.io.DiskException;
import org.limewire.service.ErrorService;
import org.limewire.util.SystemUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VerifyingFolder
implements TorrentDiskManager {
    private static final Log LOG = LogFactory.getLog(VerifyingFolder.class);
    private static final RRProcessingQueue QUEUE = new RRProcessingQueue("TorrentDiskQueue");
    private static final RRProcessingQueue VERIFY_QUEUE = new RRProcessingQueue("TorrentVerifier");
    private static final int BLOCK_SIZE = 16384;
    private final List<TorrentFile> _files;
    private BlockRangeMap partialBlocks;
    private BlockRangeMap requestedRanges;
    private Iterable<Integer> requestedAndPartial;
    private BlockRangeMap pendingRanges;
    private BitSet verifiedBlocks;
    private BitField missing;
    private BitField verified;
    private byte[] bitField;
    private boolean bitFieldDirty = true;
    private long _corruptedBytes;
    private final TorrentContext context;
    private volatile IOException storedException;
    private volatile DiskManagerListener listener;
    private volatile boolean isVerifying;
    private final DiskController<TorrentFile> diskController;
    private volatile long lastVerifiedOffset;

    VerifyingFolder(TorrentContext context, boolean complete, BTDiskManagerMemento data, DiskController<TorrentFile> diskController) {
        TorrentFileSystem system = context.getFileSystem();
        this._files = complete ? system.getFiles() : system.getIncompleteFiles();
        this.context = context;
        this._corruptedBytes = 0L;
        this.partialBlocks = new BlockRangeMap();
        this.requestedRanges = new BlockRangeMap();
        this.pendingRanges = new BlockRangeMap();
        this.diskController = diskController;
        this.requestedAndPartial = new MultiIterable(this.partialBlocks.keySet(), this.requestedRanges.keySet());
        if (complete) {
            this.verifiedBlocks = context.getFullBitSet();
            this.verified = context.getFullBitField();
        } else {
            this.verifiedBlocks = new BitSet(context.getMetaInfo().getNumBlocks());
            if (data != null) {
                this.initialize(data);
            }
            this.verified = new BitFieldSet(this.verifiedBlocks, context.getMetaInfo().getNumBlocks());
        }
        this.missing = new NotView(this.verified);
    }

    private void initialize(BTDiskManagerMemento data) {
        if (data.getPartialBlocks() != null) {
            this.partialBlocks.putAll(data.getPartialBlocks());
        }
        if (data.getVerifiedBlocks() != null) {
            this.verifiedBlocks = data.getVerifiedBlocks();
        }
        this.isVerifying = data.isVerifying();
    }

    @Override
    public void writeBlock(NECallable<BTPiece> factory) {
        if (this.storedException != null) {
            return;
        }
        QUEUE.execute(new WriteJob(factory), this.context.getMetaInfo().getURN());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBlockImpl(BTInterval in, byte[] buf) throws IOException {
        long startOffset = (long)in.getId() * (long)this.context.getMetaInfo().getPieceLength() + in.getLow();
        this.diskController.write(startOffset, buf);
        VerifyingFolder verifyingFolder = this;
        synchronized (verifyingFolder) {
            this.pendingRanges.removeInterval(in);
            this.partialBlocks.addInterval(in);
            if (!this.isCompleteBlock(in.getId(), this.partialBlocks)) {
                return;
            }
        }
        boolean verified = this.verifyQuick(in.getId());
        VerifyingFolder verifyingFolder2 = this;
        synchronized (verifyingFolder2) {
            this.partialBlocks.remove(in.getId());
            if (verified) {
                this.markPieceCompleted(in.getId());
            } else {
                this._corruptedBytes += (long)this.getPieceSize(in.getId());
            }
        }
        if (verified) {
            this.handleVerified(in.getId());
        }
    }

    private synchronized void markPieceCompleted(int blockId) {
        int i;
        this.partialBlocks.remove(blockId);
        this.requestedRanges.remove(blockId);
        this.verifiedBlocks.set(blockId);
        this.bitFieldDirty = true;
        if (this.verifiedBlocks.cardinality() == this.context.getMetaInfo().getNumBlocks()) {
            this.verifiedBlocks = this.context.getFullBitSet();
            this.verified = this.context.getFullBitField();
            this.missing = new NotView(this.verified);
        }
        if (this.context.getFileSystem().getFiles().size() != 1) {
            return;
        }
        long length = this.context.getMetaInfo().getPieceLength();
        for (i = (int)(this.lastVerifiedOffset / length); i < this.verified.maxSize() && this.verified.get(i); ++i) {
        }
        this.lastVerifiedOffset = Math.min(this.context.getFileSystem().getTotalSize(), (long)i * length);
    }

    private boolean verifyQuick(int pieceNum) throws IOException {
        try {
            return this.verify(pieceNum, false);
        }
        catch (InterruptedException impossible) {
            ErrorService.error(impossible);
            return false;
        }
    }

    private boolean verify(int pieceNum, boolean slow) throws IOException, InterruptedException {
        MessageDigest md = this.context.getMetaInfo().getMessageDigest();
        md.reset();
        int pieceSize = this.getPieceSize(pieceNum);
        byte[] buf = new byte[Math.min(65536, pieceSize)];
        int read = 0;
        long offset = (long)pieceNum * (long)this.context.getMetaInfo().getPieceLength();
        while (read < pieceSize) {
            int readNow = this.diskController.read(offset, buf, 0, buf.length);
            if (readNow == 0) {
                return false;
            }
            long start = System.nanoTime();
            md.update(buf, 0, readNow);
            if (slow && SystemUtils.getIdleTime() < 300000L && SharingSettings.FRIENDLY_HASHING.getValue()) {
                long interval = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
                if ((interval *= QUEUE.size() > 0 ? 5L : 3L) > 0L) {
                    Thread.sleep(interval);
                } else {
                    Thread.yield();
                }
            }
            read += readNow;
            offset += (long)readNow;
        }
        byte[] sha1 = md.digest();
        return this.context.getMetaInfo().verify(sha1, pieceNum);
    }

    private void handleVerified(int pieceNum) throws IOException {
        this.closeAnyCompletedFiles(pieceNum);
        this.notifyOfChunkCompletion(pieceNum);
    }

    private void notifyOfChunkCompletion(int pieceNum) {
        DiskManagerListener t = this.listener;
        if (t != null) {
            t.chunkVerified(pieceNum);
        }
    }

    private void closeAnyCompletedFiles(int pieceNum) throws IOException {
        ArrayList<TorrentFile> possiblyCompleted = null;
        for (TorrentFile t : this._files) {
            if (t.getBegin() > pieceNum) continue;
            if (t.getEnd() < pieceNum) break;
            if (possiblyCompleted == null) {
                possiblyCompleted = new ArrayList<TorrentFile>();
            }
            possiblyCompleted.add(t);
        }
        if (possiblyCompleted == null) {
            return;
        }
        for (TorrentFile file : possiblyCompleted) {
            boolean done = true;
            for (int i = file.getBegin(); i <= file.getEnd(); ++i) {
                if (this.hasBlock(i)) continue;
                done = false;
                break;
            }
            if (!done) continue;
            this.diskController.setReadOnly(file);
        }
    }

    private boolean isCompleteBlock(Range in, int id) {
        return in.getLow() == 0L && in.getHigh() == (long)(this.getPieceSize(id) - 1);
    }

    @Override
    public synchronized boolean hasBlock(int block) {
        return this.verified.get(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(final DiskManagerListener torrent) throws IOException {
        this.listener = torrent;
        this.storedException = null;
        boolean wasVerifying = this.isVerifying;
        this.isVerifying |= this.getBlockSize() == 0L;
        List<TorrentFile> filesToVerify = this.diskController.open(this._files, this.isComplete(), this.isVerifying);
        if (filesToVerify != null) {
            this.isVerifying = true;
            if (!wasVerifying) {
                VerifyingFolder verifyingFolder = this;
                synchronized (verifyingFolder) {
                    this.verifiedBlocks.clear();
                    this.partialBlocks.clear();
                }
            }
            this.verifyFiles(filesToVerify);
        } else {
            this.isVerifying = false;
        }
        Iterator i$ = this.partialBlocks.keySet().iterator();
        while (i$.hasNext()) {
            int block = (Integer)i$.next();
            if (!this.isCompleteBlock(block, this.partialBlocks)) continue;
            this.isVerifying = true;
            VERIFY_QUEUE.execute(new VerifyJob(block), this.context.getMetaInfo().getURN());
        }
        if (this.isVerifying) {
            VERIFY_QUEUE.execute(new Runnable(){

                public void run() {
                    if (VerifyingFolder.this.isOpen()) {
                        VerifyingFolder.this.isVerifying = false;
                        VerifyingFolder.this._corruptedBytes = 0L;
                        torrent.verificationComplete();
                    }
                }
            }, this.context.getMetaInfo().getURN());
        }
    }

    @Override
    public boolean isVerifying() {
        return this.isVerifying;
    }

    @Override
    public synchronized boolean isComplete() {
        return this.verified == this.context.getFullBitField();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LOG.debug("closing the file");
        VerifyingFolder verifyingFolder = this;
        synchronized (verifyingFolder) {
            this.pendingRanges.clear();
        }
        this.diskController.close();
        this.listener = null;
        URN urn = this.context.getMetaInfo().getURN();
        VERIFY_QUEUE.clear(urn);
        QUEUE.clear(urn);
    }

    @Override
    public boolean isOpen() {
        return this.diskController != null & this.diskController.isOpen();
    }

    @Override
    public void requestPieceRead(BTInterval in, PieceReadListener c) {
        if (this.storedException != null) {
            return;
        }
        QUEUE.execute(new SendJob(in, c), this.context.getMetaInfo().getURN());
    }

    private void notifyDiskProblem(IOException e) {
        DiskManagerListener t = this.listener;
        if (t != null) {
            t.diskExceptionHappened(new DiskException(e));
        }
    }

    @Override
    public synchronized BTInterval leaseRandom(BitField bs, Set<BTInterval> exclude) {
        AndView interesting;
        BTInterval leased;
        if (this.isComplete()) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("leasing random chunk from available cardinality " + bs.cardinality());
        }
        if ((leased = this.findRandom(interesting = new AndView(bs, this.missing), exclude)) != null) {
            if (leased.getHigh() - leased.getLow() + 1L > 16384L) {
                leased = new BTInterval(leased.getLow(), leased.getLow() + 16384L - 1L, leased.getId());
            }
            this.requestedRanges.addInterval(leased);
            if (LOG.isDebugEnabled()) {
                LOG.debug("assigning " + leased);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("couldn't find anything to assign " + exclude);
        }
        return leased;
    }

    private BTInterval findRandom(BitField bs, Set<BTInterval> exclude) {
        BTInterval ret = this.assignEndgame(bs, exclude, false);
        if (ret != null) {
            return ret;
        }
        LOG.debug("couldn't find partial, looking for unnassigned");
        ret = this.findUnassigned(bs);
        if (ret != null) {
            return ret;
        }
        LOG.debug("couldn't find unassigned, looking for already requested");
        return this.assignEndgame(bs, exclude, true);
    }

    private BTInterval findUnassigned(BitField available) {
        int selected = -1;
        int current = 1;
        int i = available.nextSetBit(0);
        while (i >= 0) {
            if (!(this.pendingRanges.containsKey(i) || this.partialBlocks.containsKey(i) || this.requestedRanges.containsKey(i))) {
                int n = current++;
                if (Math.random() < (double)(1.0f / (float)n)) {
                    selected = i;
                }
            }
            i = available.nextSetBit(i + 1);
        }
        if (selected == -1) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("selecting unassigned piece " + selected);
        }
        return new BTInterval(0L, this.getPieceSize(selected) - 1, selected);
    }

    private BTInterval assignEndgame(BitField bs, Set<BTInterval> exclude, boolean endgame) {
        BTInterval ret = null;
        AbstractCollection available = null;
        for (int requested : this.requestedAndPartial) {
            if (!bs.get(requested) || !endgame && this.isCompleteBlock(requested, this.requestedRanges) || this.isCompleteBlock(requested, this.partialBlocks)) continue;
            if (available == null) {
                available = new HashSet(this.requestedRanges.size() + this.partialBlocks.size());
            }
            available.add(requested);
        }
        if (available == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("available partial and requested blocks to attempt: " + available);
        }
        available = new ArrayList<Integer>(available);
        Collections.shuffle((List)((Object)available));
        Iterator iterator = available.iterator();
        while (iterator.hasNext() && ret == null) {
            int block = (Integer)iterator.next();
            IntervalSet needed = new IntervalSet();
            needed = needed.invert(this.getPieceSize(block));
            IntervalSet partial = (IntervalSet)this.partialBlocks.get(block);
            IntervalSet pending = (IntervalSet)this.pendingRanges.get(block);
            IntervalSet requested = (IntervalSet)this.requestedRanges.get(block);
            if (partial != null) {
                needed.delete(partial);
            }
            if (pending != null) {
                needed.delete(pending);
            }
            for (BTInterval excluded : exclude) {
                needed.delete(excluded);
            }
            if (requested != null) {
                needed.delete(requested);
                if (endgame && needed.isEmpty() && !iterator.hasNext()) {
                    LOG.debug("endgame");
                    needed = requested.clone();
                    for (BTInterval excluded : exclude) {
                        needed.delete(excluded);
                    }
                }
            }
            if (needed.isEmpty()) continue;
            ret = new BTInterval(needed.getFirst(), block);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("selected partial/requested interval " + ret + " with partial " + this.partialBlocks.get(ret.getId()) + " requested " + this.requestedRanges.get(ret.getId()) + " pending " + this.pendingRanges.get(ret.getId()));
        }
        return ret;
    }

    private boolean isCompleteBlock(int pieceNum, BlockRangeMap toCheck) {
        IntervalSet set = (IntervalSet)toCheck.get(pieceNum);
        if (set == null) {
            return false;
        }
        if (set.getNumberOfIntervals() != 1) {
            return false;
        }
        Range i = set.getFirst();
        return this.isCompleteBlock(i, pieceNum);
    }

    private int getPieceSize(int pieceNum) {
        int ret;
        BTMetaInfo info = this.context.getMetaInfo();
        if (pieceNum == info.getNumBlocks() - 1 && (ret = (int)(this.context.getFileSystem().getTotalSize() % (long)info.getPieceLength())) != 0) {
            return ret;
        }
        return info.getPieceLength();
    }

    @Override
    public synchronized void releaseInterval(BTInterval in) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("releasing " + in);
        }
        this.requestedRanges.removeInterval(in);
    }

    @Override
    public synchronized byte[] createBitField() {
        if (this.bitField == null) {
            this.bitField = new byte[(this.context.getMetaInfo().getNumBlocks() + 7) / 8];
        }
        if (this.bitFieldDirty) {
            if (this.isComplete()) {
                for (int i = 0; i < this.bitField.length; ++i) {
                    this.bitField[i] = -1;
                }
                int odd = this.context.getMetaInfo().getNumBlocks() % 8;
                if (odd != 0) {
                    int n = this.bitField.length - 1;
                    this.bitField[n] = (byte)(this.bitField[n] << 8 - odd);
                }
            } else {
                int i = this.verified.nextSetBit(0);
                while (i >= 0) {
                    this.bitField[i / 8] = (byte)(this.bitField[i / 8] | 1 << 7 - i % 8);
                    i = this.verified.nextSetBit(i + 1);
                }
            }
            this.bitFieldDirty = false;
        }
        return this.bitField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyFiles(List<TorrentFile> l) {
        VerifyingFolder verifyingFolder = this;
        synchronized (verifyingFolder) {
            int lastSet = this.verifiedBlocks.length();
        }
        for (TorrentFile f : l) {
            for (int i = Math.max(lastSet, f.getBegin()); i <= f.getEnd(); ++i) {
                VERIFY_QUEUE.execute(new VerifyJob(i), this.context.getMetaInfo().getURN());
            }
        }
    }

    @Override
    public synchronized long getVerifiedBlockSize() {
        BTMetaInfo info = this.context.getMetaInfo();
        long ret = (long)this.verified.cardinality() * (long)info.getPieceLength();
        if (this.verified.get(info.getNumBlocks() - 1)) {
            ret = ret - (long)info.getPieceLength() + (long)this.getPieceSize(info.getNumBlocks() - 1);
        }
        return ret;
    }

    @Override
    public synchronized long getBlockSize() {
        long written = this.getVerifiedBlockSize();
        return written + this.partialBlocks.byteSize();
    }

    @Override
    public synchronized long getNumCorruptedBytes() {
        return this._corruptedBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BTDiskManagerMemento toMemento() {
        BTDiskManagerMementoImpl memento = new BTDiskManagerMementoImpl();
        VerifyingFolder verifyingFolder = this;
        synchronized (verifyingFolder) {
            HashMap<Integer, IntervalSet> partial = new HashMap<Integer, IntervalSet>(this.partialBlocks.size());
            for (Map.Entry entry : this.partialBlocks.entrySet()) {
                partial.put((Integer)entry.getKey(), ((IntervalSet)entry.getValue()).clone());
            }
            memento.setPartialBlocks(partial);
            memento.setVerifiedBlocks((BitSet)this.verifiedBlocks.clone());
            memento.setVerifying(this.isVerifying);
        }
        if (BittorrentSettings.TORRENT_FLUSH_VERIRY.getValue()) {
            try {
                this.diskController.flush();
            }
            catch (IOException iox) {
                this.storedException = iox;
            }
        }
        return memento;
    }

    @Override
    public synchronized int getAmountPending() {
        return (int)this.pendingRanges.byteSize();
    }

    @Override
    public synchronized int getNumMissing(BitField other) {
        if (this.isComplete()) {
            return this.verified.cardinality() - other.cardinality();
        }
        NotView theirMissing = new NotView(other);
        return new AndView(this.verified, theirMissing).cardinality();
    }

    @Override
    public synchronized boolean containsAnyWeMiss(BitField other) {
        if (this.isComplete()) {
            return false;
        }
        AndView interesting = new AndView(other, this.missing);
        return interesting.nextSetBit(0) > -1;
    }

    @Override
    public long getLastVerifiedOffset() {
        return this.lastVerifiedOffset;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BlockRangeMap
    extends HashMap<Integer, IntervalSet> {
        private static final long serialVersionUID = 4006274480019024111L;

        BlockRangeMap() {
        }

        private BlockRangeMap(int size) {
            super(size);
        }

        public void addInterval(BTInterval in) {
            IntervalSet s = (IntervalSet)this.get(in.getBlockId());
            if (s == null) {
                s = new IntervalSet();
                this.put(in.getBlockId(), s);
            }
            s.add(in);
        }

        public void removeInterval(BTInterval in) {
            IntervalSet s = (IntervalSet)this.get(in.getBlockId());
            if (s == null) {
                return;
            }
            s.delete(in);
            if (s.isEmpty()) {
                this.remove(in.getBlockId());
            }
        }

        public long byteSize() {
            long ret = 0L;
            for (IntervalSet set : this.values()) {
                ret += set.getSize();
            }
            return ret;
        }

        @Override
        public BlockRangeMap clone() {
            BlockRangeMap clone = new BlockRangeMap(this.size());
            for (Map.Entry e : this.entrySet()) {
                clone.put(e.getKey(), ((IntervalSet)e.getValue()).clone());
            }
            return clone;
        }
    }

    private class VerifyJob
    implements Runnable {
        private final int pieceNum;

        public VerifyJob(int pieceNum) {
            this.pieceNum = pieceNum;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (VerifyingFolder.this.storedException != null || !VerifyingFolder.this.isOpen() || VerifyingFolder.this.hasBlock(this.pieceNum)) {
                return;
            }
            try {
                if (VerifyingFolder.this.verify(this.pieceNum, true)) {
                    VerifyingFolder.this.markPieceCompleted(this.pieceNum);
                    VerifyingFolder.this.handleVerified(this.pieceNum);
                } else {
                    VerifyingFolder.this._corruptedBytes += VerifyingFolder.this.getPieceSize(this.pieceNum);
                }
            }
            catch (IOException bad) {
                VerifyingFolder.this.storedException = bad;
            }
            catch (InterruptedException iex) {
                VerifyingFolder.this.storedException = new InterruptedIOException();
            }
            finally {
                if (VerifyingFolder.this.storedException != null && VerifyingFolder.this.isOpen()) {
                    VerifyingFolder.this.notifyDiskProblem(VerifyingFolder.this.storedException);
                }
            }
        }
    }

    private class SendJob
    implements Runnable {
        private final BTInterval in;
        private final PieceReadListener listener;

        SendJob(BTInterval in, PieceReadListener listener) {
            this.in = in;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!VerifyingFolder.this.isOpen()) {
                return;
            }
            if (VerifyingFolder.this.storedException != null) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("reading piece " + this.in);
            }
            long length64 = this.in.getHigh() - this.in.getLow() + 1L;
            assert (length64 <= Integer.MAX_VALUE);
            int length = (int)length64;
            long position = (long)this.in.getId() * (long)VerifyingFolder.this.context.getMetaInfo().getPieceLength() + this.in.getLow();
            int offset = 0;
            byte[] buf = new byte[length];
            boolean success = false;
            try {
                while ((offset += VerifyingFolder.this.diskController.read(position + (long)offset, buf, offset, length - offset)) < length) {
                }
                success = true;
            }
            catch (IOException bad) {
                if (VerifyingFolder.this.isOpen()) {
                    VerifyingFolder.this.storedException = bad;
                    VerifyingFolder.this.notifyDiskProblem(new DiskException(bad));
                }
            }
            finally {
                if (success) {
                    this.listener.pieceRead(this.in, buf);
                } else {
                    this.listener.pieceReadFailed(this.in);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WriteJob
    implements Runnable {
        private final NECallable<BTPiece> factory;

        WriteJob(NECallable<BTPiece> factory) {
            this.factory = factory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (VerifyingFolder.this.storedException != null) {
                return;
            }
            BTPiece piece = this.factory.call();
            BTInterval in = piece.getInterval();
            if (in.getId() >= VerifyingFolder.this.verified.maxSize()) {
                return;
            }
            byte[] data = piece.getData();
            VerifyingFolder verifyingFolder = VerifyingFolder.this;
            synchronized (verifyingFolder) {
                if (VerifyingFolder.this.hasBlock(in.getId())) {
                    return;
                }
                VerifyingFolder.this.pendingRanges.addInterval(in);
                VerifyingFolder.this.requestedRanges.removeInterval(in);
            }
            try {
                VerifyingFolder.this.writeBlockImpl(in, data);
            }
            catch (IOException iox) {
                if (VerifyingFolder.this.isOpen()) {
                    VerifyingFolder.this.storedException = iox;
                    VerifyingFolder.this.notifyDiskProblem(iox);
                }
            }
            finally {
                VerifyingFolder verifyingFolder2 = VerifyingFolder.this;
                synchronized (verifyingFolder2) {
                    VerifyingFolder.this.pendingRanges.removeInterval(in);
                }
            }
        }
    }
}

