/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.gui;

import com.limegroup.bittorrent.BTMetaInfo;
import com.limegroup.bittorrent.gui.TorrentDownloadFactory;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.SaveLocationManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.CoreDownloader;
import com.limegroup.gnutella.downloader.DownloadStatusEvent;
import com.limegroup.gnutella.downloader.DownloaderType;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.download.DownloaderUtils;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HttpClientListener;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import javax.swing.SwingUtilities;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.limewire.io.IOUtils;
import org.limewire.listener.EventListener;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TorrentFileFetcher
implements HttpClientListener,
CoreDownloader {
    private static final int TIMEOUT = 5000;
    private final URI torrentURI;
    private volatile boolean stopped;
    private volatile boolean failed;
    private volatile URN urn;
    private volatile Shutdownable aborter;
    private volatile CoreDownloader delegate;

    public TorrentFileFetcher(URI torrentURI, SaveLocationManager saveLocationManager) {
        this.torrentURI = torrentURI;
    }

    public void fetch() {
        HttpGet get = new HttpGet(this.torrentURI);
        get.addHeader("User-Agent", LimeWireUtils.getHttpServer());
        get.addHeader(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(params, 5000);
        HttpConnectionParams.setSoTimeout(params, 5000);
        HttpClientParams.setRedirecting(params, true);
        this.aborter = GuiCoreMediator.getHttpExecutor().execute(get, params, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestComplete(HttpUriRequest method, HttpResponse response) {
        this.aborter = null;
        if (this.stopped) {
            return false;
        }
        BTMetaInfo m = null;
        byte[] body = null;
        try {
            if (response.getEntity() != null) {
                body = IOUtils.readFully(response.getEntity().getContent());
            }
            if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() >= 300) {
                throw new IOException("bad status code, downloading .torrent file " + response.getStatusLine().getStatusCode());
            }
            if (body == null || body.length == 0) {
                throw new IOException("invalid response");
            }
            m = GuiCoreMediator.getBTMetaInfoFactory().createBTMetaInfoFromBytes(body);
            TorrentFileFetcher torrentFileFetcher = this;
            synchronized (torrentFileFetcher) {
                this.urn = m.getURN();
            }
        }
        catch (SaveLocationException security) {
            GUIMediator.showWarning(I18n.tr("The selected .torrent file may contain a security hazard."));
        }
        catch (IOException iox) {
            GUIMediator.showWarning(I18n.tr("LimeWire could not download a .torrent file from the provided URL."));
        }
        finally {
            GuiCoreMediator.getHttpExecutor().releaseResources(response);
        }
        if (m == null) {
            this.removeDataLine();
            return false;
        }
        if (SharingSettings.SHARE_TORRENT_META_FILES.getValue()) {
            File tFile = GuiCoreMediator.getTorrentManager().getSharedTorrentMetaDataFile(m);
            GuiCoreMediator.getFileManager().stopSharingFile(tFile);
            File backup = null;
            if (tFile.exists()) {
                backup = new File(tFile.getParent(), tFile.getName().concat(".bak"));
                FileUtils.forceRename(tFile, backup);
            }
            BufferedOutputStream out = null;
            try {
                out = new BufferedOutputStream(new FileOutputStream(tFile));
                ((OutputStream)out).write(body);
                ((OutputStream)out).flush();
                if (backup != null) {
                    backup.delete();
                }
                IOUtils.close(out);
            }
            catch (IOException ioe) {
                if (backup != null && FileUtils.forceRename(backup, tFile)) {
                    GuiCoreMediator.getFileManager().addFileIfShared(tFile);
                }
            }
            finally {
                IOUtils.close(out);
            }
        }
        final BTMetaInfo toDownload = m;
        Runnable starter = new Runnable(){

            public void run() {
                TorrentDownloadFactory factory = new TorrentDownloadFactory(toDownload);
                CoreDownloader d = (CoreDownloader)DownloaderUtils.createDownloader(factory);
                if (d != null) {
                    TorrentFileFetcher.this.delegate = d;
                } else {
                    TorrentFileFetcher.this.stopped = true;
                    TorrentFileFetcher.this.removeDataLine();
                }
            }
        };
        SwingUtilities.invokeLater(starter);
        return false;
    }

    private synchronized void removeDataLine() {
        this.failed = true;
        this.urn = null;
        GuiCoreMediator.getActivityCallback().removeDownload(this);
    }

    @Override
    public boolean requestFailed(HttpUriRequest method, HttpResponse response, IOException exc) {
        assert (this.delegate == null);
        this.failed = true;
        return false;
    }

    @Override
    public void discardCorruptDownload(boolean delete) {
    }

    @Override
    public long getAmountLost() {
        return this.delegate == null ? 0L : this.delegate.getAmountLost();
    }

    @Override
    public int getAmountPending() {
        return this.delegate == null ? 0 : this.delegate.getAmountPending();
    }

    @Override
    public long getAmountRead() {
        return this.delegate == null ? 0L : this.delegate.getAmountRead();
    }

    @Override
    public long getAmountVerified() {
        return this.delegate == null ? 0L : this.delegate.getAmountVerified();
    }

    @Override
    public Object getAttribute(String key) {
        return this.delegate == null ? null : this.delegate.getAttribute(key);
    }

    @Override
    public RemoteFileDesc getBrowseEnabledHost() {
        return this.delegate == null ? null : this.delegate.getBrowseEnabledHost();
    }

    @Override
    public int getBusyHostCount() {
        return this.delegate == null ? 0 : this.delegate.getBusyHostCount();
    }

    @Override
    public Endpoint getChatEnabledHost() {
        return this.delegate == null ? null : this.delegate.getChatEnabledHost();
    }

    @Override
    public int getChunkSize() {
        return this.delegate == null ? 1 : this.delegate.getChunkSize();
    }

    @Override
    public long getContentLength() {
        return this.delegate == null ? 0L : this.delegate.getContentLength();
    }

    @Override
    public File getDownloadFragment() {
        return this.delegate == null ? null : this.delegate.getDownloadFragment();
    }

    @Override
    public File getFile() {
        return this.delegate == null ? null : this.delegate.getFile();
    }

    @Override
    public int getInactivePriority() {
        return this.delegate == null ? 0 : this.delegate.getInactivePriority();
    }

    @Override
    public int getNumHosts() {
        return this.delegate == null ? 0 : this.delegate.getNumHosts();
    }

    @Override
    public int getNumberOfAlternateLocations() {
        return this.delegate == null ? 0 : this.delegate.getNumberOfAlternateLocations();
    }

    @Override
    public int getNumberOfInvalidAlternateLocations() {
        return this.delegate == null ? 0 : this.delegate.getNumberOfInvalidAlternateLocations();
    }

    @Override
    public int getPossibleHostCount() {
        return this.delegate == null ? 0 : this.delegate.getPossibleHostCount();
    }

    @Override
    public int getQueuePosition() {
        return this.delegate == null ? 0 : this.delegate.getQueuePosition();
    }

    @Override
    public int getQueuedHostCount() {
        return this.delegate == null ? 0 : this.delegate.getQueuedHostCount();
    }

    @Override
    public int getRemainingStateTime() {
        return this.delegate == null ? 0 : this.delegate.getRemainingStateTime();
    }

    @Override
    public URN getSha1Urn() {
        return this.delegate == null ? null : this.delegate.getSha1Urn();
    }

    @Override
    public File getSaveFile() {
        int slash;
        if (this.delegate != null) {
            return this.delegate.getSaveFile();
        }
        String uri = this.torrentURI.toString();
        String name = null;
        if (uri.endsWith(".torrent") && (slash = uri.lastIndexOf("/")) != -1) {
            name = uri.substring(slash);
        }
        if (name == null) {
            name = uri;
        }
        return new File(uri);
    }

    @Override
    public Downloader.DownloadStatus getState() {
        if (this.stopped) {
            return Downloader.DownloadStatus.ABORTED;
        }
        if (this.failed) {
            return Downloader.DownloadStatus.GAVE_UP;
        }
        if (this.delegate == null) {
            return Downloader.DownloadStatus.FETCHING;
        }
        return this.delegate.getState();
    }

    @Override
    public String getVendor() {
        return this.delegate == null ? null : this.delegate.getVendor();
    }

    @Override
    public boolean hasBrowseEnabledHost() {
        return this.delegate == null ? false : this.delegate.hasBrowseEnabledHost();
    }

    @Override
    public boolean hasChatEnabledHost() {
        return this.delegate == null ? false : this.delegate.hasChatEnabledHost();
    }

    @Override
    public boolean isCompleted() {
        return this.delegate == null ? this.failed || this.stopped : this.delegate.isCompleted();
    }

    @Override
    public boolean isInactive() {
        return this.delegate == null ? false : this.delegate.isInactive();
    }

    @Override
    public boolean isLaunchable() {
        return this.delegate == null ? false : this.delegate.isLaunchable();
    }

    @Override
    public boolean isPausable() {
        return this.delegate == null ? false : this.delegate.isPausable();
    }

    @Override
    public boolean isPaused() {
        return this.delegate == null ? false : this.delegate.isPaused();
    }

    @Override
    public boolean isRelocatable() {
        return this.delegate == null ? false : this.delegate.isRelocatable();
    }

    @Override
    public boolean isResumable() {
        return this.delegate == null ? false : this.delegate.isResumable();
    }

    @Override
    public void pause() {
        if (this.delegate != null) {
            this.delegate.pause();
        }
    }

    @Override
    public Object removeAttribute(String key) {
        return this.delegate == null ? null : this.delegate.removeAttribute(key);
    }

    @Override
    public boolean resume() {
        return this.delegate == null ? false : this.delegate.resume();
    }

    @Override
    public Object setAttribute(String key, Object value, boolean serialize) {
        return this.delegate == null ? null : this.delegate.setAttribute(key, value, serialize);
    }

    @Override
    public void setSaveFile(File saveDirectory, String fileName, boolean overwrite) throws SaveLocationException {
        if (this.delegate != null) {
            this.delegate.setSaveFile(saveDirectory, fileName, overwrite);
        }
    }

    @Override
    public void stop() {
        if (this.delegate != null) {
            this.delegate.stop();
        } else {
            this.stopped = true;
            if (this.aborter != null) {
                this.aborter.shutdown();
                this.aborter = null;
            }
        }
    }

    @Override
    public float getAverageBandwidth() {
        return this.delegate == null ? 0.0f : this.delegate.getAverageBandwidth();
    }

    @Override
    public float getMeasuredBandwidth() throws InsufficientDataException {
        return this.delegate == null ? 0.0f : this.delegate.getMeasuredBandwidth();
    }

    @Override
    public void measureBandwidth() {
        if (this.delegate != null) {
            this.delegate.measureBandwidth();
        }
    }

    public synchronized boolean equals(Object o) {
        if (this.urn == null) {
            return super.equals(o);
        }
        if (!(o instanceof Downloader)) {
            return false;
        }
        Downloader d = (Downloader)o;
        return this.urn.equals(d.getSha1Urn());
    }

    @Override
    public int getTriedHostCount() {
        return -1;
    }

    @Override
    public String getCustomIconDescriptor() {
        return this.delegate == null ? null : this.delegate.getCustomIconDescriptor();
    }

    @Override
    public boolean conflicts(URN urn, long fileSize, File ... files) {
        return this.delegate.conflicts(urn, fileSize, files);
    }

    @Override
    public boolean conflictsSaveFile(File saveFile) {
        return this.delegate.conflictsSaveFile(saveFile);
    }

    @Override
    public boolean conflictsWithIncompleteFile(File incomplete) {
        return this.delegate.conflictsWithIncompleteFile(incomplete);
    }

    @Override
    public void finish() {
        this.delegate.finish();
    }

    @Override
    public GUID getQueryGUID() {
        return this.delegate.getQueryGUID();
    }

    @Override
    public void handleInactivity() {
        this.delegate.handleInactivity();
    }

    @Override
    public void initialize() {
        this.delegate.initialize();
    }

    @Override
    public boolean isAlive() {
        return this.delegate.isAlive();
    }

    @Override
    public boolean isQueuable() {
        return this.delegate.isQueuable();
    }

    @Override
    public void setInactivePriority(int priority) {
        this.delegate.setInactivePriority(priority);
    }

    @Override
    public boolean shouldBeRemoved() {
        return this.delegate.shouldBeRemoved();
    }

    @Override
    public boolean shouldBeRestarted() {
        return this.delegate.shouldBeRestarted();
    }

    @Override
    public void startDownload() {
        this.delegate.startDownload();
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public DownloaderType getDownloadType() {
        return DownloaderType.TORRENTFETCHER;
    }

    @Override
    public DownloadMemento toMemento() {
        throw new IllegalStateException("should not be serializing!");
    }

    @Override
    public void initFromMemento(DownloadMemento memento) {
        throw new IllegalStateException("should not be deserialized!");
    }

    @Override
    public void addListener(EventListener<DownloadStatusEvent> listener) {
    }

    @Override
    public boolean removeListener(EventListener<DownloadStatusEvent> listener) {
        return false;
    }

    @Override
    public boolean allowRequest(HttpUriRequest request) {
        return true;
    }
}

