/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.messages;

import com.limegroup.bittorrent.BTInterval;
import com.limegroup.bittorrent.messages.BTMessage;
import com.limegroup.bittorrent.messages.BadBTMessageException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BTCancel
extends BTMessage {
    private ByteBuffer _payload = null;
    private BTInterval in;

    public BTCancel(BTInterval in) {
        super((byte)8);
        this.in = in;
    }

    public static BTCancel readMessage(ByteBuffer payload) throws BadBTMessageException {
        if (payload.remaining() != 12) {
            throw new BadBTMessageException("unexpected payload in cancel message: " + new String(payload.array()));
        }
        payload.order(ByteOrder.BIG_ENDIAN);
        int pieceNum = payload.getInt();
        if (pieceNum < 0) {
            throw new BadBTMessageException("invalid piece number in cancel message: " + pieceNum);
        }
        long offset = payload.getInt();
        long length = payload.getInt();
        if (length == 0L) {
            throw new BadBTMessageException("0 length in cancel message " + pieceNum);
        }
        return new BTCancel(new BTInterval(offset, offset + length + -1L, pieceNum));
    }

    public BTInterval getInterval() {
        return this.in;
    }

    public ByteBuffer getPayload() {
        if (this._payload == null) {
            this._payload = ByteBuffer.allocate(12);
            this._payload.order(ByteOrder.BIG_ENDIAN);
            this._payload.putInt(this.in.getId());
            this._payload.putInt(this.in.get32BitLow());
            this._payload.putInt(this.in.get32BitLength());
            this._payload = this._payload.asReadOnlyBuffer();
        }
        this._payload.clear();
        return this._payload;
    }

    public String toString() {
        return "BTCancel (" + this.in + ")";
    }
}

