/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.messages;

import com.limegroup.bittorrent.BTInterval;
import com.limegroup.bittorrent.BTPiece;
import com.limegroup.bittorrent.messages.BTMessage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BTPieceMessage
extends BTMessage
implements BTPiece {
    private BTInterval in;
    private final byte[] _data;

    public BTPieceMessage(BTInterval in, byte[] data) {
        super((byte)7);
        this.in = in;
        this._data = data;
    }

    public BTInterval getInterval() {
        return this.in;
    }

    public byte[] getData() {
        return this._data;
    }

    public ByteBuffer getPayload() {
        ByteBuffer payload = ByteBuffer.allocate(this._data.length + 8);
        payload.order(ByteOrder.BIG_ENDIAN);
        payload.putInt(this.in.getId());
        payload.putInt(this.in.get32BitLow());
        payload.put(this._data);
        payload.clear();
        return payload;
    }

    public boolean isUrgent() {
        return true;
    }

    public String toString() {
        return "BTPiece (" + this.in.getId() + ";" + this.in.getLow() + ";" + this._data.length + ")";
    }
}

