/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.reader;

import com.limegroup.bittorrent.messages.BTBitField;
import com.limegroup.bittorrent.messages.BadBTMessageException;
import com.limegroup.bittorrent.reader.BTDataSource;
import com.limegroup.bittorrent.reader.BTReadMessageState;
import com.limegroup.bittorrent.reader.ReaderData;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.ByteBufferOutputStream;
import org.limewire.service.ErrorService;

class BitFieldState
extends BTReadMessageState {
    private static final Log LOG = LogFactory.getLog(BitFieldState.class);
    private ByteBufferOutputStream bbaos;
    private WritableByteChannel bbaosChan;
    private final int length;

    BitFieldState(ReaderData readerState) {
        super(readerState);
        this.length = readerState.getLength();
    }

    public BTReadMessageState addData() throws BadBTMessageException {
        BTDataSource buf = this.readerState.getDataSource();
        if (this.bbaos == null) {
            this.bbaos = new ByteBufferOutputStream();
            this.bbaosChan = Channels.newChannel(this.bbaos);
        }
        int toWrite = this.length - this.bbaos.size();
        try {
            buf.write(this.bbaosChan, toWrite);
        }
        catch (IOException impossible) {
            ErrorService.error(impossible);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this + " parsing bitfield incrementally, so far " + this.bbaos.size());
        }
        if (this.bbaos.size() == this.length) {
            this.countAndProcess(ByteBuffer.wrap(this.bbaos.toByteArray()));
            return this.readerState.getEntryState();
        }
        return null;
    }

    private void countAndProcess(ByteBuffer b) {
        BTBitField field = new BTBitField(b);
        this.readerState.getHandler().processMessage(field);
    }

    public String toString() {
        return "BitFieldReader for " + this.readerState;
    }
}

