/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.reader;

import com.limegroup.bittorrent.messages.BadBTMessageException;
import com.limegroup.bittorrent.reader.BTDataSource;
import com.limegroup.bittorrent.reader.BTReadMessageState;
import com.limegroup.bittorrent.reader.BitFieldState;
import com.limegroup.bittorrent.reader.MessageState;
import com.limegroup.bittorrent.reader.PieceState;
import com.limegroup.bittorrent.reader.ReaderData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TypeState
extends BTReadMessageState {
    private static final Log LOG = LogFactory.getLog(TypeState.class);
    private byte type = (byte)-1;

    TypeState(ReaderData readerState) {
        super(readerState);
    }

    public BTReadMessageState addData() throws BadBTMessageException {
        BTDataSource buf = this.readerState.getDataSource();
        if (buf.size() < 1) {
            return null;
        }
        this.type = buf.get();
        if (LOG.isDebugEnabled()) {
            LOG.debug(this + " parsed type " + this.type);
        }
        boolean wasFirst = !this.readerState.anyDataRead();
        this.readerState.dataRead();
        if (this.type == 5) {
            if (!wasFirst) {
                throw new BadBTMessageException("Bitfield can be only first message");
            }
            return new BitFieldState(this.readerState);
        }
        if (this.type == 7) {
            return new PieceState(this.readerState);
        }
        return new MessageState(this.readerState, this.type);
    }

    public String toString() {
        return "type state of " + this.readerState;
    }
}

