/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.tracking;

import com.google.inject.Provider;
import com.limegroup.bittorrent.ManagedTorrent;
import com.limegroup.bittorrent.TorrentContext;
import com.limegroup.bittorrent.tracking.Tracker;
import com.limegroup.bittorrent.tracking.TrackerResponse;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.NetworkManager;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.http.httpclient.LimeHttpClient;
import org.limewire.io.NetworkUtils;
import org.limewire.service.ErrorService;
import org.limewire.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackerImpl
implements Tracker {
    private static final Log LOG = LogFactory.getLog(Tracker.class);
    private static final int HTTP_TRACKER_TIMEOUT = 25000;
    static final String QUESTION_MARK = "?";
    static final String EQUALS = "=";
    static final String AND = "&";
    private final URI uri;
    private final TorrentContext context;
    private final ManagedTorrent torrent;
    private final Provider<LimeHttpClient> clientProvider;
    private int failures;
    private final String key;
    private final NetworkManager networkManager;
    private final ApplicationServices applicationServices;

    TrackerImpl(URI uri, TorrentContext context, ManagedTorrent torrent, NetworkManager networkManager, ApplicationServices applicationServices, Provider<LimeHttpClient> clientProvider) {
        this.networkManager = networkManager;
        this.applicationServices = applicationServices;
        this.uri = uri;
        this.context = context;
        this.torrent = torrent;
        this.clientProvider = clientProvider;
        String k = Integer.toHexString((int)(Math.random() * 2.147483647E9));
        while (k.length() < 8) {
            k = k + "0";
        }
        this.key = k;
    }

    @Override
    public void recordFailure() {
        ++this.failures;
    }

    @Override
    public void recordSuccess() {
        this.failures = 0;
    }

    @Override
    public int getFailures() {
        return this.failures;
    }

    @Override
    public TrackerResponse request(Tracker.Event event) {
        String queryStr = this.createQueryString(event);
        return this.connectHTTP(this.uri, queryStr);
    }

    private String createQueryString(Tracker.Event event) {
        StringBuilder buf = new StringBuilder();
        try {
            String infoHash = URLEncoder.encode(StringUtils.getASCIIString(this.context.getMetaInfo().getInfoHash()), "ISO-8859-1");
            TrackerImpl.addGetField(buf, "info_hash", infoHash);
            String peerId = URLEncoder.encode(StringUtils.getASCIIString(this.applicationServices.getMyBTGUID()), "ISO-8859-1");
            TrackerImpl.addGetField(buf, "peer_id", peerId);
            TrackerImpl.addGetField(buf, "key", this.key);
        }
        catch (UnsupportedEncodingException uee) {
            ErrorService.error(uee);
        }
        TrackerImpl.addGetField(buf, "ip", NetworkUtils.ip2string(this.networkManager.getAddress()));
        TrackerImpl.addGetField(buf, "port", String.valueOf(this.networkManager.getPort()));
        TrackerImpl.addGetField(buf, "downloaded", String.valueOf(this.torrent.getTotalDownloaded()));
        TrackerImpl.addGetField(buf, "uploaded", String.valueOf(this.torrent.getTotalUploaded()));
        TrackerImpl.addGetField(buf, "left", String.valueOf(this.context.getFileSystem().getTotalSize() - this.context.getDiskManager().getBlockSize()));
        TrackerImpl.addGetField(buf, "compact", "1");
        this.addEventFields(event, buf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("tracker query " + buf.toString());
        }
        return buf.toString();
    }

    /*
     * Exception decompiling
     */
    private TrackerResponse connectHTTP(URI uri, String query) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String toString() {
        return "Tracker " + this.uri + " failures " + this.failures;
    }

    private static StringBuilder addGetField(StringBuilder buf, String key, String value) {
        if (buf.length() == 0) {
            buf.append(QUESTION_MARK);
        } else {
            buf.append(AND);
        }
        buf.append(key);
        buf.append(EQUALS);
        buf.append(value);
        return buf;
    }

    private void addEventFields(Tracker.Event event, StringBuilder buf) {
        if (event.getDescription() != null) {
            TrackerImpl.addGetField(buf, "event", event.getDescription());
        }
        if (event.getNumWant() != null) {
            TrackerImpl.addGetField(buf, "numwant", event.getNumWant());
        }
    }
}

