/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.tracking;

import com.limegroup.bittorrent.ManagedTorrent;
import com.limegroup.bittorrent.TorrentContext;
import com.limegroup.bittorrent.TorrentLocation;
import com.limegroup.bittorrent.settings.BittorrentSettings;
import com.limegroup.bittorrent.tracking.Tracker;
import com.limegroup.bittorrent.tracking.TrackerFactory;
import com.limegroup.bittorrent.tracking.TrackerResponse;
import java.net.URI;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ExecutorsHelper;

public class TrackerManager {
    private static final Log LOG = LogFactory.getLog(TrackerManager.class);
    private static final int MAX_TRACKER_FAILURES = 5;
    private final Collection<Tracker> trackers = new CopyOnWriteArrayList<Tracker>();
    private final ExecutorService requestQueue = ExecutorsHelper.newProcessingQueue("tracker requester");
    private volatile long _nextTrackerRequestTime;
    private final ManagedTorrent torrent;
    private volatile ScheduledFuture<?> scheduledAnnounce;
    private volatile String lastFailureReason;
    private final ScheduledExecutorService backgroundExecutor;

    TrackerManager(ManagedTorrent torrent, TrackerFactory trackerFactory, ScheduledExecutorService backgroundExecutor) {
        this.torrent = torrent;
        this.backgroundExecutor = backgroundExecutor;
        TorrentContext context = torrent.getContext();
        for (URI uri : context.getMetaInfo().getTrackers()) {
            this.trackers.add(trackerFactory.create(uri, context, torrent));
        }
    }

    public void add(Tracker t) {
        this.trackers.add(t);
    }

    private void announceBlocking(Tracker t, Tracker.Event event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("connecting to tracker " + ((Object)t).toString() + " for event " + (Object)((Object)event));
        }
        TrackerResponse response = t.request(event);
        this.handleTrackerResponse(response, t);
    }

    private void announceToAll(final Tracker.Event event) {
        for (final Tracker t : this.trackers) {
            Runnable announcer = new Runnable(){

                public void run() {
                    TrackerManager.this.announceBlocking(t, event);
                }
            };
            this.requestQueue.execute(announcer);
        }
    }

    public void announceStart() {
        this._nextTrackerRequestTime = 0L;
        this.announceToAll(Tracker.Event.START);
    }

    public void announceStop() {
        ScheduledFuture<?> t = this.scheduledAnnounce;
        if (t != null) {
            t.cancel(true);
        }
        this.announceToAll(Tracker.Event.STOP);
    }

    public void announceComplete() {
        this.announceToAll(Tracker.Event.COMPLETE);
    }

    private void announce(Tracker t) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("announce thread for " + ((Object)t).toString());
        }
        this.torrent.setScraping();
        this.announceBlocking(t, Tracker.Event.NONE);
    }

    private boolean isHopeless() {
        if (this.trackers.isEmpty()) {
            return true;
        }
        int least = Integer.MAX_VALUE;
        for (Tracker t : this.trackers) {
            if (t.getFailures() == 0) {
                return false;
            }
            if (t.getFailures() >= least) continue;
            least = t.getFailures();
        }
        return least >= 5;
    }

    private void scheduleTrackerRequest(long minDelay, final Tracker t) {
        final Runnable announcer = new Runnable(){

            public void run() {
                if (!TrackerManager.this.torrent.isActive()) {
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("announcing to " + ((Object)t).toString());
                }
                TrackerManager.this.announce(t);
            }
        };
        Runnable scheduled = new Runnable(){

            public void run() {
                TrackerManager.this.requestQueue.execute(announcer);
            }
        };
        LOG.debug("scheduling new tracker request");
        if (this.scheduledAnnounce != null) {
            this.scheduledAnnounce.cancel(true);
        }
        this.scheduledAnnounce = this.backgroundExecutor.schedule(scheduled, minDelay, TimeUnit.MILLISECONDS);
        this._nextTrackerRequestTime = System.currentTimeMillis() + minDelay;
    }

    public long getNextTrackerRequestTime() {
        return this._nextTrackerRequestTime;
    }

    public String getLastFailureReason() {
        return this.lastFailureReason;
    }

    private void handleTrackerResponse(TrackerResponse response, Tracker t) {
        LOG.debug("handling tracker response " + response + " from " + t);
        long minWaitTime = BittorrentSettings.TRACKER_MIN_REASK_INTERVAL.getValue() * 1000;
        if (response != null) {
            for (TorrentLocation next : response.PEERS) {
                this.torrent.addEndpoint(next);
            }
            minWaitTime = response.INTERVAL * 1000;
            if (response.FAILURE_REASON != null) {
                t.recordFailure();
                this.lastFailureReason = response.FAILURE_REASON;
                this.torrent.trackerRequestFailed();
            } else {
                t.recordSuccess();
            }
        } else {
            t.recordFailure();
            this.torrent.trackerRequestFailed();
        }
        if (this.torrent.isActive()) {
            if (this.isHopeless() && this.torrent.shouldStop()) {
                this.torrent.stopVoluntarily();
            } else {
                this.scheduleTrackerRequest(minWaitTime, t);
            }
        }
    }
}

