/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.uploader.HTTPHeaderUtils;
import java.util.Arrays;
import java.util.Set;
import org.limewire.collection.BitNumbers;
import org.limewire.io.Connectable;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkUtils;
import org.limewire.util.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPushEndpoint
implements PushEndpoint {
    @Override
    public byte[] toBytes(boolean includeTLS) {
        Set<? extends IpPort> proxies = this.getProxies();
        int payloadSize = AbstractPushEndpoint.getSizeBytes(proxies, includeTLS);
        IpPort addr = this.getValidExternalAddress();
        int FWTVersion = this.getFWTVersion();
        if (addr != null && FWTVersion > 0) {
            payloadSize += 6;
        }
        byte[] ret = new byte[payloadSize];
        this.toBytes(ret, 0, proxies, addr, FWTVersion, includeTLS);
        return ret;
    }

    @Override
    public void toBytes(byte[] where, int offset, boolean includeTLS) {
        this.toBytes(where, offset, this.getProxies(), this.getValidExternalAddress(), this.getFWTVersion(), includeTLS);
    }

    protected void toBytes(byte[] where, int offset, Set<? extends IpPort> proxies, IpPort address, int FWTVersion, boolean includeTLS) {
        BitNumbers bn;
        int neededSpace = AbstractPushEndpoint.getSizeBytes(proxies, includeTLS);
        if (address != null) {
            if (FWTVersion > 0) {
                neededSpace += 6;
            }
        } else {
            FWTVersion = 0;
        }
        if (where.length - offset < neededSpace) {
            throw new IllegalArgumentException("target array too small");
        }
        int featureIdx = offset;
        where[offset] = (byte)(Math.min(4, proxies.size()) | this.getFeatures() | FWTVersion << 3);
        System.arraycopy(this.getClientGUID(), 0, where, ++offset, 16);
        offset += 16;
        if (address != null && FWTVersion > 0) {
            byte[] addr = address.getInetAddress().getAddress();
            int port = address.getPort();
            System.arraycopy(addr, 0, where, offset, 4);
            ByteUtils.short2leb((short)port, where, offset += 4);
            offset += 2;
        }
        int pptlsIdx = offset;
        int i = 0;
        if (includeTLS) {
            for (IpPort ipPort : proxies) {
                if (i >= 4) break;
                if (ipPort instanceof Connectable && ((Connectable)ipPort).isTLSCapable()) {
                    ++offset;
                    break;
                }
                ++i;
            }
        }
        i = 0;
        for (IpPort ipPort : proxies) {
            if (i >= 4) break;
            byte[] addr = ipPort.getInetAddress().getAddress();
            short port = (short)ipPort.getPort();
            System.arraycopy(addr, 0, where, offset, 4);
            ByteUtils.short2leb(port, where, offset += 4);
            offset += 2;
            ++i;
        }
        BitNumbers bitNumbers = bn = includeTLS ? HTTPHeaderUtils.getTLSIndices(proxies, Math.min(proxies.size(), 4)) : BitNumbers.EMPTY_BN;
        if (!bn.isEmpty()) {
            byte[] byArray = bn.toByteArray();
            assert (byArray.length == 1);
            where[pptlsIdx] = byArray[0];
            int n = featureIdx;
            where[n] = (byte)(where[n] | 0xFFFFFF80);
        } else {
            int n = featureIdx;
            where[n] = (byte)(where[n] & 0x7F);
        }
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj instanceof PushEndpoint) {
            return Arrays.equals(this.getClientGUID(), ((PushEndpoint)obj).getClientGUID());
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return new GUID(this.getClientGUID()).hashCode();
    }

    @Override
    public String httpStringValue() {
        Set<? extends IpPort> proxies;
        GUID guid = new GUID(this.getClientGUID());
        StringBuilder httpString = new StringBuilder(guid.toHexString()).append(";");
        int fwtVersion = this.getFWTVersion();
        if (fwtVersion != 0) {
            httpString.append("fwt").append("/").append(fwtVersion).append(";");
            IpPort address = this.getValidExternalAddress();
            if (address != null) {
                String addr = address.getAddress();
                int port = address.getPort();
                if (!addr.equals("1.1.1.1") && NetworkUtils.isValidPort(port)) {
                    httpString.append(port).append(":").append(addr).append(";");
                }
            }
        }
        if (!(proxies = this.getProxies()).isEmpty()) {
            httpString.append(HTTPHeaderUtils.encodePushProxies(proxies, ";", 4));
        } else {
            httpString.deleteCharAt(httpString.length() - 1);
        }
        return httpString.toString();
    }

    public String toString() {
        String ret = "PE [FEATURES:" + this.getFeatures() + ",\nFWT Version:" + this.getFWTVersion() + ",\nGUID:" + new GUID(this.getClientGUID()) + ", address: " + this.getAddress() + ":" + this.getPort() + ",\nproxies:{ ";
        for (IpPort ipPort : this.getProxies()) {
            ret = ret + ipPort.getInetAddress() + ":" + ipPort.getPort() + "\n";
        }
        ret = ret + "}]";
        return ret;
    }

    public static int getSizeBytes(Set<? extends IpPort> proxies, boolean includeTLS) {
        boolean hasTLS = false;
        if (includeTLS) {
            int i = 0;
            for (IpPort ipPort : proxies) {
                if (i >= 4) break;
                if (ipPort instanceof ConnectableImpl && ((Connectable)ipPort).isTLSCapable()) {
                    hasTLS = true;
                    break;
                }
                ++i;
            }
        }
        return 17 + (hasTLS ? 1 : 0) + Math.min(proxies.size(), 4) * 6;
    }
}

