/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.browser.ExternalControl;
import com.limegroup.gnutella.settings.NetworkSettings;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.limewire.io.ByteReader;
import org.limewire.io.IOUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;

public class ActiveLimeWireCheck {
    private final String arg;
    private final boolean allowMultiple;

    public ActiveLimeWireCheck(String[] args, boolean allowMultiple) {
        this.allowMultiple = allowMultiple;
        this.arg = args == null || args.length == 0 ? null : ExternalControl.preprocessArgs(args);
    }

    public boolean checkForActiveLimeWire() {
        if (this.arg == null) {
            return !this.allowMultiple && this.testForLimeWire(null);
        }
        return (OSUtils.isWindows() || OSUtils.isLinux()) && this.testForLimeWire(this.arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testForLimeWire(String arg) {
        String type;
        Socket socket = null;
        int port = NetworkSettings.PORT.getValue();
        String string = type = ExternalControl.isTorrentRequest(arg) ? "TORRENT" : "MAGNET";
        if (!NetworkUtils.isValidPort(port)) {
            NetworkSettings.PORT.revertToDefault();
            port = NetworkSettings.PORT.getValue();
        }
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress("127.0.0.1", port), 1000);
            InputStream istream = socket.getInputStream();
            socket.setSoTimeout(1000);
            ByteReader byteReader = new ByteReader(istream);
            OutputStream os = socket.getOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter(os);
            BufferedWriter out = new BufferedWriter(osw);
            out.write(type + " " + arg + " ");
            out.write("\r\n");
            out.flush();
            String str = byteReader.readLine();
            boolean bl = str != null && str.startsWith(CommonUtils.getUserName());
            return bl;
        }
        catch (IOException ignored) {
        }
        finally {
            IOUtils.close(socket);
        }
        return false;
    }
}

