/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.BandwidthManager;
import com.limegroup.gnutella.UploadServices;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import java.net.Socket;
import org.limewire.nio.NBThrottle;
import org.limewire.nio.Throttle;
import org.limewire.rudp.RUDPSocket;

@Singleton
public class BandwidthManagerImpl
implements BandwidthManager {
    private final Throttle UP_TCP;
    private final Throttle DOWN_TCP;
    private final Throttle UP_UDP;
    private final UploadServices uploadServices;

    @Inject
    public BandwidthManagerImpl(UploadServices uploadServices) {
        this.uploadServices = uploadServices;
        this.UP_TCP = new NBThrottle(true, 0.0f);
        this.DOWN_TCP = new NBThrottle(false, 0.0f);
        this.UP_UDP = new NBThrottle(true, 0.0f);
    }

    public void applyRate() {
        this.applyDownloadRate();
        this.applyUploadRate();
    }

    private void applyDownloadRate() {
        float downloadRate = Float.MAX_VALUE;
        int downloadThrottle = DownloadSettings.DOWNLOAD_SPEED.getValue();
        if (downloadThrottle < 100) {
            downloadRate = (float)downloadThrottle / 100.0f * ((float)ConnectionSettings.CONNECTION_SPEED.getValue() / 8.0f) * 1024.0f;
        }
        this.DOWN_TCP.setRate(downloadRate);
    }

    public void applyUploadRate() {
        this.UP_TCP.setRate(this.uploadServices.getRequestedUploadSpeed());
        this.UP_UDP.setRate(this.uploadServices.getRequestedUploadSpeed());
    }

    public Throttle getReadThrottle() {
        this.applyDownloadRate();
        return this.DOWN_TCP;
    }

    public Throttle getWriteThrottle() {
        this.applyUploadRate();
        return this.UP_TCP;
    }

    public Throttle getWriteThrottle(Socket socket) {
        this.applyUploadRate();
        return socket instanceof RUDPSocket ? this.UP_UDP : this.UP_TCP;
    }
}

