/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.BrowseHostHandlerManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.downloader.PushDownloadManager;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.MessageFactory;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.params.HttpProtocolParams;
import org.limewire.http.httpclient.SocketWrappingHttpClient;
import org.limewire.io.Connectable;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.IOUtils;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.net.SocketsManager;
import org.limewire.service.ErrorService;
import org.limewire.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowseHostHandler {
    private static final Log LOG = LogFactory.getLog(BrowseHostHandler.class);
    private static final int NOT_STARTED = -1;
    private static final int STARTED = 0;
    private static final int DIRECTLY_CONNECTING = 1;
    private static final int PUSHING = 2;
    private static final int EXCHANGING = 3;
    private static final int FINISHED = 4;
    static final int DIRECT_CONNECT_TIME = 10000;
    private static final long EXPIRE_TIME = 15000L;
    private static final int SPECIAL_INDEX = 0;
    private GUID _guid = null;
    private GUID _serventID = null;
    private volatile long _replyLength = 0L;
    private volatile long _currentLength = 0L;
    private volatile int _state = -1;
    private volatile long _stateStarted = 0L;
    private final BrowseHostHandlerManager.BrowseHostCallback browseHostCallback;
    private final ActivityCallback activityCallback;
    private final SocketsManager socketsManager;
    private final Provider<PushDownloadManager> pushDownloadManager;
    private final Provider<ReplyHandler> forMeReplyHandler;
    private final MessageFactory messageFactory;
    private final RemoteFileDescFactory remoteFileDescFactory;
    private final Provider<SocketWrappingHttpClient> clientProvider;
    private final NetworkInstanceUtils networkInstanceUtils;

    BrowseHostHandler(GUID guid, GUID serventID, BrowseHostHandlerManager.BrowseHostCallback browseHostCallback, ActivityCallback activityCallback, SocketsManager socketsManager, Provider<PushDownloadManager> pushDownloadManager, @Named(value="forMeReplyHandler") Provider<ReplyHandler> forMeReplyHandler, MessageFactory messageFactory, RemoteFileDescFactory remoteFileDescFactory, Provider<SocketWrappingHttpClient> clientProvider, NetworkInstanceUtils networkInstanceUtils) {
        this._guid = guid;
        this._serventID = serventID;
        this.browseHostCallback = browseHostCallback;
        this.activityCallback = activityCallback;
        this.socketsManager = socketsManager;
        this.pushDownloadManager = pushDownloadManager;
        this.forMeReplyHandler = forMeReplyHandler;
        this.messageFactory = messageFactory;
        this.remoteFileDescFactory = remoteFileDescFactory;
        this.clientProvider = clientProvider;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    public void browseHost(Connectable host, Set<? extends IpPort> proxies, boolean canDoFWTransfer) {
        if (host == null) {
            assert (!canDoFWTransfer) : "Can't do fwts without host";
            try {
                this.setState(0);
                this.browseFirewalledHost(BrowseHostHandler.createInvalidHost(), proxies, canDoFWTransfer);
            }
            catch (UnknownHostException e) {
                this.failed();
                ErrorService.error(e, "Can't resolve host, should not happen");
            }
            return;
        }
        if (host.getInetSocketAddress().isUnresolved()) {
            try {
                host = new ConnectableImpl(host.getAddress(), host.getPort(), host.isTLSCapable());
            }
            catch (UnknownHostException uhe) {
                this.failed();
                return;
            }
        }
        if (!NetworkUtils.isValidIpPort(host)) {
            this.failed();
            return;
        }
        LOG.trace("Starting browse protocol");
        this.setState(0);
        if (this.canConnectDirectly(host) || this.isLocalBrowse(host)) {
            try {
                SocketsManager.ConnectType type;
                this.setState(1);
                SocketsManager.ConnectType connectType = type = host.isTLSCapable() ? SocketsManager.ConnectType.TLS : SocketsManager.ConnectType.PLAIN;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Attempting direct connection with type: " + (Object)((Object)type));
                }
                Socket socket = this.socketsManager.connect(new InetSocketAddress(host.getAddress(), host.getPort()), 10000, type);
                LOG.trace("Direct connect successful");
                this.browseHost(socket);
                return;
            }
            catch (IOException e) {
                LOG.debug("Error during direct transfer", e);
            }
            catch (HttpException e) {
                LOG.debug("Error during direct transfer", e);
            }
            catch (URISyntaxException e) {
                LOG.debug("Error during direct transfer", e);
            }
            catch (InterruptedException e) {
                LOG.debug("Error during direct transfer", e);
            }
        }
        this.browseFirewalledHost(host, proxies, canDoFWTransfer);
    }

    private void browseFirewalledHost(Connectable host, Set<? extends IpPort> proxies, boolean canDoFWTransfer) {
        LOG.debug("Attempting push connection");
        if (this._serventID == null) {
            LOG.debug("No serventID, failing");
            this.failed();
        } else {
            RemoteFileDesc fakeRFD = this.remoteFileDescFactory.createRemoteFileDesc(host.getAddress(), host.getPort(), 0L, "fake", 0L, this._serventID.bytes(), 0, false, 0, false, null, null, false, true, "", proxies, -1L, canDoFWTransfer ? 1 : 0, host.isTLSCapable());
            this.browseHostCallback.putInfo(this._serventID, new PushRequestDetails(this));
            LOG.trace("Sending push request");
            this.setState(2);
            this.pushDownloadManager.get().sendPush(fakeRFD);
        }
    }

    static Connectable createInvalidHost() throws UnknownHostException {
        return new ConnectableImpl("0.0.0.0", 1, false);
    }

    public double getPercentComplete(long currentTime) {
        switch (this._state) {
            case -1: {
                return 0.0;
            }
            case 0: {
                return 0.0;
            }
            case 1: {
                long elapsed = currentTime - this._stateStarted;
                return (double)elapsed / 10000.0;
            }
            case 2: {
                long elapsed = currentTime - this._stateStarted;
                return (double)elapsed / 15000.0;
            }
            case 3: {
                if (this._replyLength > 0L) {
                    return (double)this._currentLength / (double)this._replyLength;
                }
                return 0.5;
            }
            case 4: {
                return 1.0;
            }
        }
        throw new IllegalStateException("invalid state");
    }

    private void setState(int state) {
        this._state = state;
        this._stateStarted = System.currentTimeMillis();
    }

    void failed() {
        this.setState(4);
        this.activityCallback.browseHostFailed(this._guid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void browseHost(Socket socket) throws IOException, URISyntaxException, HttpException, InterruptedException {
        try {
            this.setState(3);
            HttpResponse response = this.makeHTTPRequest(socket);
            this.validateResponse(response);
            this.readQueryRepliesFromStream(response);
        }
        finally {
            IOUtils.close(socket);
            this.setState(4);
        }
    }

    private HttpResponse makeHTTPRequest(Socket socket) throws IOException, URISyntaxException, HttpException, InterruptedException {
        SocketWrappingHttpClient client = this.clientProvider.get();
        client.setSocket(socket);
        HttpGet get = new HttpGet("http://" + NetworkUtils.ip2string(socket.getInetAddress().getAddress()) + ":" + socket.getPort() + "/");
        HttpProtocolParams.setVersion(client.getParams(), HttpVersion.HTTP_1_1);
        get.addHeader("Host", NetworkUtils.ip2string(socket.getInetAddress().getAddress()) + ":" + socket.getPort());
        get.addHeader("User-Agent", LimeWireUtils.getVendor());
        get.addHeader("Accept", "application/x-gnutella-packets");
        get.addHeader("Connection", "close");
        return client.execute(get);
    }

    private void validateResponse(HttpResponse response) throws IOException {
        if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() >= 300) {
            throw new IOException("HTTP status code = " + response.getStatusLine().getStatusCode());
        }
        Header contentType = response.getFirstHeader("Content-Type");
        if (contentType != null && StringUtils.indexOfIgnoreCase(contentType.getValue(), "application/x-gnutella-packets", Locale.ENGLISH) < 0) {
            throw new IOException("Unsupported Content-Type: " + contentType.getValue());
        }
        Header contentEncoding = response.getFirstHeader("Content-Encoding");
        if (contentEncoding != null) {
            throw new IOException("Unsupported Content-Encoding: " + contentEncoding.getValue());
        }
        Header contentLength = response.getFirstHeader("Content-Length");
        if (contentLength != null) {
            try {
                this._replyLength = Long.parseLong(contentLength.getValue());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
    }

    private void readQueryRepliesFromStream(HttpResponse response) {
        if (response.getEntity() != null) {
            InputStream in;
            try {
                in = response.getEntity().getContent();
            }
            catch (IOException e) {
                LOG.debug("Unable to read a single message", e);
                return;
            }
            Message m = null;
            while (true) {
                try {
                    m = null;
                    LOG.debug("reading message");
                    m = this.messageFactory.read(in, Message.Network.TCP);
                }
                catch (BadPacketException bpe) {
                    LOG.debug("BPE while reading", bpe);
                }
                catch (IOException expected) {
                    LOG.debug("IOE while reading", expected);
                }
                if (m == null) {
                    LOG.debug("Unable to read create message");
                    return;
                }
                if (!(m instanceof QueryReply)) continue;
                this._currentLength += (long)m.getTotalLength();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("BHH.browseExchange(): read QR:" + m);
                }
                QueryReply reply = (QueryReply)m;
                reply.setGUID(this._guid);
                reply.setBrowseHostReply(true);
                this.forMeReplyHandler.get().handleQueryReply(reply, null);
            }
        }
    }

    private boolean canConnectDirectly(IpPort host) {
        return !ConnectionSettings.LOCAL_IS_PRIVATE.getValue() || !this.networkInstanceUtils.isPrivateAddress(host.getAddress()) || this.networkInstanceUtils.isMe(host.getAddress(), host.getPort());
    }

    private boolean isLocalBrowse(IpPort host) {
        return this._serventID == null && this.networkInstanceUtils.isPrivateAddress(host.getAddress());
    }

    public static class PushRequestDetails {
        private BrowseHostHandler bhh;
        private long timeStamp = System.currentTimeMillis();

        public PushRequestDetails(BrowseHostHandler bhh) {
            this.bhh = bhh;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.timeStamp > 15000L;
        }

        public BrowseHostHandler getBrowseHostHandler() {
            return this.bhh;
        }
    }
}

