/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.messages.QueryRequest;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Comparators;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.io.IOUtils;
import org.limewire.util.CommonUtils;
import org.limewire.util.ConverterObjectInputStream;
import org.limewire.util.GenericsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class CreationTimeCache {
    private static final Log LOG = LogFactory.getLog(CreationTimeCache.class);
    private static final File CTIME_CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "createtimes.cache");
    private volatile boolean dirty = false;
    private final ExecutorService deserializeQueue = ExecutorsHelper.newProcessingQueue("CreationTimeCacheDeserializer");
    private final FileManager fileManager;
    private final Future<Maps> deserializer;

    @Inject
    CreationTimeCache(FileManager fileManager) {
        this.fileManager = fileManager;
        this.deserializer = this.deserializeQueue.submit(new Callable<Maps>(){

            @Override
            public Maps call() throws Exception {
                Map<URN, Long> urnToTime = CreationTimeCache.this.createMap();
                SortedMap timeToUrn = CreationTimeCache.this.constructURNMap(urnToTime);
                return new Maps(urnToTime, timeToUrn);
            }
        });
    }

    Map<URN, Long> getUrnToTime() {
        return this.getMaps().getUrnToTime();
    }

    SortedMap<Long, Set<URN>> getTimeToUrn() {
        return this.getMaps().getTimeToUrn();
    }

    private Maps getMaps() {
        boolean interrupted = false;
        while (true) {
            try {
                Maps maps = this.deserializer.get();
                return maps;
            }
            catch (InterruptedException tryAgain) {
                try {
                    interrupted = true;
                    continue;
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized int getSize() {
        return this.getUrnToTime().size();
    }

    public synchronized Long getCreationTime(URN urn) {
        return this.getUrnToTime().get(urn);
    }

    public long getCreationTimeAsLong(URN urn) {
        Long l = this.getCreationTime(urn);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    public synchronized void removeTime(URN urn) {
        Long time = this.getUrnToTime().remove(urn);
        this.removeURNFromURNSet(urn, time);
        if (time != null) {
            this.dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pruneTimes(boolean shouldClearURNSetMap) {
        FileManager fileManager = this.fileManager;
        synchronized (fileManager) {
            CreationTimeCache creationTimeCache = this;
            synchronized (creationTimeCache) {
                Iterator<Map.Entry<URN, Long>> iter = this.getUrnToTime().entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<URN, Long> currEntry = iter.next();
                    URN currURN = currEntry.getKey();
                    Long cTime = currEntry.getValue();
                    FileDesc fd = this.fileManager.getFileDescForUrn(currURN);
                    if (fd != null && fd.getFile() != null && fd.getFile().exists()) continue;
                    this.dirty = true;
                    iter.remove();
                    if (!shouldClearURNSetMap) continue;
                    this.removeURNFromURNSet(currURN, cTime);
                }
            }
        }
    }

    public void pruneTimes() {
        this.pruneTimes(true);
    }

    public synchronized void addTime(URN urn, long time) throws IllegalArgumentException {
        if (urn == null) {
            throw new IllegalArgumentException("Null URN.");
        }
        if (time <= 0L) {
            throw new IllegalArgumentException("Bad Time = " + time);
        }
        Long cTime = new Long(time);
        Long existing = this.getUrnToTime().get(urn);
        if (existing == null || !existing.equals(cTime)) {
            this.dirty = true;
            this.getUrnToTime().put(urn, cTime);
        }
    }

    public synchronized void commitTime(URN urn) throws IllegalArgumentException {
        if (urn == null) {
            throw new IllegalArgumentException("Null URN.");
        }
        Long cTime = this.getUrnToTime().get(urn);
        if (cTime == null) {
            throw new IllegalArgumentException("Never added URN via addTime()");
        }
        HashSet<URN> urnSet = (HashSet<URN>)this.getTimeToUrn().get(cTime);
        if (urnSet == null) {
            urnSet = new HashSet<URN>();
            this.getTimeToUrn().put(cTime, urnSet);
        }
        urnSet.add(urn);
    }

    public List<URN> getFiles(int max) throws IllegalArgumentException {
        return this.getFiles(null, max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URN> getFiles(QueryRequest request, int max) throws IllegalArgumentException {
        FileManager fileManager = this.fileManager;
        synchronized (fileManager) {
            CreationTimeCache creationTimeCache = this;
            synchronized (creationTimeCache) {
                if (max < 1) {
                    throw new IllegalArgumentException("bad max = " + max);
                }
                MediaType.Aggregator filter = request == null ? null : MediaType.getAggregator(request);
                ArrayList<URN> toRemove = null;
                ArrayList<URN> urnList = new ArrayList<URN>();
                block6: for (Set<URN> urns : this.getTimeToUrn().values()) {
                    if (urnList.size() >= max) break;
                    for (URN currURN : urns) {
                        if (urnList.size() >= max) continue block6;
                        FileDesc fd = this.fileManager.getFileDescForUrn(currURN);
                        if (fd != null && this.fileManager.isStoreFileLoaded(fd.getFile())) continue;
                        if (fd == null || fd instanceof IncompleteFileDesc) {
                            if (toRemove == null) {
                                toRemove = new ArrayList<URN>();
                            }
                            toRemove.add(currURN);
                            continue;
                        }
                        if (filter == null) {
                            urnList.add(currURN);
                            continue;
                        }
                        if (!filter.allow(fd.getFileName())) continue;
                        urnList.add(currURN);
                    }
                }
                if (toRemove != null) {
                    for (URN currURN : toRemove) {
                        this.removeTime(currURN);
                    }
                }
                return urnList;
            }
        }
    }

    public List<URN> getFiles() {
        return this.getFiles(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void persistCache() {
        if (!this.dirty) {
            return;
        }
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(CTIME_CACHE_FILE)));
            oos.writeObject(this.getUrnToTime());
            IOUtils.close(oos);
        }
        catch (IOException e) {
            LOG.error("Unable to write creation cache", e);
        }
        finally {
            IOUtils.close(oos);
        }
        this.dirty = false;
    }

    private synchronized void removeURNFromURNSet(URN urn, Long refTime) {
        block2: {
            block1: {
                if (refTime == null) break block1;
                Set urnSet = (Set)this.getTimeToUrn().get(refTime);
                if (urnSet == null || !urnSet.remove(urn) || urnSet.size() >= 1) break block2;
                this.getTimeToUrn().remove(refTime);
                break block2;
            }
            Iterator<Set<URN>> i = this.getTimeToUrn().values().iterator();
            while (i.hasNext()) {
                Set<URN> urnSet = i.next();
                if (!urnSet.contains(urn)) continue;
                urnSet.remove(urn);
                if (urnSet.size() >= 1) break;
                i.remove();
                break;
            }
        }
    }

    private SortedMap<Long, Set<URN>> constructURNMap(Map<URN, Long> urnToTime) {
        TreeMap<Long, Set<URN>> timeToUrn = new TreeMap<Long, Set<URN>>(Comparators.inverseLongComparator());
        for (Map.Entry<URN, Long> currEntry : urnToTime.entrySet()) {
            Long cTime = currEntry.getValue();
            URN urn = currEntry.getKey();
            HashSet<URN> urnSet = (HashSet<URN>)timeToUrn.get(cTime);
            if (urnSet == null) {
                urnSet = new HashSet<URN>();
                timeToUrn.put(cTime, urnSet);
            }
            urnSet.add(urn);
        }
        return timeToUrn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<URN, Long> createMap() {
        Map<URN, Long> map;
        if (!CTIME_CACHE_FILE.exists()) {
            this.dirty = true;
            return new HashMap<URN, Long>();
        }
        ConverterObjectInputStream ois = null;
        try {
            Map<URN, Long> map2;
            ois = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(CTIME_CACHE_FILE)));
            map = map2 = GenericsUtils.scanForMap(ois.readObject(), URN.class, Long.class, GenericsUtils.ScanMode.REMOVE);
        }
        catch (Throwable t) {
            HashMap<URN, Long> hashMap;
            try {
                this.dirty = true;
                LOG.error("Unable to read creation time file", t);
                hashMap = new HashMap<URN, Long>();
            }
            catch (Throwable throwable) {
                IOUtils.close(ois);
                throw throwable;
            }
            IOUtils.close(ois);
            return hashMap;
        }
        IOUtils.close(ois);
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Maps {
        private final Map<URN, Long> urnToTime;
        private final SortedMap<Long, Set<URN>> timeToUrn;

        Maps(Map<URN, Long> urnToTime, SortedMap<Long, Set<URN>> timeToUrn) {
            this.urnToTime = urnToTime;
            this.timeToUrn = timeToUrn;
        }

        public SortedMap<Long, Set<URN>> getTimeToUrn() {
            return this.timeToUrn;
        }

        public Map<URN, Long> getUrnToTime() {
            return this.urnToTime;
        }
    }
}

