/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.bittorrent.BTDownloader;
import com.limegroup.bittorrent.BTMetaInfo;
import com.limegroup.bittorrent.BTMetaInfoFactory;
import com.limegroup.bittorrent.TorrentFileSystem;
import com.limegroup.bittorrent.TorrentManager;
import com.limegroup.gnutella.DownloadCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.DownloadManagerEvent;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.CoreDownloader;
import com.limegroup.gnutella.downloader.CoreDownloaderFactory;
import com.limegroup.gnutella.downloader.DownloaderType;
import com.limegroup.gnutella.downloader.InNetworkDownloader;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.MagnetDownloader;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.PushDownloadManager;
import com.limegroup.gnutella.downloader.PushedSocketHandlerRegistry;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.downloader.ResumeDownloader;
import com.limegroup.gnutella.downloader.StoreDownloader;
import com.limegroup.gnutella.downloader.Visitor;
import com.limegroup.gnutella.downloader.serial.BTMetaInfoMemento;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.gnutella.downloader.serial.DownloadSerializer;
import com.limegroup.gnutella.library.SharingUtils;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.UpdateSettings;
import com.limegroup.gnutella.version.DownloadInformation;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.DualIterator;
import org.limewire.collection.MultiIterable;
import org.limewire.i18n.I18nMarker;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPort;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.service.MessageService;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DownloadManagerImpl
implements DownloadManager {
    private static final Log LOG = LogFactory.getLog(DownloadManagerImpl.class);
    private int SNAPSHOT_CHECKPOINT_TIME = 30000;
    private final List<CoreDownloader> active = new LinkedList<CoreDownloader>();
    private final List<CoreDownloader> waiting = new LinkedList<CoreDownloader>();
    private final MultiIterable<CoreDownloader> activeAndWaiting = new MultiIterable<CoreDownloader>((Iterable<CoreDownloader>)this.active, (Iterable<CoreDownloader>)this.waiting);
    private volatile boolean downloadsReadFromDisk = false;
    private int innetworkCount = 0;
    private int storeDownloadCount = 0;
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private volatile float lastMeasuredBandwidth;
    private Runnable _waitingPump;
    private final EventListenerList<DownloadManagerEvent> listeners = new EventListenerList();
    private final NetworkManager networkManager;
    private final DownloadCallback innetworkCallback;
    private final Provider<DownloadCallback> downloadCallback;
    private final Provider<MessageRouter> messageRouter;
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<TorrentManager> torrentManager;
    private final Provider<PushDownloadManager> pushDownloadManager;
    private final CoreDownloaderFactory coreDownloaderFactory;
    private final DownloadSerializer downloadSerializer;
    private final IncompleteFileManager incompleteFileManager;
    private final RemoteFileDescFactory remoteFileDescFactory;
    private final BTMetaInfoFactory btMetaInfoFactory;

    @Inject
    public DownloadManagerImpl(NetworkManager networkManager, @Named(value="inNetwork") DownloadCallback innetworkCallback, Provider<DownloadCallback> downloadCallback, Provider<MessageRouter> messageRouter, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<TorrentManager> torrentManager, Provider<PushDownloadManager> pushDownloadManager, CoreDownloaderFactory coreDownloaderFactory, DownloadSerializer downloaderSerializer, IncompleteFileManager incompleteFileManager, RemoteFileDescFactory remoteFileDescFactory, BTMetaInfoFactory btMetaInfoFactory) {
        this.networkManager = networkManager;
        this.innetworkCallback = innetworkCallback;
        this.downloadCallback = downloadCallback;
        this.messageRouter = messageRouter;
        this.backgroundExecutor = backgroundExecutor;
        this.torrentManager = torrentManager;
        this.pushDownloadManager = pushDownloadManager;
        this.coreDownloaderFactory = coreDownloaderFactory;
        this.downloadSerializer = downloaderSerializer;
        this.incompleteFileManager = incompleteFileManager;
        this.remoteFileDescFactory = remoteFileDescFactory;
        this.btMetaInfoFactory = btMetaInfoFactory;
    }

    @Inject
    public void register(PushedSocketHandlerRegistry registry) {
        registry.register(this);
    }

    @Override
    public void initialize() {
        this.scheduleWaitingPump();
    }

    @Override
    public void addNewDownloader(CoreDownloader downloader) {
        this.initializeDownload(downloader, false);
    }

    @Override
    public void loadSavedDownloadsAndScheduleWriting() {
        this.loadSavedDownloads();
        this.scheduleSnapshots();
    }

    public void loadSavedDownloads() {
        List<DownloadMemento> mementos;
        boolean failedAll = true;
        boolean failedSome = false;
        try {
            mementos = this.downloadSerializer.readFromDisk();
            if (mementos.isEmpty()) {
                failedAll = false;
            }
        }
        catch (IOException ioex) {
            mementos = Collections.emptyList();
        }
        for (DownloadMemento memento : mementos) {
            CoreDownloader coreDownloader = this.prepareMemento(memento);
            if (coreDownloader != null) {
                failedAll = false;
                this.addNewDownloader(coreDownloader);
                continue;
            }
            failedSome = true;
        }
        this.downloadsReadFromDisk = true;
        if (failedAll) {
            MessageService.showError(I18nMarker.marktr("Sorry, LimeWire couldn't read your old downloads.  You can restart them by going to your Library, viewing your 'Incomplete Files', and clicking to 'Resume' your downloads."));
        } else if (failedSome) {
            MessageService.showError(I18nMarker.marktr("Sorry, LimeWire couldn't read some of your old downloads.  You can restart them by going to your Library, viewing your 'Incomplete Files', and clicking to 'Resume' your downloads."));
        }
    }

    public CoreDownloader prepareMemento(DownloadMemento memento) {
        try {
            return this.coreDownloaderFactory.createFromMemento(memento);
        }
        catch (InvalidDataException ide) {
            LOG.warn("Unable to read download from memento: " + memento, ide);
            return null;
        }
    }

    public void scheduleSnapshots() {
        Runnable checkpointer = new Runnable(){

            public void run() {
                if (DownloadManagerImpl.this.downloadsInProgress() > 0) {
                    DownloadManagerImpl.this.writeSnapshot();
                }
            }
        };
        this.backgroundExecutor.scheduleWithFixedDelay(checkpointer, this.SNAPSHOT_CHECKPOINT_TIME, this.SNAPSHOT_CHECKPOINT_TIME, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeSnapshot() {
        ArrayList<DownloadMemento> mementos;
        DownloadManagerImpl downloadManagerImpl = this;
        synchronized (downloadManagerImpl) {
            mementos = new ArrayList<DownloadMemento>(this.active.size() + this.waiting.size());
            for (CoreDownloader downloader : this.activeAndWaiting) {
                mementos.add(downloader.toMemento());
            }
        }
        this.downloadSerializer.writeToDisk(mementos);
    }

    @Override
    public boolean isSavedDownloadsLoaded() {
        return this.downloadsReadFromDisk;
    }

    @Override
    public synchronized boolean hasInNetworkDownload() {
        if (this.innetworkCount > 0) {
            return true;
        }
        Iterator<CoreDownloader> i = this.waiting.iterator();
        while (i.hasNext()) {
            if (i.next().getDownloadType() != DownloaderType.INNETWORK) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void killDownloadersNotListed(Collection<? extends DownloadInformation> updates) {
        if (updates == null) {
            return;
        }
        HashSet<String> urns = new HashSet<String>(updates.size());
        for (DownloadInformation downloadInformation : updates) {
            urns.add(downloadInformation.getUpdateURN().httpStringValue());
        }
        DualIterator<CoreDownloader> iter = new DualIterator<CoreDownloader>(this.waiting.iterator(), this.active.iterator());
        while (iter.hasNext()) {
            CoreDownloader coreDownloader = (CoreDownloader)iter.next();
            if (coreDownloader.getDownloadType() != DownloaderType.INNETWORK || urns.contains(coreDownloader.getSha1Urn().httpStringValue())) continue;
            coreDownloader.stop();
        }
        Set<String> hopeless = UpdateSettings.FAILED_UPDATES.getValue();
        hopeless.retainAll(urns);
        UpdateSettings.FAILED_UPDATES.setValue(hopeless);
    }

    PushDownloadManager getPushManager() {
        return this.pushDownloadManager.get();
    }

    private synchronized boolean handleIncomingPush(String file, int index, byte[] clientGUID, Socket socket) {
        boolean handled = false;
        for (CoreDownloader md : this.activeAndWaiting) {
            ManagedDownloader mmd;
            if (!(md instanceof ManagedDownloader) || !(mmd = (ManagedDownloader)md).acceptDownload(file, socket, index, clientGUID)) continue;
            return true;
        }
        return handled;
    }

    @Override
    public boolean acceptPushedSocket(String file, int index, byte[] clientGUID, Socket socket) {
        return this.handleIncomingPush(file, index, clientGUID, socket);
    }

    public void scheduleWaitingPump() {
        if (this._waitingPump != null) {
            return;
        }
        this._waitingPump = new Runnable(){

            public void run() {
                DownloadManagerImpl.this.pumpDownloads();
            }
        };
        this.backgroundExecutor.scheduleWithFixedDelay(this._waitingPump, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    protected synchronized void pumpDownloads() {
        int index = 1;
        Iterator<CoreDownloader> i = this.waiting.iterator();
        while (i.hasNext()) {
            CoreDownloader md = i.next();
            if (md.isAlive()) continue;
            if (md.shouldBeRemoved()) {
                i.remove();
                this.cleanupCompletedDownload(md, false);
                continue;
            }
            if (this.storeDownloadCount == 0 && md.getDownloadType() == DownloaderType.STORE) {
                i.remove();
                ++this.storeDownloadCount;
                this.active.add(md);
                md.startDownload();
                continue;
            }
            if (this.hasFreeSlot() && md.shouldBeRestarted() && md.getDownloadType() != DownloaderType.STORE) {
                i.remove();
                if (md.getDownloadType() == DownloaderType.INNETWORK) {
                    ++this.innetworkCount;
                }
                this.active.add(md);
                md.startDownload();
                continue;
            }
            if (md.isQueuable()) {
                md.setInactivePriority(index++);
            }
            md.handleInactivity();
        }
    }

    @Override
    public boolean isIncomplete(URN urn) {
        return this.incompleteFileManager.getFileForUrn(urn) != null;
    }

    @Override
    public boolean isActivelyDownloading(URN urn) {
        Downloader md = this.getDownloaderForURN(urn);
        if (md == null) {
            return false;
        }
        switch (md.getState()) {
            case QUEUED: 
            case BUSY: 
            case ABORTED: 
            case GAVE_UP: 
            case DISK_PROBLEM: 
            case CORRUPT_FILE: 
            case REMOTE_QUEUED: 
            case WAITING_FOR_USER: {
                return false;
            }
        }
        return true;
    }

    @Override
    public IncompleteFileManager getIncompleteFileManager() {
        return this.incompleteFileManager;
    }

    @Override
    public synchronized int downloadsInProgress() {
        return this.active.size() + this.waiting.size();
    }

    @Override
    public synchronized int getNumIndividualDownloaders() {
        int ret = 0;
        for (CoreDownloader next : this.active) {
            if (!(next instanceof ManagedDownloader)) continue;
            ManagedDownloader md = (ManagedDownloader)next;
            ret += md.getNumDownloaders();
        }
        return ret;
    }

    @Override
    public synchronized int getNumActiveDownloads() {
        return this.active.size() - this.innetworkCount - this.storeDownloadCount;
    }

    @Override
    public synchronized int getNumWaitingDownloads() {
        return this.waiting.size();
    }

    @Override
    public synchronized Downloader getDownloaderForURN(URN sha1) {
        for (CoreDownloader md : this.activeAndWaiting) {
            if (md.getSha1Urn() == null || !sha1.equals(md.getSha1Urn())) continue;
            return md;
        }
        return null;
    }

    public synchronized Downloader getDownloaderForURNString(String urn) {
        for (CoreDownloader md : this.activeAndWaiting) {
            if (md.getSha1Urn() == null || !urn.equals(md.getSha1Urn().toString())) continue;
            return md;
        }
        return null;
    }

    @Override
    public synchronized Downloader getDownloaderForIncompleteFile(File file) {
        for (CoreDownloader dl : this.activeAndWaiting) {
            if (!dl.conflictsWithIncompleteFile(file)) continue;
            return dl;
        }
        return null;
    }

    @Override
    public synchronized boolean isGuidForQueryDownloading(GUID guid) {
        for (CoreDownloader md : this.activeAndWaiting) {
            GUID dGUID = md.getQueryGUID();
            if (dGUID == null || !dGUID.equals(guid)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAllDownloads() {
        ArrayList<CoreDownloader> buf;
        DownloadManagerImpl downloadManagerImpl = this;
        synchronized (downloadManagerImpl) {
            buf = new ArrayList<CoreDownloader>(this.active.size() + this.waiting.size());
            buf.addAll(this.active);
            buf.addAll(this.waiting);
            this.active.clear();
            this.waiting.clear();
        }
        for (CoreDownloader md : buf) {
            md.stop();
            this.fireEvent(md, DownloadManagerEvent.Type.REMOVED);
        }
    }

    @Override
    public synchronized Downloader download(RemoteFileDesc[] files, List<? extends RemoteFileDesc> alts, GUID queryGUID, boolean overwrite, File saveDir, String fileName) throws SaveLocationException {
        String fName = this.getFileName(files, fileName);
        if (this.conflicts(files, new File(saveDir, fName))) {
            throw new SaveLocationException(10, new File(fName != null ? fName : ""));
        }
        this.incompleteFileManager.purge();
        ManagedDownloader downloader = this.coreDownloaderFactory.createManagedDownloader(files, queryGUID, saveDir, fileName, overwrite);
        this.initializeDownload(downloader, true);
        downloader.addDownload(alts, false);
        return downloader;
    }

    @Override
    public synchronized Downloader download(MagnetOptions magnet, boolean overwrite, File saveDir, String fileName) throws IllegalArgumentException, SaveLocationException {
        if (!magnet.isDownloadable()) {
            throw new IllegalArgumentException("magnet not downloadable");
        }
        this.incompleteFileManager.purge();
        if (fileName == null) {
            fileName = magnet.getFileNameForSaving();
        }
        if (this.conflicts(magnet.getSHA1Urn(), 0L, new File(saveDir, fileName))) {
            throw new SaveLocationException(10, new File(fileName));
        }
        MagnetDownloader downloader = this.coreDownloaderFactory.createMagnetDownloader(magnet, overwrite, saveDir, fileName);
        this.initializeDownload(downloader, true);
        return downloader;
    }

    @Override
    public synchronized Downloader downloadFromStore(RemoteFileDesc rfd, boolean overwrite, File saveDir, String fileName) throws IllegalArgumentException, SaveLocationException {
        this.incompleteFileManager.purge();
        if (this.conflicts(rfd.getSHA1Urn(), 0L, new File(saveDir, fileName))) {
            throw new SaveLocationException(10, new File(fileName));
        }
        StoreDownloader downloader = this.coreDownloaderFactory.createStoreDownloader(rfd, saveDir, fileName, overwrite);
        this.initializeDownload(downloader, true);
        return downloader;
    }

    @Override
    public synchronized Downloader download(File incompleteFile) throws CantResumeException, SaveLocationException {
        if (this.conflictsWithIncompleteFile(incompleteFile)) {
            throw new SaveLocationException(10, incompleteFile);
        }
        if (IncompleteFileManager.isTorrentFolder(incompleteFile)) {
            return this.resumeTorrentDownload(incompleteFile);
        }
        this.incompleteFileManager.purge();
        ResumeDownloader downloader = null;
        try {
            incompleteFile = FileUtils.getCanonicalFile(incompleteFile);
            String name = IncompleteFileManager.getCompletedName(incompleteFile);
            long size = IncompleteFileManager.getCompletedSize(incompleteFile);
            downloader = this.coreDownloaderFactory.createResumeDownloader(incompleteFile, name, size);
        }
        catch (IllegalArgumentException e) {
            throw new CantResumeException(incompleteFile.getName());
        }
        catch (IOException ioe) {
            throw new CantResumeException(incompleteFile.getName());
        }
        this.initializeDownload(downloader, true);
        return downloader;
    }

    private Downloader resumeTorrentDownload(File torrentFolder) throws CantResumeException, SaveLocationException {
        BTMetaInfo info;
        File infohash = null;
        for (File f : torrentFolder.listFiles()) {
            if (!f.getName().startsWith(".dat")) continue;
            infohash = f;
            break;
        }
        String name = IncompleteFileManager.getCompletedName(torrentFolder);
        if (infohash == null) {
            throw new CantResumeException(name);
        }
        BTMetaInfoMemento memento = null;
        try {
            Object infoObj = FileUtils.readObject(infohash.getAbsolutePath());
            memento = (BTMetaInfoMemento)infoObj;
        }
        catch (Throwable bad) {
            throw new CantResumeException(name);
        }
        try {
            info = this.btMetaInfoFactory.createBTMetaInfoFromMemento(memento);
        }
        catch (InvalidDataException ide) {
            throw new CantResumeException(name);
        }
        Downloader ret = this.downloadTorrent(info, false);
        if (ret.isResumable()) {
            ret.resume();
        }
        return ret;
    }

    @Override
    public synchronized Downloader download(DownloadInformation info, long now) throws SaveLocationException {
        File dir = SharingUtils.PREFERENCE_SHARE;
        dir.mkdirs();
        File f = new File(dir, info.getUpdateFileName());
        if (this.conflicts(info.getUpdateURN(), (int)info.getSize(), f)) {
            throw new SaveLocationException(10, f);
        }
        this.incompleteFileManager.purge();
        InNetworkDownloader d = this.coreDownloaderFactory.createInNetworkDownloader(info, dir, now);
        this.initializeDownload(d, true);
        return d;
    }

    @Override
    public synchronized Downloader downloadTorrent(BTMetaInfo info, boolean overwrite) throws SaveLocationException {
        TorrentFileSystem system = info.getFileSystem();
        this.checkActiveAndWaiting(info.getURN(), system);
        if (!overwrite) {
            this.checkTargetLocation(system, overwrite);
        } else {
            this.torrentManager.get().killTorrentForFile(system.getCompleteFile());
        }
        BTDownloader ret = this.coreDownloaderFactory.createBTDownloader(info);
        this.initializeDownload(ret, true);
        return ret;
    }

    private void checkTargetLocation(TorrentFileSystem info, boolean overwrite) throws SaveLocationException {
        for (File f : info.getFilesAndFolders()) {
            if (!f.exists()) continue;
            throw new SaveLocationException(5, f);
        }
    }

    private void checkActiveAndWaiting(URN urn, TorrentFileSystem system) throws SaveLocationException {
        for (CoreDownloader current : this.activeAndWaiting) {
            if (urn.equals(current.getSha1Urn())) {
                throw new SaveLocationException(10, system.getCompleteFile());
            }
            for (File f : system.getFilesAndFolders()) {
                if (!current.conflictsSaveFile(f)) continue;
                throw new SaveLocationException(6, f);
            }
        }
    }

    private synchronized void initializeDownload(CoreDownloader md, boolean saveState) {
        md.initialize();
        this.waiting.add(md);
        this.callback(md).addDownload(md);
        if (saveState) {
            this.backgroundExecutor.execute(new Runnable(){

                public void run() {
                    DownloadManagerImpl.this.writeSnapshot();
                }
            });
        }
        this.fireEvent(md, DownloadManagerEvent.Type.ADDED);
    }

    private DownloadCallback callback(Downloader md) {
        return md instanceof InNetworkDownloader ? this.innetworkCallback : this.downloadCallback.get();
    }

    private boolean conflicts(RemoteFileDesc[] rfds, File ... fileName) {
        URN urn = null;
        for (int i = 0; i < rfds.length && urn == null; ++i) {
            urn = rfds[0].getSHA1Urn();
        }
        return this.conflicts(urn, rfds[0].getSize(), fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean conflicts(URN urn, long fileSize, File ... fileName) {
        if (urn == null && fileSize == 0L) {
            return false;
        }
        DownloadManagerImpl downloadManagerImpl = this;
        synchronized (downloadManagerImpl) {
            for (CoreDownloader md : this.activeAndWaiting) {
                if (!md.conflicts(urn, fileSize, fileName)) continue;
                return true;
            }
            return false;
        }
    }

    @Override
    public synchronized boolean isSaveLocationTaken(File candidateFile) {
        for (CoreDownloader md : this.activeAndWaiting) {
            if (!md.conflictsSaveFile(candidateFile)) continue;
            return true;
        }
        return false;
    }

    private synchronized boolean conflictsWithIncompleteFile(File incompleteFile) {
        for (CoreDownloader md : this.activeAndWaiting) {
            if (!md.conflictsWithIncompleteFile(incompleteFile)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handleQueryReply(QueryReply qr) {
        HostData data;
        List<Response> responses;
        if (qr.calculateQualityOfService(!this.networkManager.acceptedIncomingConnection(), this.networkManager) < 1) {
            return;
        }
        try {
            responses = qr.getResultsAsList();
            data = qr.getHostData();
        }
        catch (BadPacketException bpe) {
            return;
        }
        this.addDownloadWithResponses(responses, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDownloadWithResponses(List<? extends Response> responses, HostData data) {
        if (responses == null) {
            throw new NullPointerException("null responses");
        }
        if (data == null) {
            throw new NullPointerException("null hostdata");
        }
        ArrayList<CoreDownloader> downloaders = new ArrayList<CoreDownloader>(this.active.size() + this.waiting.size());
        DownloadManagerImpl downloadManagerImpl = this;
        synchronized (downloadManagerImpl) {
            downloaders.addAll(this.active);
            downloaders.addAll(this.waiting);
        }
        if (downloaders.isEmpty()) {
            return;
        }
        block3: for (Response response : responses) {
            RemoteFileDesc rfd = response.toRemoteFileDesc(data, this.remoteFileDescFactory);
            for (CoreDownloader current : downloaders) {
                ManagedDownloader currD;
                if (!(current instanceof ManagedDownloader) || !(currD = (ManagedDownloader)current).addDownload(rfd, true)) continue;
                for (IpPort ipPort : response.getLocations()) {
                    currD.addDownload(this.remoteFileDescFactory.createRemoteFileDesc(rfd, ipPort), false);
                }
                continue block3;
            }
        }
    }

    private boolean hasFreeSlot() {
        return this.active.size() - this.innetworkCount - this.storeDownloadCount < DownloadSettings.MAX_SIM_DOWNLOAD.getValue();
    }

    @Override
    public synchronized void remove(CoreDownloader downloader, boolean completed) {
        boolean isRemoved = this.active.remove(downloader);
        if (downloader.getDownloadType() == DownloaderType.INNETWORK) {
            --this.innetworkCount;
        }
        if (downloader.getDownloadType() == DownloaderType.STORE && isRemoved) {
            --this.storeDownloadCount;
        }
        this.waiting.remove(downloader);
        if (completed) {
            this.cleanupCompletedDownload(downloader, true);
        } else {
            this.waiting.add(downloader);
        }
    }

    @Override
    public synchronized void bumpPriority(Downloader downl, boolean up, int amt) {
        CoreDownloader downloader = (CoreDownloader)downl;
        int idx = this.waiting.indexOf(downloader);
        if (idx == -1) {
            return;
        }
        if (up && idx != 0) {
            this.waiting.remove(idx);
            if (amt > idx) {
                amt = idx;
            }
            if (amt != 0) {
                this.waiting.add(idx - amt, downloader);
            } else {
                this.waiting.add(0, downloader);
            }
        } else if (!up && idx != this.waiting.size() - 1) {
            this.waiting.remove(idx);
            if (amt != 0) {
                if ((amt += idx) > this.waiting.size()) {
                    amt = this.waiting.size();
                }
                this.waiting.add(amt, downloader);
            } else {
                this.waiting.add(downloader);
            }
        }
    }

    private void cleanupCompletedDownload(CoreDownloader dl, boolean ser) {
        dl.finish();
        if (dl.getQueryGUID() != null) {
            this.messageRouter.get().downloadFinished(dl.getQueryGUID());
        }
        this.callback(dl).removeDownload(dl);
        if (ser) {
            this.writeSnapshot();
        }
        if (this.active.isEmpty() && this.waiting.isEmpty()) {
            this.callback(dl).downloadsComplete();
        }
        this.fireEvent(dl, DownloadManagerEvent.Type.REMOVED);
    }

    @Override
    public void sendQuery(QueryRequest query) {
        this.messageRouter.get().sendDynamicQuery(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void measureBandwidth() {
        ArrayList<CoreDownloader> activeCopy;
        DownloadManagerImpl downloadManagerImpl = this;
        synchronized (downloadManagerImpl) {
            activeCopy = new ArrayList<CoreDownloader>(this.active);
        }
        float currentTotal = 0.0f;
        boolean c = false;
        for (CoreDownloader bt : activeCopy) {
            if (bt instanceof InNetworkDownloader) continue;
            c = true;
            bt.measureBandwidth();
            currentTotal += bt.getAverageBandwidth();
        }
        if (c) {
            DownloadManagerImpl downloadManagerImpl2 = this;
            synchronized (downloadManagerImpl2) {
                this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + currentTotal) / (float)(++this.numMeasures);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getMeasuredBandwidth() {
        ArrayList<CoreDownloader> activeCopy;
        DownloadManagerImpl downloadManagerImpl = this;
        synchronized (downloadManagerImpl) {
            activeCopy = new ArrayList<CoreDownloader>(this.active);
        }
        float sum = 0.0f;
        for (CoreDownloader bt : activeCopy) {
            if (bt instanceof InNetworkDownloader) continue;
            float curr = 0.0f;
            try {
                curr = bt.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {
                curr = 0.0f;
            }
            sum += curr;
        }
        this.lastMeasuredBandwidth = sum;
        return sum;
    }

    @Override
    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    @Override
    public float getLastMeasuredBandwidth() {
        return this.lastMeasuredBandwidth;
    }

    private String getFileName(RemoteFileDesc[] rfds, String fileName) {
        for (int i = 0; i < rfds.length && fileName == null; ++i) {
            fileName = rfds[i].getFileName();
        }
        return fileName;
    }

    @Override
    public final Iterable<CoreDownloader> getAllDownloaders() {
        return this.activeAndWaiting;
    }

    @Override
    public synchronized void visitDownloads(Visitor<CoreDownloader> visitor) {
        for (CoreDownloader downloader : this.activeAndWaiting) {
            visitor.visit(downloader);
        }
    }

    private void fireEvent(CoreDownloader downloader, DownloadManagerEvent.Type type) {
        this.listeners.broadcast(new DownloadManagerEvent(downloader, type));
    }

    @Override
    public void addListener(EventListener<DownloadManagerEvent> listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public boolean removeListener(EventListener<DownloadManagerEvent> listener) {
        return this.listeners.removeListener(listener);
    }
}

