/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManagerController;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseFactory;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.UrnCallback;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.auth.ContentResponseData;
import com.limegroup.gnutella.auth.ContentResponseObserver;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.metadata.MetaDataReader;
import com.limegroup.gnutella.simpp.SimppListener;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.version.UpdateHandler;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLReplyCollectionFactory;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class FileManagerControllerImpl
implements FileManagerController {
    private final Provider<UrnCache> urnCache;
    private final Provider<DownloadManager> downloadManager;
    private final Provider<CreationTimeCache> creationTimeCache;
    private final Provider<ContentManager> contentManager;
    private final Provider<AltLocManager> altLocManager;
    private final Provider<ResponseFactory> responseFactory;
    private final Provider<SavedFileManager> savedFileManager;
    private final Provider<SimppManager> simppManager;
    private final Provider<UpdateHandler> updateHandler;
    private final Provider<ActivityCallback> activityCallback;
    private final ScheduledExecutorService backgroundExecutor;
    private final LimeXMLReplyCollectionFactory limeXMLReplyCollectionFactory;
    private final LimeXMLDocumentFactory limeXMLDocumentFactory;
    private final MetaDataReader metaDataReader;
    private final Provider<SchemaReplyCollectionMapper> schemaReplyCollectionMapper;
    private final Provider<LimeXMLSchemaRepository> limeXMLSchemaRepository;

    @Inject
    public FileManagerControllerImpl(Provider<UrnCache> urnCache, Provider<DownloadManager> downloadManager, Provider<CreationTimeCache> creationTimeCache, Provider<ContentManager> contentManager, Provider<AltLocManager> altLocManager, Provider<ResponseFactory> responseFactory, Provider<SavedFileManager> savedFileManager, Provider<SimppManager> simppManager, Provider<UpdateHandler> updateHandler, Provider<ActivityCallback> activityCallback, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, LimeXMLReplyCollectionFactory limeXMLReplyCollectionFactory, LimeXMLDocumentFactory limeXMLDocumentFactory, MetaDataReader metaDataReader, Provider<SchemaReplyCollectionMapper> schemaReplyCollectionMapper, Provider<LimeXMLSchemaRepository> limeXMLSchemaRepository) {
        this.urnCache = urnCache;
        this.downloadManager = downloadManager;
        this.creationTimeCache = creationTimeCache;
        this.contentManager = contentManager;
        this.altLocManager = altLocManager;
        this.responseFactory = responseFactory;
        this.savedFileManager = savedFileManager;
        this.simppManager = simppManager;
        this.updateHandler = updateHandler;
        this.activityCallback = activityCallback;
        this.backgroundExecutor = backgroundExecutor;
        this.limeXMLReplyCollectionFactory = limeXMLReplyCollectionFactory;
        this.limeXMLDocumentFactory = limeXMLDocumentFactory;
        this.metaDataReader = metaDataReader;
        this.schemaReplyCollectionMapper = schemaReplyCollectionMapper;
        this.limeXMLSchemaRepository = limeXMLSchemaRepository;
    }

    @Override
    public void save() {
        this.urnCache.get().persistCache();
        this.creationTimeCache.get().persistCache();
    }

    @Override
    public void loadStarted() {
        this.urnCache.get().clearPendingHashes(this);
    }

    @Override
    public void loadFinished() {
        this.creationTimeCache.get().pruneTimes();
        this.downloadManager.get().getIncompleteFileManager().registerAllIncompleteFiles();
    }

    @Override
    public void clearPendingShare(File f) {
        this.urnCache.get().clearPendingHashesFor(f, this);
    }

    @Override
    public void calculateAndCacheUrns(File file, UrnCallback callback) {
        this.urnCache.get().calculateAndCacheUrns(file, callback);
    }

    @Override
    public void addUrns(File file, Set<? extends URN> urns) {
        this.urnCache.get().addUrns(file, urns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileAdded(File file, URN urn) {
        CreationTimeCache cache;
        CreationTimeCache creationTimeCache = cache = this.creationTimeCache.get();
        synchronized (creationTimeCache) {
            Long cTime = cache.getCreationTime(urn);
            if (cTime == null) {
                cTime = new Long(file.lastModified());
            }
            if (cTime > 0L) {
                cache.addTime(urn, cTime);
                cache.commitTime(urn);
            }
        }
    }

    @Override
    public void lastUrnRemoved(URN urn) {
        this.altLocManager.get().purge(urn);
        this.creationTimeCache.get().removeTime(urn);
    }

    @Override
    public List<URN> getNewestSharedUrns(QueryRequest qr, int number) {
        return this.creationTimeCache.get().getFiles(qr, number);
    }

    @Override
    public ContentResponseData getResponseDataFor(URN urn) {
        return this.contentManager.get().getResponse(urn);
    }

    @Override
    public void requestValidation(URN urn, ContentResponseObserver observer) {
        this.contentManager.get().request(urn, observer, 5000L);
    }

    @Override
    public int getAlternateLocationCount(URN urn) {
        return this.altLocManager.get().getNumLocs(urn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileChanged(URN urn, Long time) {
        CreationTimeCache cache;
        CreationTimeCache creationTimeCache = cache = this.creationTimeCache.get();
        synchronized (creationTimeCache) {
            cache.removeTime(urn);
            cache.addTime(urn, time);
            cache.commitTime(urn);
        }
    }

    @Override
    public Long getCreationTime(URN urn) {
        return this.creationTimeCache.get().getCreationTime(urn);
    }

    @Override
    public Response createPureMetadataResponse() {
        return this.responseFactory.get().createResponse(0xFFFFFFFFL, 0L, " ");
    }

    @Override
    public Response createResponse(FileDesc desc) {
        return this.responseFactory.get().createResponse(desc);
    }

    @Override
    public void loadFinishedPostSave() {
        this.savedFileManager.get().run();
        this.updateHandler.get().tryToDownloadUpdates();
        this.activityCallback.get().fileManagerLoaded();
    }

    @Override
    public void addSimppListener(SimppListener listener) {
        this.simppManager.get().addListener(listener);
    }

    @Override
    public void removeSimppListener(SimppListener listener) {
        this.simppManager.get().removeListener(listener);
    }

    @Override
    public void fileManagerLoading() {
        this.activityCallback.get().fileManagerLoading();
    }

    @Override
    public void handleSharedFileUpdate(File file) {
        this.activityCallback.get().handleSharedFileUpdate(file);
    }

    @Override
    public void scheduleWithFixedDelay(Runnable command, int initialDelay, int delay, TimeUnit unit) {
        this.backgroundExecutor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public void setAnnotateEnabled(boolean enabled) {
        this.activityCallback.get().setAnnotateEnabled(enabled);
    }

    @Override
    public boolean warnAboutSharingSensitiveDirectory(File directory) {
        return this.activityCallback.get().warnAboutSharingSensitiveDirectory(directory);
    }

    @Override
    public LimeXMLReplyCollection createLimeXMLReplyCollection(String URI2) {
        return this.limeXMLReplyCollectionFactory.createLimeXMLReplyCollection(URI2);
    }

    @Override
    public LimeXMLDocument createLimeXMLDocument(Collection<? extends Map.Entry<String, String>> nameValueList, String schemaURI) {
        return this.limeXMLDocumentFactory.createLimeXMLDocument(nameValueList, schemaURI);
    }

    @Override
    public LimeXMLDocument readDocument(File file) throws IOException {
        return this.metaDataReader.readDocument(file);
    }

    @Override
    public void add(String schemaURI, LimeXMLReplyCollection replyCollection) {
        this.schemaReplyCollectionMapper.get().add(schemaURI, replyCollection);
    }

    @Override
    public Collection<LimeXMLReplyCollection> getCollections() {
        return this.schemaReplyCollectionMapper.get().getCollections();
    }

    @Override
    public LimeXMLReplyCollection getReplyCollection(String schemaURI) {
        return this.schemaReplyCollectionMapper.get().getReplyCollection(schemaURI);
    }

    @Override
    public String[] getAvailableSchemaURIs() {
        return this.limeXMLSchemaRepository.get().getAvailableSchemaURIs();
    }

    @Override
    public LimeXMLSchema getSchema(String uri) {
        return this.limeXMLSchemaRepository.get().getSchema(uri);
    }
}

