/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.PushManager;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.vendor.SimppVM;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentHelper;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.FixedsizeForgetfulHashMap;
import org.limewire.io.NetworkUtils;
import org.limewire.security.SecureMessage;
import org.limewire.security.SecureMessageCallback;
import org.limewire.security.SecureMessageVerifier;
import org.limewire.service.ErrorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class ForMeReplyHandler
implements ReplyHandler,
SecureMessageCallback {
    private static final Log LOG = LogFactory.getLog(ForMeReplyHandler.class);
    private final Map<String, AtomicInteger> PUSH_REQUESTS = Collections.synchronizedMap(new FixedsizeForgetfulHashMap(200));
    private final Map<GUID, GUID> GUID_REQUESTS = Collections.synchronizedMap(new FixedsizeForgetfulHashMap(200));
    private final NetworkManager networkManager;
    private final SecureMessageVerifier secureMessageVerifier;
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<SearchResultHandler> searchResultHandler;
    private final Provider<DownloadManager> downloadManager;
    private final Provider<PushManager> pushManager;
    private final ScheduledExecutorService backgroundExecutor;
    private final ApplicationServices applicationServices;
    private final ConnectionServices connectionServices;
    private final LimeXMLDocumentHelper limeXMLDocumentHelper;
    private final Provider<IPFilter> ipFilterProvider;

    @Inject
    ForMeReplyHandler(NetworkManager networkManager, SecureMessageVerifier secureMessageVerifier, Provider<ConnectionManager> connectionManager, Provider<SearchResultHandler> searchResultHandler, Provider<DownloadManager> downloadManager, Provider<Acceptor> acceptor, Provider<PushManager> pushManager, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, ApplicationServices applicationServices, ConnectionServices connectionServices, LimeXMLDocumentHelper limeXMLDocumentHelper, Provider<IPFilter> ipFilterProvider) {
        this.networkManager = networkManager;
        this.secureMessageVerifier = secureMessageVerifier;
        this.connectionManager = connectionManager;
        this.searchResultHandler = searchResultHandler;
        this.downloadManager = downloadManager;
        this.pushManager = pushManager;
        this.backgroundExecutor = backgroundExecutor;
        this.applicationServices = applicationServices;
        this.connectionServices = connectionServices;
        this.limeXMLDocumentHelper = limeXMLDocumentHelper;
        this.ipFilterProvider = ipFilterProvider;
        this.backgroundExecutor.scheduleWithFixedDelay(new Runnable(){

            public void run() {
                ForMeReplyHandler.this.PUSH_REQUESTS.clear();
            }
        }, 30000L, 30000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void handlePingReply(PingReply pingReply, ReplyHandler handler) {
        if (pingReply.getHops() <= 1 && handler.getNumMessagesReceived() <= 2 && !handler.isOutgoing() && handler.isKillable() && pingReply.getFiles() < (long)SharingSettings.FREELOADER_FILES.getValue() && (int)(Math.random() * 100.0) > SharingSettings.FREELOADER_ALLOWED.getValue() && handler instanceof RoutedConnection && handler.isStable()) {
            this.connectionManager.get().remove((RoutedConnection)handler);
        }
    }

    @Override
    public void handleQueryReply(QueryReply reply, ReplyHandler handler) {
        boolean validResponses;
        if (reply.isFakeMulticast()) {
            return;
        }
        if (reply.isReplyToMulticastQuery()) {
            if (reply.isTCP()) {
                return;
            }
            if (reply.getHops() != 1 || reply.getTTL() != 0) {
                return;
            }
        }
        if (!(validResponses = ForMeReplyHandler.addXMLToResponses(reply, this.limeXMLDocumentHelper))) {
            return;
        }
        if (handler != null && handler.isPersonalSpam(reply)) {
            return;
        }
        if (reply.hasSecureData() && ApplicationSettings.USE_SECURE_RESULTS.getValue()) {
            this.secureMessageVerifier.verify(reply, this);
        } else {
            this.routeQueryReplyInternal(reply);
        }
    }

    @Override
    public void handleSecureMessage(SecureMessage sm, boolean passed) {
        if (passed) {
            this.routeQueryReplyInternal((QueryReply)sm);
        }
    }

    private void routeQueryReplyInternal(QueryReply reply) {
        if (!this.scanReply(reply)) {
            this.searchResultHandler.get().handleQueryReply(reply);
            this.downloadManager.get().handleQueryReply(reply);
        }
    }

    public static boolean addXMLToResponses(QueryReply qr, LimeXMLDocumentHelper limeXMLDocumentHelper) {
        int responsesLength;
        Response[] responses;
        String xmlCollectionString = "";
        try {
            LOG.trace("Trying to do uncompress XML.....");
            byte[] xmlCompressed = qr.getXMLBytes();
            if (xmlCompressed.length > 1) {
                byte[] xmlUncompressed = LimeXMLUtils.uncompress(xmlCompressed);
                xmlCollectionString = new String(xmlUncompressed, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException use) {
            ErrorService.error(use);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        if (xmlCollectionString.equals("")) {
            return true;
        }
        try {
            responses = qr.getResultsArray();
            responsesLength = responses.length;
        }
        catch (BadPacketException bpe) {
            LOG.trace("Unable to get responses", bpe);
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("xmlCollectionString = " + xmlCollectionString);
        }
        List<LimeXMLDocument[]> allDocsArray = limeXMLDocumentHelper.getDocuments(xmlCollectionString, responsesLength);
        block5: for (int i = 0; i < responsesLength; ++i) {
            Response response = responses[i];
            for (int schema = 0; schema < allDocsArray.size(); ++schema) {
                LimeXMLDocument[] metaDocs = allDocsArray.get(schema);
                if (metaDocs == null || metaDocs[i] == null) continue;
                response.setDocument(metaDocs[i]);
                continue block5;
            }
        }
        return true;
    }

    @Override
    public void handlePushRequest(PushRequest pushRequest, ReplyHandler handler) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("push: " + pushRequest + "\nfrom: " + handler);
        }
        if (handler.isPersonalSpam(pushRequest)) {
            LOG.debug("discarded as personal spam");
            return;
        }
        byte[] ip = pushRequest.getIP();
        String h = NetworkUtils.ip2string(ip);
        GUID guid = new GUID(pushRequest.getGUID());
        if (this.GUID_REQUESTS.put(guid, guid) != null) {
            LOG.debug("already serviced");
            return;
        }
        AtomicInteger i = this.PUSH_REQUESTS.get(h);
        if (i == null) {
            i = new AtomicInteger(1);
            this.PUSH_REQUESTS.put(h, i);
        } else {
            i.addAndGet(1);
            if (i.get() > UploadSettings.MAX_PUSHES_PER_HOST.getValue()) {
                LOG.debug("over max pushes per host");
                return;
            }
        }
        if (!this.ipFilterProvider.get().allow(ip)) {
            LOG.debug("blocked by ip filter");
            return;
        }
        int port = pushRequest.getPort();
        if (!NetworkUtils.isValidPort(port)) {
            LOG.debug("invalid port");
            return;
        }
        String req_guid_hexstring = new GUID(pushRequest.getClientGUID()).toString();
        this.pushManager.get().acceptPushUpload(h, port, req_guid_hexstring, pushRequest.isMulticast(), pushRequest.isFirewallTransferPush(), pushRequest.isTLSCapable());
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public int getNumMessagesReceived() {
        return 0;
    }

    @Override
    public void countDroppedMessage() {
    }

    @Override
    public boolean isSupernodeClientConnection() {
        return false;
    }

    @Override
    public boolean isPersonalSpam(Message m) {
        return false;
    }

    public void updateHorizonStats(PingReply pingReply) {
    }

    @Override
    public boolean isOutgoing() {
        return false;
    }

    @Override
    public boolean isKillable() {
        return false;
    }

    @Override
    public boolean isLeafConnection() {
        return !this.connectionServices.isSupernode();
    }

    @Override
    public boolean isHighDegreeConnection() {
        return false;
    }

    @Override
    public boolean isUltrapeerQueryRoutingConnection() {
        return false;
    }

    @Override
    public boolean isGoodUltrapeer() {
        return false;
    }

    @Override
    public boolean isGoodLeaf() {
        return false;
    }

    @Override
    public boolean supportsPongCaching() {
        return true;
    }

    @Override
    public boolean allowNewPings() {
        return true;
    }

    @Override
    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(NetworkUtils.ip2string(this.networkManager.getAddress()));
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    @Override
    public int getPort() {
        return this.networkManager.getPort();
    }

    @Override
    public String getAddress() {
        return NetworkUtils.ip2string(this.networkManager.getAddress());
    }

    @Override
    public void handleSimppVM(SimppVM simppVM) {
        throw new IllegalStateException("ForMeReplyHandler asked to send vendor message");
    }

    @Override
    public boolean isStable() {
        return true;
    }

    @Override
    public String getLocalePref() {
        return ApplicationSettings.LANGUAGE.getValue();
    }

    @Override
    public void reply(Message m) {
    }

    @Override
    public byte[] getClientGUID() {
        return this.applicationServices.getMyGUID();
    }

    private boolean scanReply(QueryReply reply) {
        if (reply.getSecureStatus() == 2) {
            return false;
        }
        try {
            for (Response r : reply.getResultsAsList()) {
                String n = r.getName().toLowerCase(Locale.US);
                if (n.indexOf("ifreeclub") == -1 && n.indexOf("peermatrix") == -1 && (n.indexOf("limewire") == -1 || n.indexOf("urgent") == -1 && n.indexOf("important") == -1 && n.indexOf("update") == -1 && n.indexOf("upgrade") == -1)) continue;
                return true;
            }
        }
        catch (BadPacketException drop) {
            return true;
        }
        return false;
    }
}

