/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.HTTPAcceptor;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RequestCache;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.http.HttpContextParams;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.statistics.TcpBandwidthStatistics;
import com.limegroup.gnutella.uploader.FileRequestHandler;
import com.limegroup.gnutella.uploader.HTTPUploadSession;
import com.limegroup.gnutella.uploader.HTTPUploadSessionManager;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.HttpPushRequestHandler;
import com.limegroup.gnutella.uploader.HttpRequestHandlerFactory;
import com.limegroup.gnutella.uploader.UploadSlotManager;
import com.limegroup.gnutella.uploader.UploadType;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.limewire.collection.Buffer;
import org.limewire.collection.FixedsizeForgetfulHashMap;
import org.limewire.http.HttpAcceptorListener;
import org.limewire.util.FileLocker;
import org.limewire.util.FileUtils;
import org.limewire.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class HTTPUploadManager
implements FileLocker,
BandwidthTracker,
UploadManager,
HTTPUploadSessionManager {
    private static final String SESSION_KEY = "org.limewire.session";
    private static final Log LOG = LogFactory.getLog(HTTPUploadManager.class);
    private List<HTTPUploader> activeUploadList = new LinkedList<HTTPUploader>();
    private final UploadSlotManager slotManager;
    private volatile boolean hadSuccesfulUpload = false;
    private int forcedUploads;
    private final HttpRequestHandler freeLoaderRequestHandler;
    private final ResponseListener responseListener = new ResponseListener();
    private final Set<HTTPUploader> localUploads = new CopyOnWriteArraySet<HTTPUploader>();
    private static final int MAX_SPEED_SAMPLE_SIZE = 5;
    private static final int MIN_SPEED_SAMPLE_SIZE = 5;
    private static final int MIN_SAMPLE_BYTES = 200000;
    public static final int TRANSFER_SOCKET_TIMEOUT = 120000;
    private Buffer<Integer> speeds = new Buffer(5);
    private volatile int highestSpeed = -1;
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private volatile float lastMeasuredBandwidth;
    private final Map<String, RequestCache> REQUESTS = new FixedsizeForgetfulHashMap<String, RequestCache>(250);
    private volatile Provider<ActivityCallback> activityCallback;
    private volatile Provider<FileManager> fileManager;
    private volatile boolean started;
    private final HttpRequestHandlerFactory httpRequestHandlerFactory;
    private final Provider<ContentManager> contentManager;
    private final Provider<HTTPAcceptor> httpAcceptor;
    private final TcpBandwidthStatistics tcpBandwidthStatistics;

    @Inject
    public HTTPUploadManager(UploadSlotManager slotManager, HttpRequestHandlerFactory httpRequestHandlerFactory, Provider<ContentManager> contentManager, Provider<HTTPAcceptor> httpAcceptor, Provider<FileManager> fileManager, Provider<ActivityCallback> activityCallback, TcpBandwidthStatistics tcpBandwidthStatistics) {
        this.slotManager = Objects.nonNull(slotManager, "slotManager");
        this.httpRequestHandlerFactory = httpRequestHandlerFactory;
        this.contentManager = contentManager;
        this.freeLoaderRequestHandler = httpRequestHandlerFactory.createFreeLoaderRequestHandler();
        this.httpAcceptor = Objects.nonNull(httpAcceptor, "httpAcceptor");
        this.fileManager = Objects.nonNull(fileManager, "fileManager");
        this.activityCallback = Objects.nonNull(activityCallback, "activityCallback");
        this.tcpBandwidthStatistics = Objects.nonNull(tcpBandwidthStatistics, "tcpBandwidthStatistics");
    }

    @Override
    public void start() {
        if (this.started) {
            throw new IllegalStateException();
        }
        FileUtils.addFileLocker(this);
        this.httpAcceptor.get().addAcceptorListener(this.responseListener);
        this.httpAcceptor.get().registerHandler("/", this.httpRequestHandlerFactory.createBrowseRequestHandler());
        HttpPushRequestHandler pushProxyHandler = this.httpRequestHandlerFactory.createPushProxyRequestHandler();
        this.httpAcceptor.get().registerHandler("/gnutella/push-proxy", pushProxyHandler);
        this.httpAcceptor.get().registerHandler("/gnet/push-proxy", pushProxyHandler);
        FileRequestHandler fileRequestHandler = this.httpRequestHandlerFactory.createFileRequestHandler();
        this.httpAcceptor.get().registerHandler("/get*", fileRequestHandler);
        this.httpAcceptor.get().registerHandler("/uri-res/*", fileRequestHandler);
        this.started = true;
    }

    @Override
    public void stop() {
        if (!this.started) {
            throw new IllegalStateException();
        }
        this.httpAcceptor.get().unregisterHandler("/");
        this.httpAcceptor.get().unregisterHandler("/update.xml");
        this.httpAcceptor.get().unregisterHandler("/gnutella/push-proxy");
        this.httpAcceptor.get().unregisterHandler("/gnet/push-proxy");
        this.httpAcceptor.get().unregisterHandler("/get*");
        this.httpAcceptor.get().unregisterHandler("/uri-res/*");
        this.httpAcceptor.get().removeAcceptorListener(this.responseListener);
        FileUtils.removeFileLocker(this);
        this.started = false;
    }

    @Override
    public void handleFreeLoader(HttpRequest request, HttpResponse response, HttpContext context, HTTPUploader uploader) throws HttpException, IOException {
        assert (this.started);
        uploader.setState(Uploader.UploadStatus.FREELOADER);
        this.freeLoaderRequestHandler.handle(request, response, context);
    }

    private boolean shouldBypassQueue(HttpRequest request, HTTPUploader uploader) {
        assert (uploader.getState() == Uploader.UploadStatus.CONNECTING);
        return "HEAD".equals(request.getRequestLine().getMethod()) || uploader.isForcedShare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupFinishedUploader(HTTPUploader uploader) {
        FileDesc fd;
        assert (this.started);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Cleaning uploader " + uploader);
        }
        Uploader.UploadStatus state = uploader.getState();
        Uploader.UploadStatus lastState = uploader.getLastTransferState();
        long finishTime = System.currentTimeMillis();
        HTTPUploadManager hTTPUploadManager = this;
        synchronized (hTTPUploadManager) {
            if (uploader.getStartTime() > 0L) {
                this.reportUploadSpeed(finishTime - uploader.getStartTime(), uploader.getTotalAmountUploaded());
            }
            this.removeFromList(uploader);
            this.localUploads.remove(uploader);
        }
        if (!(uploader.getUploadType() == null || uploader.getUploadType().isInternal() || (fd = uploader.getFileDesc()) == null || state != Uploader.UploadStatus.COMPLETE || lastState != Uploader.UploadStatus.UPLOADING && lastState != Uploader.UploadStatus.THEX_REQUEST)) {
            fd.incrementCompletedUploads();
            this.activityCallback.get().handleSharedFileUpdate(fd.getFile());
        }
        this.activityCallback.get().removeUpload(uploader);
    }

    @Override
    public synchronized void addAcceptedUploader(HTTPUploader uploader, HttpContext context) {
        assert (this.started);
        if (uploader.isForcedShare()) {
            ++this.forcedUploads;
        } else if (HttpContextParams.isLocal(context)) {
            this.localUploads.add(uploader);
        }
        this.activeUploadList.add(uploader);
        uploader.setStartTime(System.currentTimeMillis());
    }

    @Override
    public void sendResponse(HTTPUploader uploader, HttpResponse response) {
        FileDesc fd;
        assert (this.started);
        uploader.setLastResponse(response);
        if (uploader.isVisible()) {
            return;
        }
        this.activityCallback.get().addUpload(uploader);
        uploader.setVisible(true);
        if (!uploader.getUploadType().isInternal() && (fd = uploader.getFileDesc()) != null) {
            fd.incrementAttemptedUploads();
            this.activityCallback.get().handleSharedFileUpdate(fd.getFile());
        }
    }

    @Override
    public synchronized boolean isServiceable() {
        if (!this.started) {
            return false;
        }
        return this.slotManager.hasHTTPSlot(this.uploadsInProgress() + this.getNumQueuedUploads());
    }

    @Override
    public synchronized boolean mayBeServiceable() {
        if (!this.started) {
            return false;
        }
        if (this.fileManager.get().hasApplicationSharedFiles()) {
            return this.slotManager.hasHTTPSlotForMeta(this.uploadsInProgress() + this.getNumQueuedUploads());
        }
        return this.isServiceable();
    }

    @Override
    public synchronized int uploadsInProgress() {
        return this.activeUploadList.size() - this.forcedUploads;
    }

    @Override
    public synchronized int getNumQueuedUploads() {
        return this.slotManager.getNumQueued();
    }

    @Override
    public boolean hadSuccesfulUpload() {
        return this.hadSuccesfulUpload;
    }

    @Override
    public synchronized boolean isConnectedTo(InetAddress addr) {
        if (this.slotManager.getNumUsersForHost(addr.getHostAddress()) > 0) {
            return true;
        }
        for (HTTPUploader uploader : this.activeUploadList) {
            InetAddress host = uploader.getConnectedHost();
            if (host == null || !host.equals(addr)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean releaseLock(File file) {
        assert (this.started);
        FileDesc fd = this.fileManager.get().getFileDescForFile(file);
        if (fd != null) {
            return this.killUploadsForFileDesc(fd);
        }
        return false;
    }

    @Override
    public synchronized boolean killUploadsForFileDesc(FileDesc fd) {
        boolean ret = false;
        for (HTTPUploader uploader : this.activeUploadList) {
            FileDesc upFD = uploader.getFileDesc();
            if (upFD == null || !upFD.equals(fd)) continue;
            ret = true;
            uploader.stop();
        }
        return ret;
    }

    private synchronized HTTPUploadSessionManager.QueueStatus checkAndQueue(HTTPUploadSession session) {
        URN sha1;
        RequestCache rqc = this.REQUESTS.get(session.getHost());
        if (rqc == null) {
            rqc = new RequestCache();
        }
        this.REQUESTS.put(session.getHost(), rqc);
        rqc.countRequest();
        if (rqc.isHammering()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(session.getUploader() + " banned.");
            }
            return HTTPUploadSessionManager.QueueStatus.BANNED;
        }
        FileDesc fd = session.getUploader().getFileDesc();
        if (!this.contentManager.get().isVerified(fd.getSHA1Urn())) {
            this.fileManager.get().validate(fd);
        }
        if (rqc.isDupe(sha1 = fd.getSHA1Urn())) {
            return HTTPUploadSessionManager.QueueStatus.REJECTED;
        }
        if (this.slotManager.positionInQueue(session) == -1 && this.hostLimitReached(session.getHost())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("host limit reached for " + session.getHost());
            }
            return HTTPUploadSessionManager.QueueStatus.REJECTED;
        }
        int queued = this.slotManager.pollForSlot(session, session.getUploader().supportsQueueing(), session.getUploader().isPriorityShare());
        if (LOG.isDebugEnabled()) {
            LOG.debug("queued at " + queued);
        }
        if (queued == -1) {
            return HTTPUploadSessionManager.QueueStatus.REJECTED;
        }
        if (queued > 0 && session.poll()) {
            this.slotManager.cancelRequest(session);
            return HTTPUploadSessionManager.QueueStatus.BANNED;
        }
        if (queued > 0) {
            return HTTPUploadSessionManager.QueueStatus.QUEUED;
        }
        rqc.startedTransfer(sha1);
        return HTTPUploadSessionManager.QueueStatus.ACCEPTED;
    }

    private synchronized void removeFromList(HTTPUploader uploader) {
        if (this.activeUploadList.remove(uploader)) {
            RequestCache rcq;
            if (uploader.isForcedShare()) {
                --this.forcedUploads;
            }
            if ((rcq = this.REQUESTS.get(uploader.getHost())) != null && uploader.getFileDesc() != null) {
                rcq.transferDone(uploader.getFileDesc().getSHA1Urn());
            }
        }
        if (this.activeUploadList.size() == 0) {
            this.activityCallback.get().uploadsComplete();
        }
    }

    private synchronized boolean hostLimitReached(String host) {
        return this.slotManager.getNumUsersForHost(host) >= UploadSettings.UPLOADS_PER_PERSON.getValue();
    }

    public int calculateBandwidth() {
        float totalBandwith = this.getTotalBandwith();
        float burstSize = totalBandwith / (float)this.uploadsInProgress();
        return (int)burstSize;
    }

    private float getTotalBandwith() {
        float connectionSpeed = (float)ConnectionSettings.CONNECTION_SPEED.getValue() / 8.0f;
        float speed = UploadSettings.UPLOAD_SPEED.getValue();
        float totalBandwith = connectionSpeed * speed / 100.0f;
        return totalBandwith;
    }

    @Override
    public int measuredUploadSpeed() {
        return this.highestSpeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportUploadSpeed(long milliseconds, long bytes) {
        if (bytes < 200000L) {
            return;
        }
        int bandwidth = 8 * (int)((float)bytes / (float)milliseconds);
        Buffer<Integer> buffer = this.speeds;
        synchronized (buffer) {
            this.speeds.add(bandwidth);
            if (this.speeds.size() >= 5) {
                int max = 0;
                for (int i = 0; i < this.speeds.size(); ++i) {
                    max = Math.max(max, this.speeds.get(i));
                }
                this.highestSpeed = max;
            }
        }
    }

    @Override
    public void measureBandwidth() {
        this.slotManager.measureBandwidth();
        for (HTTPUploader active : this.localUploads) {
            active.measureBandwidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getMeasuredBandwidth() {
        float bw = 0.0f;
        try {
            bw += this.slotManager.getMeasuredBandwidth();
        }
        catch (InsufficientDataException notEnough) {
            // empty catch block
        }
        for (HTTPUploader forced : this.localUploads) {
            try {
                bw += forced.getMeasuredBandwidth();
            }
            catch (InsufficientDataException e) {}
        }
        HTTPUploadManager hTTPUploadManager = this;
        synchronized (hTTPUploadManager) {
            this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + bw) / (float)(++this.numMeasures);
        }
        this.lastMeasuredBandwidth = bw;
        return bw;
    }

    @Override
    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    @Override
    public float getLastMeasuredBandwidth() {
        return this.lastMeasuredBandwidth;
    }

    public UploadSlotManager getSlotManager() {
        return this.slotManager;
    }

    public HTTPUploadSession getOrCreateSession(HttpContext context) {
        assert (this.started);
        HTTPUploadSession session = (HTTPUploadSession)context.getAttribute(SESSION_KEY);
        if (session == null) {
            InetAddress host;
            HttpInetConnection conn = (HttpInetConnection)context.getAttribute("http.connection");
            if (conn != null) {
                host = conn.getRemoteAddress();
            } else {
                try {
                    host = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException(e);
                }
            }
            session = new HTTPUploadSession(this.getSlotManager(), host, HttpContextParams.getIOSession(context));
            context.setAttribute(SESSION_KEY, session);
        }
        return session;
    }

    public HTTPUploadSession getSession(HttpContext context) {
        assert (this.started);
        HTTPUploadSession session = (HTTPUploadSession)context.getAttribute(SESSION_KEY);
        return session;
    }

    @Override
    public HTTPUploader getOrCreateUploader(HttpRequest request, HttpContext context, UploadType type, String filename) {
        assert (this.started);
        HTTPUploadSession session = this.getOrCreateSession(context);
        HTTPUploader uploader = session.getUploader();
        if (uploader != null) {
            if (!uploader.getFileName().equals(filename) || !uploader.getMethod().equals(request.getRequestLine().getMethod())) {
                this.slotManager.requestDone(session);
                if (session.isQueued()) {
                    uploader.setState(Uploader.UploadStatus.INTERRUPTED);
                } else {
                    this.slotManager.requestDone(session);
                }
                this.cleanupFinishedUploader(uploader);
                uploader = new HTTPUploader(filename, session, this.tcpBandwidthStatistics);
            } else {
                uploader.reinitialize();
            }
        } else {
            uploader = new HTTPUploader(filename, session);
        }
        String method = request.getRequestLine().getMethod();
        uploader.setMethod(method);
        uploader.setUploadType("HEAD".equals(method) ? UploadType.HEAD_REQUEST : type);
        session.setUploader(uploader);
        return uploader;
    }

    public HTTPUploader getUploader(HttpContext context) {
        assert (this.started);
        HTTPUploadSession session = this.getSession(context);
        HTTPUploader uploader = session.getUploader();
        assert (uploader != null);
        return uploader;
    }

    @Override
    public HTTPUploadSessionManager.QueueStatus enqueue(HttpContext context, HttpRequest request) {
        assert (this.started);
        HTTPUploadSession session = this.getSession(context);
        assert (!session.isAccepted());
        if (this.shouldBypassQueue(request, session.getUploader())) {
            session.setQueueStatus(HTTPUploadSessionManager.QueueStatus.BYPASS);
        } else if (HttpContextParams.isLocal(context)) {
            session.setQueueStatus(HTTPUploadSessionManager.QueueStatus.ACCEPTED);
        } else {
            session.setQueueStatus(this.checkAndQueue(session));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queued upload: " + session);
        }
        return session.getQueueStatus();
    }

    public void cleanup() {
        assert (this.started);
        for (HTTPUploader uploader : this.activeUploadList.toArray(new HTTPUploader[0])) {
            uploader.stop();
            this.slotManager.cancelRequest(uploader.getSession());
            this.removeFromList(uploader);
        }
        this.slotManager.cleanup();
        this.REQUESTS.clear();
    }

    private class ResponseListener
    implements HttpAcceptorListener {
        private ResponseListener() {
        }

        public void connectionOpen(NHttpConnection conn) {
        }

        public void connectionClosed(NHttpConnection conn) {
            HTTPUploader uploader;
            assert (HTTPUploadManager.this.started);
            HTTPUploadSession session = HTTPUploadManager.this.getSession(conn.getContext());
            if (session != null && (uploader = session.getUploader()) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Closing session for " + session.getHost());
                }
                boolean stillInQueue = HTTPUploadManager.this.slotManager.positionInQueue(session) > -1;
                HTTPUploadManager.this.slotManager.cancelRequest(session);
                if (stillInQueue) {
                    uploader.setState(Uploader.UploadStatus.INTERRUPTED);
                } else if (uploader.getState() != Uploader.UploadStatus.COMPLETE) {
                    uploader.setState(Uploader.UploadStatus.COMPLETE);
                }
                uploader.setLastResponse(null);
                HTTPUploadManager.this.cleanupFinishedUploader(uploader);
                session.setUploader(null);
            }
        }

        public void responseSent(NHttpConnection conn, HttpResponse response) {
            assert (HTTPUploadManager.this.started);
            HTTPUploadSession session = HTTPUploadManager.this.getSession(conn.getContext());
            if (session != null) {
                HTTPUploader uploader = session.getUploader();
                if (uploader != null && uploader.getLastResponse() == response) {
                    uploader.setLastResponse(null);
                    uploader.setState(Uploader.UploadStatus.COMPLETE);
                }
                if (session.getQueueStatus() == HTTPUploadSessionManager.QueueStatus.QUEUED) {
                    session.getIOSession().setSocketTimeout(120000);
                    conn.requestInput();
                }
            }
        }
    }
}

