/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UniqueHostPinger;
import com.limegroup.gnutella.bootstrap.TcpBootstrap;
import com.limegroup.gnutella.bootstrap.UDPHostCache;
import com.limegroup.gnutella.bootstrap.UDPHostCacheFactory;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.ClassCNetworks;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.BucketQueue;
import org.limewire.collection.Cancellable;
import org.limewire.collection.FixedSizeSortedList;
import org.limewire.collection.IntSet;
import org.limewire.collection.ListPartitioner;
import org.limewire.collection.RandomAccessMap;
import org.limewire.collection.RandomOrderHashMap;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.Connectable;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.util.CommonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class HostCatcher {
    private static final Log LOG = LogFactory.getLog(HostCatcher.class);
    static final int GOOD_SIZE = 1000;
    static final int NORMAL_SIZE = 400;
    static final int PERMANENT_SIZE = 400;
    public static final int GOOD_PRIORITY = 1;
    public static final int NORMAL_PRIORITY = 0;
    public static final int PONG_MASK = -256;
    private static final Comparator<ExtendedEndpoint> DHT_COMPARATOR = new Comparator<ExtendedEndpoint>(){

        @Override
        public int compare(ExtendedEndpoint e1, ExtendedEndpoint e2) {
            DHTManager.DHTMode mode1 = e1.getDHTMode();
            DHTManager.DHTMode mode2 = e2.getDHTMode();
            if (mode1.equals((Object)DHTManager.DHTMode.ACTIVE) && !mode2.equals((Object)DHTManager.DHTMode.ACTIVE) || mode1.equals((Object)DHTManager.DHTMode.PASSIVE) && mode2.equals((Object)DHTManager.DHTMode.INACTIVE)) {
                return -1;
            }
            if (mode2.equals((Object)DHTManager.DHTMode.ACTIVE) && !mode1.equals((Object)DHTManager.DHTMode.ACTIVE) || mode2.equals((Object)DHTManager.DHTMode.PASSIVE) && mode1.equals((Object)DHTManager.DHTMode.INACTIVE)) {
                return 1;
            }
            return 0;
        }
    };
    private final BucketQueue<ExtendedEndpoint> ENDPOINT_QUEUE = new BucketQueue(new int[]{400, 1000});
    private final Map<ExtendedEndpoint, ExtendedEndpoint> ENDPOINT_SET = new HashMap<ExtendedEndpoint, ExtendedEndpoint>();
    private final RandomAccessMap<ExtendedEndpoint, ExtendedEndpoint> FREE_ULTRAPEER_SLOTS_SET = new RandomOrderHashMap<ExtendedEndpoint, ExtendedEndpoint>(200);
    private final RandomAccessMap<ExtendedEndpoint, ExtendedEndpoint> FREE_LEAF_SLOTS_SET = new RandomOrderHashMap<ExtendedEndpoint, ExtendedEndpoint>(200);
    private final Map<String, Set<ExtendedEndpoint>> LOCALE_SET_MAP = new HashMap<String, Set<ExtendedEndpoint>>();
    private static final int LOCALE_SET_SIZE = 100;
    private final FixedSizeSortedList<ExtendedEndpoint> permanentHosts = new FixedSizeSortedList<ExtendedEndpoint>(ExtendedEndpoint.priorityComparator(), 400);
    private final Set<ExtendedEndpoint> permanentHostsSet = new HashSet<ExtendedEndpoint>();
    private final List<ExtendedEndpoint> restoredHosts = new FixedSizeSortedList<ExtendedEndpoint>(ExtendedEndpoint.priorityComparator(), 400);
    private final ListPartitioner<ExtendedEndpoint> uptimePartitions = new ListPartitioner<ExtendedEndpoint>(this.restoredHosts, 3);
    private UDPHostCache udpHostCache;
    private int _failures;
    private final Set<Endpoint> EXPIRED_HOSTS = new HashSet<Endpoint>();
    private final Set<Endpoint> PROBATION_HOSTS = new HashSet<Endpoint>();
    private static long PROBATION_RECOVERY_WAIT_TIME = 60000L;
    private static long PROBATION_RECOVERY_TIME = 60000L;
    public static final int PROBATION_HOSTS_SIZE = 500;
    public static final int EXPIRED_HOSTS_SIZE = 500;
    public final Bootstrapper FETCHER = new Bootstrapper();
    private List<EndpointObserver> _catchersWaiting = new LinkedList<EndpointObserver>();
    private long lastAllowedPongRankTime = 0L;
    private final long PONG_RANKING_EXPIRE_TIME = 20000L;
    private static final int MAX_CONNECTIONS = 5;
    private final Random RND = new Random();
    private boolean dirty = false;
    private final ScheduledExecutorService backgroundExecutor;
    private final ConnectionServices connectionServices;
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<UDPService> udpService;
    private final Provider<DHTManager> dhtManager;
    private final Provider<QueryUnicaster> queryUnicaster;
    private final Provider<IPFilter> ipFilter;
    private final Provider<MulticastService> multicastService;
    private final UniqueHostPinger uniqueHostPinger;
    private final NetworkInstanceUtils networkInstanceUtils;
    private final PingRequestFactory pingRequestFactory;
    private final TcpBootstrap tcpBootstrap;
    static boolean DEBUG = false;

    @Inject
    public HostCatcher(@Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, ConnectionServices connectionServices, Provider<ConnectionManager> connectionManager, Provider<UDPService> udpService, Provider<DHTManager> dhtManager, Provider<QueryUnicaster> queryUnicaster, @Named(value="hostileFilter") Provider<IPFilter> ipFilter, Provider<MulticastService> multicastService, UniqueHostPinger uniqueHostPinger, UDPHostCacheFactory udpHostCacheFactory, PingRequestFactory pingRequestFactory, NetworkInstanceUtils networkInstanceUtils, TcpBootstrap tcpBootstrap) {
        this.backgroundExecutor = backgroundExecutor;
        this.connectionServices = connectionServices;
        this.connectionManager = connectionManager;
        this.udpService = udpService;
        this.dhtManager = dhtManager;
        this.queryUnicaster = queryUnicaster;
        this.ipFilter = ipFilter;
        this.multicastService = multicastService;
        this.uniqueHostPinger = uniqueHostPinger;
        this.pingRequestFactory = pingRequestFactory;
        this.networkInstanceUtils = networkInstanceUtils;
        this.tcpBootstrap = tcpBootstrap;
        this.udpHostCache = udpHostCacheFactory.createUDPHostCache(uniqueHostPinger);
    }

    UDPHostCache getUdpHostCache() {
        return this.udpHostCache;
    }

    public void initialize() {
        LOG.trace("START scheduling");
        this.scheduleServices();
    }

    protected void scheduleServices() {
        Runnable probationRestorer = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ArrayList toAdd;
                LOG.trace("restoring hosts on probation");
                HostCatcher hostCatcher = HostCatcher.this;
                synchronized (hostCatcher) {
                    toAdd = new ArrayList(HostCatcher.this.PROBATION_HOSTS);
                    HostCatcher.this.PROBATION_HOSTS.clear();
                }
                for (Endpoint e : toAdd) {
                    HostCatcher.this.add(e, false);
                }
            }
        };
        this.backgroundExecutor.scheduleWithFixedDelay(probationRestorer, PROBATION_RECOVERY_WAIT_TIME, PROBATION_RECOVERY_TIME, TimeUnit.MILLISECONDS);
        this.backgroundExecutor.scheduleWithFixedDelay(this.FETCHER, 0L, 2000L, TimeUnit.MILLISECONDS);
        LOG.trace("STOP scheduling");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUDPPings() {
        ArrayList<ExtendedEndpoint> l;
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            l = new ArrayList<ExtendedEndpoint>(this.ENDPOINT_SET.size() + this.restoredHosts.size());
            l.addAll(this.ENDPOINT_SET.keySet());
            l.addAll(this.restoredHosts);
        }
        Collections.shuffle(l);
        this.rank(l);
    }

    private void rank(Collection<? extends IpPort> hosts) {
        if (this.needsPongRanking()) {
            this.uniqueHostPinger.rank(hosts, new Cancellable(){

                public boolean isCancelled() {
                    return !HostCatcher.this.needsPongRanking();
                }
            });
        }
    }

    public void sendMessageToAllHosts(Message m, MessageListener listener, Cancellable c) {
        this.uniqueHostPinger.rank(this.getAllHosts(), listener, c, m);
    }

    private synchronized Collection<ExtendedEndpoint> getAllHosts() {
        LinkedHashSet<ExtendedEndpoint> hosts = new LinkedHashSet<ExtendedEndpoint>(this.getNumHosts());
        hosts.addAll(this.FREE_ULTRAPEER_SLOTS_SET.keySet());
        hosts.addAll(this.FREE_LEAF_SLOTS_SET.keySet());
        hosts.addAll(this.ENDPOINT_SET.keySet());
        hosts.addAll(this.restoredHosts);
        return hosts;
    }

    public synchronized List<ExtendedEndpoint> getDHTSupportEndpoint(int minVersion) {
        ArrayList<ExtendedEndpoint> hostsList = new ArrayList<ExtendedEndpoint>();
        IntSet classC = new IntSet();
        for (ExtendedEndpoint host : this.getAllHosts()) {
            if (!host.supportsDHT() || host.getDHTVersion() < minVersion || ConnectionSettings.FILTER_CLASS_C.getValue() && !classC.add(NetworkUtils.getMaskedIP(host.getInetAddress(), -256))) continue;
            hostsList.add(host);
        }
        Collections.sort(hostsList, DHT_COMPARATOR);
        return hostsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean needsPongRanking() {
        int size;
        HostCatcher hostCatcher;
        if (this.connectionServices.isFullyConnected()) {
            return false;
        }
        int have = this.connectionManager.get().getInitializedConnections().size();
        if (have >= 5) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now > this.lastAllowedPongRankTime) {
            return false;
        }
        if (this.connectionServices.isSupernode()) {
            hostCatcher = this;
            synchronized (hostCatcher) {
                size = this.FREE_ULTRAPEER_SLOTS_SET.size();
            }
        }
        hostCatcher = this;
        synchronized (hostCatcher) {
            size = this.FREE_LEAF_SLOTS_SET.size();
        }
        int preferred = this.connectionManager.get().getPreferredConnectionCount();
        return size < preferred - have;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read(File hostFile) throws FileNotFoundException, IOException {
        LOG.trace("entered HostCatcher.read(File)");
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(hostFile));
            while (true) {
                String line = in.readLine();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("read line: " + line);
                }
                if (line == null) {
                    break;
                }
                try {
                    ExtendedEndpoint e = ExtendedEndpoint.read(line);
                    if (e.isUDPHostCache()) {
                        this.addUDPHostCache(e);
                        continue;
                    }
                    if (!this.isValidHost(e)) continue;
                    HostCatcher hostCatcher = this;
                    synchronized (hostCatcher) {
                        this.addPermanent(e);
                        this.restoredHosts.add(e);
                    }
                    this.endpointAdded();
                }
                catch (ParseException pe) {}
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        LOG.trace("left HostCatcher.read(File)");
    }

    synchronized void write() throws IOException {
        this.write(this.getHostsFile());
    }

    synchronized void write(File hostFile) throws IOException {
        this.repOk();
        if (this.dirty || this.udpHostCache.isWriteDirty()) {
            FileWriter out = new FileWriter(hostFile);
            this.udpHostCache.write(out);
            for (ExtendedEndpoint e : this.permanentHosts) {
                e.write(out);
            }
            out.close();
        }
    }

    public boolean add(PingReply pr) {
        ExtendedEndpoint ep;
        GUID g;
        if (pr.isUDP() && !(g = new GUID(pr.getGUID())).equals(PingRequest.UDP_GUID) && !g.equals(this.udpService.get().getSolicitedGUID())) {
            return false;
        }
        ExtendedEndpoint endpoint = pr.getDailyUptime() != -1 ? new ExtendedEndpoint(pr.getAddress(), pr.getPort(), pr.getDailyUptime()) : new ExtendedEndpoint(pr.getAddress(), pr.getPort());
        if (!pr.getClientLocale().equals("")) {
            endpoint.setClientLocale(pr.getClientLocale());
        }
        if (pr.isUDPHostCache()) {
            endpoint.setHostname(pr.getUDPCacheAddress());
            endpoint.setUDPHostCache(true);
        }
        if (!this.isValidHost(endpoint)) {
            return false;
        }
        int dhtVersion = pr.getDHTVersion();
        if (dhtVersion > -1) {
            DHTManager.DHTMode mode = pr.getDHTMode();
            endpoint.setDHTVersion(dhtVersion);
            endpoint.setDHTMode(mode);
            if (this.dhtManager.get().isRunning()) {
                InetSocketAddress address;
                if (mode.equals((Object)DHTManager.DHTMode.ACTIVE)) {
                    address = new InetSocketAddress(endpoint.getAddress(), endpoint.getPort());
                    this.dhtManager.get().addActiveDHTNode(address);
                } else if (mode.equals((Object)DHTManager.DHTMode.PASSIVE)) {
                    address = new InetSocketAddress(endpoint.getAddress(), endpoint.getPort());
                    this.dhtManager.get().addPassiveDHTNode(address);
                }
            }
        }
        if (pr.supportsUnicast()) {
            this.queryUnicaster.get().addUnicastEndpoint(pr.getInetAddress(), pr.getPort());
        }
        Collection<IpPort> packed = ConnectionSettings.FILTER_CLASS_C.getValue() ? NetworkUtils.filterOnePerClassC(pr.getPackedIPPorts()) : pr.getPackedIPPorts();
        this.rank(packed);
        for (IpPort ipp : packed) {
            if (ipp instanceof ExtendedEndpoint) {
                ep = (ExtendedEndpoint)ipp;
            } else {
                ep = new ExtendedEndpoint(ipp.getAddress(), ipp.getPort());
                if (ipp instanceof Connectable) {
                    ep.setTLSCapable(((Connectable)ipp).isTLSCapable());
                }
            }
            if (!this.isValidHost(ep)) continue;
            this.add(ep, 1);
        }
        for (IpPort ipp : pr.getPackedUDPHostCaches()) {
            ep = new ExtendedEndpoint(ipp.getAddress(), ipp.getPort());
            ep.setUDPHostCache(true);
            this.addUDPHostCache(ep);
        }
        if (endpoint.isUDPHostCache()) {
            return this.addUDPHostCache(endpoint);
        }
        if (pr.isTLSCapable()) {
            endpoint.setTLSCapable(true);
        }
        if (pr.isUltrapeer()) {
            if (pr.hasFreeLeafSlots()) {
                this.addToFreeSlotSet(endpoint, this.FREE_LEAF_SLOTS_SET);
                if (!pr.hasFreeUltrapeerSlots()) {
                    return true;
                }
            }
            if (pr.hasFreeUltrapeerSlots() || ApplicationSettings.LANGUAGE.getValue().equals(pr.getClientLocale()) && pr.getNumFreeLocaleSlots() > 0) {
                this.addToFreeSlotSet(endpoint, this.FREE_ULTRAPEER_SLOTS_SET);
                return true;
            }
            return this.add(endpoint, 1);
        }
        return this.add(endpoint, 0);
    }

    private boolean addUDPHostCache(ExtendedEndpoint host) {
        return this.udpHostCache.add(host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToFreeSlotSet(ExtendedEndpoint host, Map<? super ExtendedEndpoint, ? super ExtendedEndpoint> hosts) {
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            hosts.put(host, host);
            this.addPermanent(host);
        }
        this.endpointAdded();
    }

    private synchronized void addToLocaleMap(ExtendedEndpoint endpoint) {
        String loc = endpoint.getClientLocale();
        if (this.LOCALE_SET_MAP.containsKey(loc)) {
            Set<ExtendedEndpoint> s = this.LOCALE_SET_MAP.get(loc);
            if (s.add(endpoint) && s.size() > 100) {
                s.remove(s.iterator().next());
            }
        } else {
            HashSet<ExtendedEndpoint> s = new HashSet<ExtendedEndpoint>();
            s.add(endpoint);
            this.LOCALE_SET_MAP.put(loc, s);
        }
    }

    public int add(Collection<? extends Endpoint> endpoints) {
        this.rank(endpoints);
        int added = 0;
        for (Endpoint endpoint : endpoints) {
            if (!this.add(endpoint, true)) continue;
            ++added;
        }
        return added;
    }

    public boolean add(Endpoint e, boolean forceHighPriority) {
        if (!this.isValidHost(e)) {
            return false;
        }
        if (forceHighPriority) {
            return this.add(e, 1);
        }
        return this.add(e, 0);
    }

    public boolean add(Endpoint e, boolean forceHighPriority, String locale) {
        if (!this.isValidHost(e)) {
            return false;
        }
        if (forceHighPriority) {
            return this.add(new ExtendedEndpoint(e.getAddress(), e.getPort(), locale), 1);
        }
        return this.add(new ExtendedEndpoint(e.getAddress(), e.getPort(), locale), 0);
    }

    public boolean add(Endpoint host, int priority) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("adding host " + host);
        }
        if (host instanceof ExtendedEndpoint) {
            return this.add((ExtendedEndpoint)host, priority);
        }
        return this.add(new ExtendedEndpoint(host.getAddress(), host.getPort()), priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean add(ExtendedEndpoint e, int priority) {
        this.repOk();
        if (e.isUDPHostCache()) {
            return this.addUDPHostCache(e);
        }
        boolean ret = false;
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            this.addPermanent(e);
            if (!this.ENDPOINT_SET.containsKey(e)) {
                ret = true;
                this.ENDPOINT_SET.put(e, e);
                ExtendedEndpoint ejected = this.ENDPOINT_QUEUE.insert(e, priority);
                if (ejected != null) {
                    this.ENDPOINT_SET.remove(ejected);
                }
            }
        }
        this.endpointAdded();
        this.repOk();
        return ret;
    }

    private synchronized boolean addPermanent(ExtendedEndpoint e) {
        if (this.networkInstanceUtils.isPrivateAddress(e.getInetAddress())) {
            return false;
        }
        if (this.permanentHostsSet.contains(e)) {
            return false;
        }
        this.addToLocaleMap(e);
        ExtendedEndpoint removed = this.permanentHosts.insert(e);
        if (removed != e) {
            this.permanentHostsSet.add(e);
            if (removed != null) {
                this.permanentHostsSet.remove(removed);
            }
            this.dirty = true;
            return true;
        }
        return false;
    }

    private synchronized boolean removePermanent(ExtendedEndpoint e) {
        boolean removed1 = this.permanentHosts.remove(e);
        boolean removed2 = this.permanentHostsSet.remove(e);
        assert (removed1 == removed2) : "Queue " + removed1 + " but set " + removed2;
        if (removed1) {
            this.dirty = true;
        }
        return removed1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidHost(Endpoint host) {
        byte[] addr;
        if (host.isUDPHostCache()) {
            return true;
        }
        try {
            addr = host.getHostBytes();
        }
        catch (UnknownHostException uhe) {
            return false;
        }
        if (this.networkInstanceUtils.isPrivateAddress(addr)) {
            return false;
        }
        if (this.networkInstanceUtils.isMe(addr, host.getPort())) {
            return false;
        }
        if (!this.ipFilter.get().allow(addr)) {
            return false;
        }
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            if (this.EXPIRED_HOSTS.contains(host)) {
                return false;
            }
            if (this.PROBATION_HOSTS.contains(host)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHostTLSCapable(IpPort ipp) {
        ExtendedEndpoint ee;
        if (ipp instanceof Connectable) {
            return ((Connectable)ipp).isTLSCapable();
        }
        Endpoint p = new Endpoint(ipp.getAddress(), ipp.getPort());
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            ee = this.ENDPOINT_SET.get(p);
            if (ee == null) {
                ee = (ExtendedEndpoint)this.FREE_ULTRAPEER_SLOTS_SET.get(p);
            }
            if (ee == null) {
                ee = (ExtendedEndpoint)this.FREE_LEAF_SLOTS_SET.get(p);
            }
        }
        if (ee == null) {
            return false;
        }
        return ee.isTLSCapable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endpointAdded() {
        EndpointObserver observer;
        ExtendedEndpoint p;
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            if (this._catchersWaiting.isEmpty()) {
                return;
            }
            p = this.getAnEndpointInternal();
            if (p == null) {
                return;
            }
            observer = this._catchersWaiting.remove(0);
        }
        observer.handleEndpoint(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAnEndpoint(EndpointObserver observer) {
        ExtendedEndpoint p;
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            p = this.getAnEndpointInternal();
            if (p == null) {
                this._catchersWaiting.add(observer);
            }
        }
        if (p != null) {
            observer.handleEndpoint(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint getAnEndpointImmediate(EndpointObserver observer) {
        ExtendedEndpoint p;
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            p = this.getAnEndpointInternal();
            if (p == null && observer != null) {
                this._catchersWaiting.add(observer);
            }
        }
        return p;
    }

    public synchronized void removeEndpointObserver(EndpointObserver observer) {
        this._catchersWaiting.remove(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint getAnEndpoint() throws InterruptedException {
        BlockingObserver observer = new BlockingObserver();
        this.getAnEndpoint(observer);
        try {
            BlockingObserver blockingObserver = observer;
            synchronized (blockingObserver) {
                if (observer.getEndpoint() == null) {
                    observer.wait();
                }
                return observer.getEndpoint();
            }
        }
        catch (InterruptedException ie) {
            HostCatcher hostCatcher = this;
            synchronized (hostCatcher) {
                this._catchersWaiting.remove(observer);
                throw ie;
            }
        }
    }

    public synchronized void doneWithConnect(Endpoint e, boolean success) {
        if (!(e instanceof ExtendedEndpoint)) {
            return;
        }
        ExtendedEndpoint ee = (ExtendedEndpoint)e;
        this.removePermanent(ee);
        if (success) {
            ee.recordConnectionSuccess();
        } else {
            ++this._failures;
            ee.recordConnectionFailure();
        }
        this.addPermanent(ee);
    }

    protected ExtendedEndpoint getAnEndpointInternal() {
        if (this.connectionServices.isSupernode() && !this.FREE_ULTRAPEER_SLOTS_SET.isEmpty()) {
            return this.preferenceWithLocale(this.FREE_ULTRAPEER_SLOTS_SET);
        }
        if (this.connectionServices.isShieldedLeaf() && !this.FREE_LEAF_SLOTS_SET.isEmpty()) {
            return this.preferenceWithLocale(this.FREE_LEAF_SLOTS_SET);
        }
        if (!this.FREE_ULTRAPEER_SLOTS_SET.isEmpty()) {
            return this.preferenceWithLocale(this.FREE_ULTRAPEER_SLOTS_SET);
        }
        if (!this.FREE_LEAF_SLOTS_SET.isEmpty()) {
            Iterator iter = this.FREE_LEAF_SLOTS_SET.keySet().iterator();
            ExtendedEndpoint ee = (ExtendedEndpoint)iter.next();
            this.FREE_LEAF_SLOTS_SET.remove(ee);
            return ee;
        }
        if (!this.ENDPOINT_QUEUE.isEmpty()) {
            ExtendedEndpoint e = this.ENDPOINT_QUEUE.extractMax();
            ExtendedEndpoint removed = this.ENDPOINT_SET.remove(e);
            assert (removed == e) : "Rep. invariant for HostCatcher broken.";
            return e;
        }
        if (!this.restoredHosts.isEmpty()) {
            List<ExtendedEndpoint> best = this.uptimePartitions.getLastPartition();
            ExtendedEndpoint e = best.remove((int)(Math.random() * (double)best.size()));
            return e;
        }
        return null;
    }

    private ExtendedEndpoint preferenceWithLocale(RandomAccessMap<ExtendedEndpoint, ExtendedEndpoint> base) {
        String loc = ApplicationSettings.LANGUAGE.getValue();
        ExtendedEndpoint ret = null;
        if (!this.connectionManager.get().isLocaleMatched() && this.LOCALE_SET_MAP.containsKey(loc)) {
            Set<ExtendedEndpoint> locales = this.LOCALE_SET_MAP.get(loc);
            for (ExtendedEndpoint e : base.keySet()) {
                if (!locales.contains(e)) continue;
                locales.remove(e);
                ret = e;
                break;
            }
        }
        if (ret == null) {
            ret = base.getKeyAt(this.RND.nextInt(base.size()));
        }
        Object removed = base.remove(ret);
        assert (ret == removed) : "Key: " + ret + ", value: " + removed;
        return ret;
    }

    public synchronized int getNumHosts() {
        return this.ENDPOINT_QUEUE.size() + this.FREE_LEAF_SLOTS_SET.size() + this.FREE_ULTRAPEER_SLOTS_SET.size() + this.restoredHosts.size();
    }

    public synchronized int getNumUltrapeerHosts() {
        return this.ENDPOINT_QUEUE.size(1) + this.FREE_LEAF_SLOTS_SET.size() + this.FREE_ULTRAPEER_SLOTS_SET.size();
    }

    Iterator<ExtendedEndpoint> getPermanentHosts() {
        return this.permanentHosts.iterator();
    }

    public synchronized Collection<IpPort> getUltrapeersWithFreeUltrapeerSlots(int num) {
        return this.getPreferencedCollection(this.FREE_ULTRAPEER_SLOTS_SET, ApplicationSettings.LANGUAGE.getValue(), num);
    }

    public synchronized Collection<IpPort> getUltrapeersWithFreeUltrapeerSlots(String locale, int num) {
        return this.getPreferencedCollection(this.FREE_ULTRAPEER_SLOTS_SET, locale, num);
    }

    public synchronized Collection<IpPort> getUltrapeersWithFreeLeafSlots(int num) {
        return this.getPreferencedCollection(this.FREE_LEAF_SLOTS_SET, ApplicationSettings.LANGUAGE.getValue(), num);
    }

    public synchronized Collection<IpPort> getUltrapeersWithFreeLeafSlots(String locale, int num) {
        return this.getPreferencedCollection(this.FREE_LEAF_SLOTS_SET, locale, num);
    }

    private Collection<IpPort> getPreferencedCollection(Map<? extends ExtendedEndpoint, ? extends ExtendedEndpoint> base, String loc, int num) {
        if (loc == null || loc.equals("")) {
            loc = ApplicationSettings.DEFAULT_LOCALE.getValue();
        }
        HashSet<IpPort> hosts = new HashSet<IpPort>(num);
        IntSet masked = new IntSet();
        Set<ExtendedEndpoint> locales = this.LOCALE_SET_MAP.get(loc);
        boolean filter = ConnectionSettings.FILTER_CLASS_C.getValue();
        if (locales != null) {
            for (ExtendedEndpoint extendedEndpoint : locales) {
                if (hosts.size() >= num) break;
                if (!base.containsKey(extendedEndpoint) || filter && !masked.add(NetworkUtils.getMaskedIP(extendedEndpoint.getInetAddress(), -256))) continue;
                hosts.add(extendedEndpoint);
            }
        }
        for (ExtendedEndpoint extendedEndpoint : base.keySet()) {
            if (hosts.size() >= num) break;
            if (filter && !masked.add(NetworkUtils.getMaskedIP(extendedEndpoint.getInetAddress(), -256))) continue;
            hosts.add(extendedEndpoint);
        }
        return hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire() {
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            long now = System.currentTimeMillis();
            this.lastAllowedPongRankTime = now + 20000L;
        }
        this.recoverHosts();
        this.backgroundExecutor.schedule(new Runnable(){

            public void run() {
                HostCatcher.this.uniqueHostPinger.resetData();
            }
        }, 20000L, TimeUnit.MILLISECONDS);
    }

    public synchronized void clear() {
        this.FREE_LEAF_SLOTS_SET.clear();
        this.FREE_ULTRAPEER_SLOTS_SET.clear();
        this.ENDPOINT_QUEUE.clear();
        this.ENDPOINT_SET.clear();
    }

    public UDPPinger getPinger() {
        return this.uniqueHostPinger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void repOk() {
        if (!DEBUG) {
            return;
        }
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            block3: for (ExtendedEndpoint e : this.ENDPOINT_SET.keySet()) {
                Iterator<ExtendedEndpoint> iter2 = this.ENDPOINT_QUEUE.iterator();
                while (iter2.hasNext()) {
                    if (!((Object)e).equals(iter2.next())) continue;
                    continue block3;
                }
                throw new IllegalStateException("Couldn't find " + e + " in queue");
            }
            for (ExtendedEndpoint e : this.ENDPOINT_QUEUE) {
                assert (e instanceof ExtendedEndpoint);
                assert (this.ENDPOINT_SET.containsKey(e));
            }
            for (ExtendedEndpoint o : this.permanentHosts) {
                assert (o instanceof ExtendedEndpoint);
                assert (this.permanentHostsSet.contains(o));
            }
            for (ExtendedEndpoint e : this.permanentHostsSet) {
                assert (e instanceof ExtendedEndpoint);
                assert (this.permanentHosts.contains(e)) : "Couldn't find " + e + " from " + this.permanentHostsSet + " in " + this.permanentHosts;
            }
        }
    }

    private void readHostsFile() {
        LOG.trace("Reading Hosts File");
        try {
            this.read(this.getHostsFile());
        }
        catch (IOException e) {
            LOG.debug(this.getHostsFile(), e);
        }
    }

    private File getHostsFile() {
        return new File(CommonUtils.getUserSettingsDir(), "gnutella.net");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverHosts() {
        LOG.debug("recovering hosts file");
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            this.PROBATION_HOSTS.clear();
            this.EXPIRED_HOSTS.clear();
            this._failures = 0;
            this.FETCHER.resetFetchTime();
            this.udpHostCache.resetData();
            this.udpHostCache.loadDefaults();
            this.tcpBootstrap.resetData();
            this.tcpBootstrap.loadDefaults();
            this.restoredHosts.clear();
            this.uniqueHostPinger.resetData();
        }
        this.readHostsFile();
    }

    public synchronized void putHostOnProbation(Endpoint host) {
        this.PROBATION_HOSTS.add(host);
        if (this.PROBATION_HOSTS.size() > 500) {
            this.PROBATION_HOSTS.remove(this.PROBATION_HOSTS.iterator().next());
        }
    }

    public synchronized void expireHost(Endpoint host) {
        this.EXPIRED_HOSTS.add(host);
        if (this.EXPIRED_HOSTS.size() > 500) {
            this.EXPIRED_HOSTS.remove(this.EXPIRED_HOSTS.iterator().next());
        }
    }

    @InspectableContainer
    private class HCInspectables {
        @InspectionPoint(value="known hosts by class C")
        public final Inspectable top10classC = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object inspect() {
                HashMap<String, Object> ret = new HashMap<String, Object>();
                ret.put("ver", 1);
                ClassCNetworks permanent = new ClassCNetworks();
                ClassCNetworks restored = new ClassCNetworks();
                ClassCNetworks freeLeaf = new ClassCNetworks();
                ClassCNetworks freeUp = new ClassCNetworks();
                ClassCNetworks all = new ClassCNetworks();
                HostCatcher hostCatcher = HostCatcher.this;
                synchronized (hostCatcher) {
                    IpPortSet everybody = new IpPortSet();
                    everybody.addAll(HostCatcher.this.permanentHostsSet);
                    everybody.addAll(HostCatcher.this.restoredHosts);
                    everybody.addAll(HostCatcher.this.FREE_LEAF_SLOTS_SET.keySet());
                    everybody.addAll(HostCatcher.this.FREE_ULTRAPEER_SLOTS_SET.keySet());
                    everybody.addAll(HostCatcher.this.ENDPOINT_SET.keySet());
                    for (IpPort ip : HostCatcher.this.permanentHostsSet) {
                        permanent.add(ip.getInetAddress(), 1);
                    }
                    for (IpPort ip : HostCatcher.this.restoredHosts) {
                        restored.add(ip.getInetAddress(), 1);
                    }
                    for (IpPort ip : HostCatcher.this.FREE_LEAF_SLOTS_SET.keySet()) {
                        freeLeaf.add(ip.getInetAddress(), 1);
                    }
                    for (IpPort ip : HostCatcher.this.FREE_ULTRAPEER_SLOTS_SET.keySet()) {
                        freeUp.add(ip.getInetAddress(), 1);
                    }
                    for (IpPort ip : everybody) {
                        all.add(ip.getInetAddress(), 1);
                    }
                }
                ret.put("perm", permanent.getTopInspectable(10));
                ret.put("rest", restored.getTopInspectable(10));
                ret.put("fl", freeLeaf.getTopInspectable(10));
                ret.put("fu", freeUp.getTopInspectable(10));
                ret.put("all", all.getTopInspectable(10));
                return ret;
            }
        };
        @InspectionPoint(value="tls stats of known hosts")
        public final Inspectable tlsStats = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object inspect() {
                int futls;
                int fltls;
                int resttls;
                int permtls;
                int fu;
                int fl;
                int rest;
                int perm;
                HashMap<String, Integer> ret = new HashMap<String, Integer>();
                ret.put("ver", 1);
                HostCatcher hostCatcher = HostCatcher.this;
                synchronized (hostCatcher) {
                    perm = HostCatcher.this.permanentHostsSet.size();
                    rest = HostCatcher.this.restoredHosts.size();
                    fl = HostCatcher.this.FREE_LEAF_SLOTS_SET.size();
                    fu = HostCatcher.this.FREE_ULTRAPEER_SLOTS_SET.size();
                    permtls = 0;
                    for (ExtendedEndpoint e : HostCatcher.this.permanentHostsSet) {
                        permtls += e.isTLSCapable() ? 1 : 0;
                    }
                    resttls = 0;
                    for (ExtendedEndpoint e : HostCatcher.this.restoredHosts) {
                        resttls += e.isTLSCapable() ? 1 : 0;
                    }
                    fltls = 0;
                    for (ExtendedEndpoint e : HostCatcher.this.FREE_LEAF_SLOTS_SET.keySet()) {
                        fltls += e.isTLSCapable() ? 1 : 0;
                    }
                    futls = 0;
                    for (ExtendedEndpoint e : HostCatcher.this.FREE_ULTRAPEER_SLOTS_SET.keySet()) {
                        futls += e.isTLSCapable() ? 1 : 0;
                    }
                }
                ret.put("perm", perm);
                ret.put("permtls", permtls);
                ret.put("rest", rest);
                ret.put("resttls", resttls);
                ret.put("fl", fl);
                ret.put("fltls", fltls);
                ret.put("fu", fu);
                ret.put("futls", futls);
                return ret;
            }
        };
        @InspectionPoint(value="dht stats of known hosts")
        public final Inspectable dhtStats = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object inspect() {
                int fudht;
                int fldht;
                int restdht;
                int permdht;
                int fu;
                int fl;
                int rest;
                int perm;
                HashMap<String, Integer> ret = new HashMap<String, Integer>();
                ret.put("ver", 1);
                HostCatcher hostCatcher = HostCatcher.this;
                synchronized (hostCatcher) {
                    perm = HostCatcher.this.permanentHostsSet.size();
                    rest = HostCatcher.this.restoredHosts.size();
                    fl = HostCatcher.this.FREE_LEAF_SLOTS_SET.size();
                    fu = HostCatcher.this.FREE_ULTRAPEER_SLOTS_SET.size();
                    permdht = 0;
                    for (ExtendedEndpoint e : HostCatcher.this.permanentHostsSet) {
                        permdht += e.supportsDHT() ? 1 : 0;
                    }
                    restdht = 0;
                    for (ExtendedEndpoint e : HostCatcher.this.restoredHosts) {
                        restdht += e.supportsDHT() ? 1 : 0;
                    }
                    fldht = 0;
                    for (ExtendedEndpoint e : HostCatcher.this.FREE_LEAF_SLOTS_SET.keySet()) {
                        fldht += e.supportsDHT() ? 1 : 0;
                    }
                    fudht = 0;
                    for (ExtendedEndpoint e : HostCatcher.this.FREE_ULTRAPEER_SLOTS_SET.keySet()) {
                        fudht += e.supportsDHT() ? 1 : 0;
                    }
                }
                ret.put("perm", perm);
                ret.put("permdht", permdht);
                ret.put("rest", rest);
                ret.put("restdht", restdht);
                ret.put("fl", fl);
                ret.put("fldht", fldht);
                ret.put("fu", fu);
                ret.put("fudht", fudht);
                return ret;
            }
        };

        private HCInspectables() {
        }
    }

    private static class BlockingObserver
    implements EndpointObserver {
        private Endpoint endpoint;

        private BlockingObserver() {
        }

        public synchronized void handleEndpoint(Endpoint p) {
            this.endpoint = p;
            this.notify();
        }

        public Endpoint getEndpoint() {
            return this.endpoint;
        }
    }

    public static interface EndpointObserver {
        public void handleEndpoint(Endpoint var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BootstrapListener
    implements TcpBootstrap.TcpBootstrapListener {
        private BootstrapListener() {
        }

        @Override
        public int handleHosts(Collection<? extends Endpoint> hosts) {
            return HostCatcher.this.add(hosts);
        }
    }

    private class Bootstrapper
    implements Runnable {
        private long nextAllowedMulticastTime = 0L;
        private long nextAllowedUdpTime = 0L;
        private long nextAllowedTcpTime = 0L;
        private static final int POST_TCP_DELAY = 300000;
        private static final int POST_UDP_DELAY = 30000;
        private static final int POST_UDP_PRE_TCP_DELAY = 10000;
        private static final int POST_MULTICAST_DELAY = 60000;

        private Bootstrapper() {
        }

        public synchronized void run() {
            if (ConnectionSettings.DO_NOT_BOOTSTRAP.getValue()) {
                return;
            }
            if (HostCatcher.this._catchersWaiting.isEmpty()) {
                return;
            }
            long now = System.currentTimeMillis();
            if (!this.needsHosts(now)) {
                return;
            }
            this.getHosts(now);
        }

        void resetFetchTime() {
            this.nextAllowedUdpTime = 0L;
            this.nextAllowedMulticastTime = 0L;
            this.nextAllowedTcpTime = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean needsHosts(long now) {
            HostCatcher hostCatcher = HostCatcher.this;
            synchronized (hostCatcher) {
                return HostCatcher.this.getNumHosts() == 0 || !HostCatcher.this.connectionServices.isConnected() && HostCatcher.this._failures > 100;
            }
        }

        synchronized void getHosts(long now) {
            if (this.multicastFetch(now)) {
                return;
            }
            if (this.udpHostCacheFetch(now)) {
                return;
            }
            if (this.tcpHostCacheFetch(now)) {
                return;
            }
        }

        private boolean multicastFetch(long now) {
            if (this.nextAllowedMulticastTime < now && !ConnectionSettings.DO_NOT_MULTICAST_BOOTSTRAP.getValue()) {
                LOG.trace("Fetching via multicast");
                PingRequest pr = HostCatcher.this.pingRequestFactory.createMulticastPing();
                ((MulticastService)HostCatcher.this.multicastService.get()).send(pr);
                this.nextAllowedMulticastTime = now + 60000L;
                return true;
            }
            return false;
        }

        private boolean udpHostCacheFetch(long now) {
            if (this.nextAllowedUdpTime < now && HostCatcher.this.udpHostCache.fetchHosts()) {
                LOG.trace("Fetching via UDP");
                this.nextAllowedUdpTime = now + 30000L;
                this.nextAllowedTcpTime = Math.max(this.nextAllowedTcpTime, this.nextAllowedUdpTime + 10000L);
                return true;
            }
            return false;
        }

        private boolean tcpHostCacheFetch(long now) {
            if (this.nextAllowedTcpTime < now && HostCatcher.this.tcpBootstrap.fetchHosts(new BootstrapListener())) {
                LOG.trace("Fetching via TCP");
                this.nextAllowedTcpTime = now + 300000L;
                return true;
            }
            return false;
        }
    }
}

