/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import java.io.File;
import java.util.Set;
import org.limewire.collection.IntervalSet;
import org.limewire.collection.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncompleteFileDesc
extends FileDesc
implements HTTPHeaderValue {
    private static final int MIN_CHUNK_SIZE = 102400;
    private VerifyingFile _verifyingFile;
    private final String _name;
    private final long _size;

    public IncompleteFileDesc(File file, Set<? extends URN> urns, int index, String completedName, long completedSize, VerifyingFile vf) {
        super(file, urns, index);
        this._name = completedName;
        this._size = completedSize;
        this._verifyingFile = vf;
    }

    @Override
    public long getFileSize() {
        return this._size;
    }

    @Override
    public String getFileName() {
        return this._name;
    }

    public IntervalSet.ByteIntervals getRangesAsByte() {
        return this._verifyingFile.toBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAvailableRanges() {
        StringBuilder ret = new StringBuilder("bytes");
        boolean added = false;
        VerifyingFile verifyingFile = this._verifyingFile;
        synchronized (verifyingFile) {
            for (Range interval : this._verifyingFile.getVerifiedBlocks()) {
                if (interval.getHigh() - interval.getLow() + 1L < 102400L) continue;
                added = true;
                ret.append(" ").append(interval.getLow()).append("-").append(interval.getHigh() - 1L).append(",");
            }
        }
        if (added) {
            ret.setLength(ret.length() - 1);
        }
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadResponseRanges(IntervalSet dest) {
        VerifyingFile verifyingFile = this._verifyingFile;
        synchronized (verifyingFile) {
            if (!this.hasUrnsAndPartialData()) assert (this.getUrns().size() > 1 && this._verifyingFile.getBlockSize() + this._verifyingFile.getAmountLost() >= 102400L) : "urns : " + this.getUrns().size() + " size " + this._verifyingFile.getBlockSize() + " lost " + this._verifyingFile.getAmountLost();
            if (this._verifyingFile.getVerifiedBlockSize() > 0L) {
                dest.add(this._verifyingFile.getVerifiedIntervalSet());
                return true;
            }
            dest.add(this._verifyingFile.getPartialIntervalSet());
            return false;
        }
    }

    public boolean hasUrnsAndPartialData() {
        return this.getUrns().size() > 1 && this._verifyingFile.getBlockSize() >= 102400L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRangeSatisfiable(long low, long high) {
        VerifyingFile verifyingFile = this._verifyingFile;
        synchronized (verifyingFile) {
            for (Range interval : this._verifyingFile.getVerifiedBlocks()) {
                if (low < interval.getLow() || high > interval.getHigh()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Range getAvailableSubRange(long low, long high) {
        VerifyingFile verifyingFile = this._verifyingFile;
        synchronized (verifyingFile) {
            for (Range interval : this._verifyingFile.getVerifiedBlocks()) {
                if (interval.getLow() <= high && low <= interval.getHigh()) {
                    return Range.createRange(Math.max(interval.getLow(), low), Math.min(interval.getHigh(), high));
                }
                if (interval.getLow() <= high) continue;
                break;
            }
            return null;
        }
    }

    public boolean isRangeSatisfiable(Range range) {
        return this.isRangeSatisfiable(range.getLow(), range.getHigh());
    }

    @Override
    public String httpStringValue() {
        return this.getAvailableRanges();
    }

    @Override
    public String toString() {
        return "IncompleteFileDesc:\r\nname:     " + this._name + "\r\n" + "index:    " + this.getIndex() + "\r\n";
    }
}

