/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.messagehandlers.MessageHandler;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.InspectionRequest;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.routing.QueryRouteTable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Set;
import org.limewire.io.IpPort;
import org.limewire.lifecycle.Service;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface MessageRouter
extends Service {
    public static final long CLEAR_TIME = 30000L;

    public void setMessageHandler(Class<? extends Message> var1, MessageHandler var2);

    public void addMessageHandler(Class<? extends Message> var1, MessageHandler var2);

    public MessageHandler getMessageHandler(Class<? extends Message> var1);

    public void setUDPMessageHandler(Class<? extends Message> var1, MessageHandler var2);

    public void addUDPMessageHandler(Class<? extends Message> var1, MessageHandler var2);

    public MessageHandler getUDPMessageHandler(Class<? extends Message> var1);

    public void setMulticastMessageHandler(Class<? extends Message> var1, MessageHandler var2);

    public void addMulticastMessageHandler(Class<? extends Message> var1, MessageHandler var2);

    public MessageHandler getMulticastMessageHandler(Class<? extends Message> var1);

    public void originateQueryGUID(byte[] var1);

    public void queryKilled(GUID var1) throws IllegalArgumentException;

    public void downloadFinished(GUID var1) throws IllegalArgumentException;

    public Set<GUESSEndpoint> getQueryLocs(GUID var1);

    public String getPingRouteTableDump();

    public String getQueryRouteTableDump();

    public String getPushRouteTableDump();

    public void handleMessage(Message var1, ReplyHandler var2);

    public void handleUDPMessage(Message var1, InetSocketAddress var2);

    public void handleMulticastMessage(Message var1, InetSocketAddress var2);

    public boolean addBypassedSource(ReplyNumberVendorMessage var1, ReplyHandler var2);

    public boolean addBypassedSource(QueryReply var1, ReplyHandler var2);

    public int getNumOOBToRequest(ReplyNumberVendorMessage var1);

    public boolean isQueryAlive(GUID var1);

    public boolean isHostUnicastQueried(GUID var1, IpPort var2);

    public void sendPingRequest(PingRequest var1, RoutedConnection var2);

    public void sendQueryRequest(QueryRequest var1, RoutedConnection var2);

    public void broadcastPingRequest(PingRequest var1);

    public void sendDynamicQuery(QueryRequest var1);

    public void forwardQueryRequestToLeaves(QueryRequest var1, ReplyHandler var2);

    public boolean sendInitialQuery(QueryRequest var1, RoutedConnection var2);

    public void handleQueryReply(QueryReply var1, ReplyHandler var2);

    public void sendPushRequest(PushRequest var1) throws IOException;

    public void sendMulticastPushRequest(PushRequest var1);

    public Iterable<QueryReply> responsesToQueryReplies(Response[] var1, QueryRequest var2);

    public Iterable<QueryReply> responsesToQueryReplies(Response[] var1, QueryRequest var2, int var3, SecurityToken var4);

    public QueryRouteTable getQueryRouteTable();

    public void registerMessageListener(byte[] var1, MessageListener var2);

    public void unregisterMessageListener(byte[] var1, MessageListener var2);

    public void forwardInspectionRequestToLeaves(InspectionRequest var1);

    public long getOOBExpireTime();

    public ReplyHandler getPushHandler(byte[] var1);
}

