/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.MessageDispatcher;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.MessageFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.io.NetworkUtils;
import org.limewire.service.ErrorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class MulticastService
implements Runnable {
    private volatile MulticastSocket _socket;
    private final Object _receiveLock = new Object();
    private InetAddress _group = null;
    private int _port = -1;
    private final int BUFFER_SIZE = 32768;
    private final byte[] HEADER_BUF = new byte[23];
    private final Thread MULTICAST_THREAD;
    private final Provider<UDPService> udpService;
    private final Provider<MessageDispatcher> messageDispatcher;
    private final MessageFactory messageFactory;

    @Inject
    MulticastService(Provider<UDPService> udpService, Provider<MessageDispatcher> messageDispatcher, MessageFactory messageFactory) {
        this.udpService = udpService;
        this.messageDispatcher = messageDispatcher;
        this.messageFactory = messageFactory;
        this.MULTICAST_THREAD = ThreadExecutor.newManagedThread(this, "MulticastService");
        this.MULTICAST_THREAD.setDaemon(true);
    }

    public void start() {
        this.MULTICAST_THREAD.start();
    }

    MulticastSocket newListeningSocket(int port, InetAddress group) throws IOException {
        try {
            MulticastSocket sock = new MulticastSocket(port);
            sock.setTimeToLive(3);
            sock.joinGroup(group);
            this._port = port;
            this._group = group;
            return sock;
        }
        catch (SocketException se) {
            throw new IOException("socket could not be set on port: " + port);
        }
        catch (SecurityException se) {
            throw new IOException("security exception on port: " + port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setListeningSocket(MulticastSocket multicastSocket) {
        if (this._socket != null) {
            this._socket.close();
        }
        Object object = this._receiveLock;
        synchronized (object) {
            if (multicastSocket == null && this._socket != null && this._group != null) {
                try {
                    this._socket.leaveGroup(this._group);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this._socket = multicastSocket;
            this._receiveLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            byte[] datagramBytes = new byte[32768];
            while (true) {
                DatagramPacket datagram = new DatagramPacket(datagramBytes, 32768);
                Object object = this._receiveLock;
                synchronized (object) {
                    while (this._socket == null) {
                        try {
                            this._receiveLock.wait();
                        }
                        catch (InterruptedException ignored) {}
                    }
                    try {
                        this._socket.receive(datagram);
                    }
                    catch (InterruptedIOException e) {
                        continue;
                    }
                    catch (IOException e) {
                        continue;
                    }
                }
                if (!NetworkUtils.isValidAddress(datagram.getAddress()) || !NetworkUtils.isValidPort(datagram.getPort())) continue;
                byte[] data = datagram.getData();
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(data);
                    Message message = this.messageFactory.read((InputStream)in, Message.Network.MULTICAST, this.HEADER_BUF, datagram.getSocketAddress());
                    if (message == null) continue;
                    this.messageDispatcher.get().dispatchMulticast(message, (InetSocketAddress)datagram.getSocketAddress());
                }
                catch (IOException e) {
                }
                catch (BadPacketException e) {}
            }
        }
        catch (Throwable t) {
            ErrorService.error(t);
            return;
        }
    }

    public synchronized void send(Message msg) {
        if (this._port != -1) {
            this.udpService.get().send(msg, this._group, this._port);
        }
    }

    public boolean isListening() {
        if (this._socket == null) {
            return false;
        }
        return this._socket.getLocalPort() != -1;
    }

    public String toString() {
        return "MulticastService\r\nsocket: " + this._socket;
    }
}

