/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.NodeAssigner;
import com.limegroup.gnutella.SearchServices;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DHTSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.UltrapeerSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.statistics.TcpBandwidthStatistics;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class NodeAssignerImpl
implements NodeAssigner {
    private static final Log LOG = LogFactory.getLog(NodeAssignerImpl.class);
    private static final boolean ULTRAPEER_OS = OSUtils.isHighLoadOS();
    static final int TIMER_DELAY = 1000;
    private static final int TIMER_DELAY_IN_SECONDS = 1;
    private long _currentUptime = 0L;
    private int _maxUpstreamBytesPerSec = UploadSettings.MAX_UPLOAD_BYTES_PER_SEC.getValue();
    private int _maxDownstreamBytesPerSec = DownloadSettings.MAX_DOWNLOAD_BYTES_PER_SEC.getValue();
    private volatile boolean _isTooGoodUltrapeerToPassUp = false;
    private volatile long _lastUltrapeerAttempt = 0L;
    private int _ultrapeerTries = 0;
    private boolean _isHardcoreCapable;
    private ScheduledFuture<?> timer;
    private final Provider<BandwidthTracker> uploadTracker;
    private final Provider<BandwidthTracker> downloadTracker;
    private final Provider<ConnectionManager> connectionManager;
    private final NetworkManager networkManager;
    private final SearchServices searchServices;
    private final Provider<DHTManager> dhtManager;
    private final ScheduledExecutorService backgroundExecutor;
    private final Executor unlimitedExecutor;
    private final ConnectionServices connectionServices;
    private final TcpBandwidthStatistics tcpBandwidthStatistics;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public NodeAssignerImpl(@Named(value="uploadTracker") Provider<BandwidthTracker> uploadTracker, @Named(value="downloadTracker") Provider<BandwidthTracker> downloadTracker, Provider<ConnectionManager> connectionManager, NetworkManager networkManager, SearchServices searchServices, Provider<DHTManager> dhtManager, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, @Named(value="unlimitedExecutor") Executor unlimitedExecutor, ConnectionServices connectionServices, TcpBandwidthStatistics tcpBandwidthStatistics, NetworkInstanceUtils networkInstanceUtils) {
        this.uploadTracker = uploadTracker;
        this.downloadTracker = downloadTracker;
        this.connectionManager = connectionManager;
        this.networkManager = networkManager;
        this.searchServices = searchServices;
        this.dhtManager = dhtManager;
        this.backgroundExecutor = backgroundExecutor;
        this.connectionServices = connectionServices;
        this.unlimitedExecutor = unlimitedExecutor;
        this.tcpBandwidthStatistics = tcpBandwidthStatistics;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public void start() {
        Runnable task = new Runnable(){

            public void run() {
                NodeAssignerImpl.this.collectBandwidthData();
                NodeAssignerImpl.this.setHardcoreCapable();
                NodeAssignerImpl.this.assignUltrapeerNode();
                NodeAssignerImpl.this.assignDHTMode();
            }
        };
        this.timer = this.backgroundExecutor.scheduleWithFixedDelay(task, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        if (this.timer != null) {
            this.timer.cancel(true);
        }
    }

    private void collectBandwidthData() {
        ++this._currentUptime;
        this.uploadTracker.get().measureBandwidth();
        this.downloadTracker.get().measureBandwidth();
        this.connectionManager.get().measureBandwidth();
        float bandwidth = 0.0f;
        try {
            bandwidth = this.uploadTracker.get().getMeasuredBandwidth();
        }
        catch (InsufficientDataException ide) {
            bandwidth = 0.0f;
        }
        int newUpstreamBytesPerSec = (int)bandwidth + (int)this.connectionManager.get().getMeasuredUpstreamBandwidth();
        bandwidth = 0.0f;
        try {
            bandwidth = this.downloadTracker.get().getMeasuredBandwidth();
        }
        catch (InsufficientDataException ide) {
            bandwidth = 0.0f;
        }
        int newDownstreamBytesPerSec = (int)bandwidth + (int)this.connectionManager.get().getMeasuredDownstreamBandwidth();
        if (newUpstreamBytesPerSec > this._maxUpstreamBytesPerSec) {
            this._maxUpstreamBytesPerSec = newUpstreamBytesPerSec;
            UploadSettings.MAX_UPLOAD_BYTES_PER_SEC.setValue(this._maxUpstreamBytesPerSec);
        }
        if (newDownstreamBytesPerSec > this._maxDownstreamBytesPerSec) {
            this._maxDownstreamBytesPerSec = newDownstreamBytesPerSec;
            DownloadSettings.MAX_DOWNLOAD_BYTES_PER_SEC.setValue(this._maxDownstreamBytesPerSec);
        }
    }

    private void setHardcoreCapable() {
        boolean bl = this._isHardcoreCapable = (this._maxUpstreamBytesPerSec >= UltrapeerSettings.MIN_UPSTREAM_REQUIRED.getValue() || this._maxDownstreamBytesPerSec >= UltrapeerSettings.MIN_DOWNSTREAM_REQUIRED.getValue()) && ConnectionSettings.CONNECTION_SPEED.getValue() > 56 && ConnectionSettings.EVER_ACCEPTED_INCOMING.getValue() && ULTRAPEER_OS && !this.networkInstanceUtils.isPrivate();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Hardcore capable: " + this._isHardcoreCapable);
        }
    }

    private void assignUltrapeerNode() {
        boolean isUltrapeerCapable;
        if (UltrapeerSettings.DISABLE_ULTRAPEER_MODE.getValue()) {
            LOG.debug("Ultrapeer mode disabled");
            UltrapeerSettings.EVER_ULTRAPEER_CAPABLE.setValue(false);
            return;
        }
        if (this.connectionServices.isSupernode()) {
            LOG.debug("Already an ultrapeer, exiting");
            return;
        }
        boolean avgUptimePasses = ApplicationSettings.AVERAGE_UPTIME.getValue() >= UltrapeerSettings.MIN_AVG_UPTIME.getValue();
        boolean curUptimePasses = this._currentUptime >= (long)UltrapeerSettings.MIN_INITIAL_UPTIME.getValue();
        boolean uptimePasses = avgUptimePasses | curUptimePasses;
        boolean bl = isUltrapeerCapable = this._isHardcoreCapable && uptimePasses && this.networkManager.isGUESSCapable();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node is ultrapeer capable: " + isUltrapeerCapable + "(hc: " + this._isHardcoreCapable + ", up: " + uptimePasses + ", gc: " + this.networkManager.isGUESSCapable());
        }
        long curTime = System.currentTimeMillis();
        boolean bl2 = this._isTooGoodUltrapeerToPassUp = isUltrapeerCapable && this.networkManager.acceptedIncomingConnection() && curTime - this.searchServices.getLastQueryTime() > 300000L && this.tcpBandwidthStatistics.getAverageHttpUpstream() < 1.0;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node is " + (this._isTooGoodUltrapeerToPassUp ? "" : "NOT") + " to good to pass up");
        }
        if (isUltrapeerCapable) {
            UltrapeerSettings.EVER_ULTRAPEER_CAPABLE.setValue(true);
        }
        if (this._isTooGoodUltrapeerToPassUp && this.shouldTryToBecomeAnUltrapeer(curTime) && this.switchFromActiveDHTNodeToUltrapeer()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Node WILL try to become an ultrapeer");
            }
            ++this._ultrapeerTries;
            final int demotes = 4 * this._ultrapeerTries;
            Runnable ultrapeerRunner = new Runnable(){

                public void run() {
                    ((ConnectionManager)NodeAssignerImpl.this.connectionManager.get()).tryToBecomeAnUltrapeer(demotes);
                }
            };
            this.unlimitedExecutor.execute(ultrapeerRunner);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node will not try to become an ultrapeer");
        }
    }

    private boolean shouldTryToBecomeAnUltrapeer(long curTime) {
        if (curTime - this._lastUltrapeerAttempt < (long)UltrapeerSettings.UP_RETRY_TIME.getValue()) {
            return false;
        }
        this._lastUltrapeerAttempt = curTime;
        return true;
    }

    private boolean switchFromActiveDHTNodeToUltrapeer() {
        if (this.dhtManager.get().getDHTMode() != DHTManager.DHTMode.ACTIVE) {
            return true;
        }
        if (DHTSettings.EXCLUDE_ULTRAPEERS.getValue() && this.acceptUltrapeer()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Randomly switching from DHT node to ultrapeer!");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isTooGoodUltrapeerToPassUp() {
        return this._isTooGoodUltrapeerToPassUp;
    }

    private DHTManager.DHTMode assignDHTMode() {
        DHTManager.DHTMode current = this.dhtManager.get().getDHTMode();
        assert (current != null) : "Current DHTMode is null, fix your DHTManager-Stub!";
        DHTManager.DHTMode mode = DHTManager.DHTMode.INACTIVE;
        if (!this.dhtManager.get().isEnabled()) {
            if (current != mode) {
                this.switchDHTMode(current, mode);
            }
            return mode;
        }
        boolean isUltrapeer = this.connectionServices.isActiveSuperNode();
        if (isUltrapeer && this.isPassiveDHTCapable()) {
            mode = DHTManager.DHTMode.PASSIVE;
        }
        if (!isUltrapeer || !DHTSettings.EXCLUDE_ULTRAPEERS.getValue()) {
            assert (DHTSettings.MIN_ACTIVE_DHT_INITIAL_UPTIME.getValue() / 1000L > (long)UltrapeerSettings.MIN_CONNECT_TIME.getValue()) : "Wrong minimum initial uptime";
            long averageTime = Math.max(this.connectionManager.get().getCurrentAverageUptime(), ApplicationSettings.AVERAGE_CONNECTION_TIME.getValue());
            boolean passiveCapable = this.isPassiveLeafDHTCapable();
            boolean activeCapable = this.isActiveDHTCapable();
            if (LOG.isDebugEnabled()) {
                if (passiveCapable && !activeCapable) {
                    LOG.debug("Node is passive DHT capable\n average time: " + averageTime + "\n currentUptime: " + this._currentUptime);
                } else if (activeCapable) {
                    LOG.debug("Node is active DHT capable\n average time: " + averageTime + "\n currentUptime: " + this._currentUptime);
                } else {
                    LOG.debug("Node is NOT DHT capable\n average time: " + averageTime + "\n currentUptime: " + this._currentUptime);
                }
            }
            if (passiveCapable && !isUltrapeer) {
                mode = DHTManager.DHTMode.PASSIVE_LEAF;
            }
            if (activeCapable) {
                mode = DHTManager.DHTMode.ACTIVE;
            }
        }
        if (mode == DHTManager.DHTMode.PASSIVE && !DHTSettings.ENABLE_PASSIVE_DHT_MODE.getValue()) {
            mode = DHTManager.DHTMode.INACTIVE;
        } else if (mode == DHTManager.DHTMode.PASSIVE_LEAF && !DHTSettings.ENABLE_PASSIVE_LEAF_DHT_MODE.getValue()) {
            mode = DHTManager.DHTMode.INACTIVE;
        }
        if (DHTSettings.FORCE_DHT_CONNECT.getValue()) {
            mode = DHTManager.DHTMode.ACTIVE;
        }
        if (mode != current && (isUltrapeer || this.acceptDHTNode()) || current != DHTManager.DHTMode.INACTIVE && mode == DHTManager.DHTMode.INACTIVE) {
            this.switchDHTMode(current, mode);
        }
        return mode;
    }

    private void switchDHTMode(DHTManager.DHTMode from, final DHTManager.DHTMode to) {
        Runnable init = new Runnable(){

            public void run() {
                if (to != DHTManager.DHTMode.INACTIVE) {
                    ((DHTManager)NodeAssignerImpl.this.dhtManager.get()).start(to);
                } else {
                    ((DHTManager)NodeAssignerImpl.this.dhtManager.get()).stop();
                }
                DHTSettings.DHT_MODE.setValue(to.toString());
            }
        };
        this.unlimitedExecutor.execute(init);
    }

    private boolean isPassiveDHTCapable() {
        long averageTime = this.getAverageTime();
        return ULTRAPEER_OS && averageTime >= DHTSettings.MIN_PASSIVE_DHT_AVERAGE_UPTIME.getValue() && this._currentUptime >= DHTSettings.MIN_PASSIVE_DHT_INITIAL_UPTIME.getValue() / 1000L && this.networkManager.canReceiveSolicited();
    }

    private boolean isPassiveLeafDHTCapable() {
        long averageTime = this.getAverageTime();
        return ULTRAPEER_OS && averageTime >= DHTSettings.MIN_PASSIVE_LEAF_DHT_AVERAGE_UPTIME.getValue() && this._currentUptime >= DHTSettings.MIN_PASSIVE_LEAF_DHT_INITIAL_UPTIME.getValue() / 1000L && this.networkManager.canReceiveSolicited();
    }

    private boolean isActiveDHTCapable() {
        long averageTime = this.getAverageTime();
        return this._isHardcoreCapable && averageTime >= DHTSettings.MIN_ACTIVE_DHT_AVERAGE_UPTIME.getValue() && this._currentUptime >= DHTSettings.MIN_ACTIVE_DHT_INITIAL_UPTIME.getValue() / 1000L && this.networkManager.isGUESSCapable();
    }

    private long getAverageTime() {
        return Math.max(this.connectionManager.get().getCurrentAverageUptime(), ApplicationSettings.AVERAGE_CONNECTION_TIME.getValue());
    }

    private boolean acceptDHTNode() {
        return Math.random() < (double)DHTSettings.DHT_ACCEPT_PROBABILITY.getValue();
    }

    private boolean acceptUltrapeer() {
        return Math.random() < (double)DHTSettings.SWITCH_TO_ULTRAPEER_PROBABILITY.getValue();
    }
}

