/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.PongCacher;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.limewire.collection.BucketQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class PongCacherImpl
implements PongCacher {
    private final Map<String, BucketQueue<PingReply>> PONGS = new HashMap<String, BucketQueue<PingReply>>();
    private final ConnectionServices connectionServices;

    @Inject
    public PongCacherImpl(ConnectionServices connectionServices) {
        this.connectionServices = connectionServices;
    }

    Map<String, BucketQueue<PingReply>> getPongMap() {
        return this.PONGS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PingReply> getBestPongs(String loc) {
        Map<String, BucketQueue<PingReply>> map = this.PONGS;
        synchronized (map) {
            LinkedList<PingReply> pongs = new LinkedList<PingReply>();
            long curTime = System.currentTimeMillis();
            List<PingReply> removeList = this.addBestPongs(loc, pongs, curTime, 0);
            this.removePongs(loc, removeList);
            if (!ApplicationSettings.DEFAULT_LOCALE.getValue().equals(loc) && pongs.size() < 6) {
                removeList = this.addBestPongs(ApplicationSettings.DEFAULT_LOCALE.getValue(), pongs, curTime, pongs.size());
                this.removePongs(ApplicationSettings.DEFAULT_LOCALE.getValue(), removeList);
            }
            return pongs;
        }
    }

    private List<PingReply> addBestPongs(String loc, List<PingReply> pongs, long curTime, int hops) {
        int exp_time = ApplicationSettings.DEFAULT_LOCALE.getValue().equals(loc) ? 6000 : 90000;
        LinkedList<PingReply> remove = null;
        if (this.PONGS.containsKey(loc)) {
            BucketQueue<PingReply> bq = this.PONGS.get(loc);
            Iterator<PingReply> iter = bq.iterator();
            while (iter.hasNext() && hops < 6) {
                PingReply pr = iter.next();
                if (curTime - pr.getCreationTime() > (long)exp_time) {
                    if (remove == null) {
                        remove = new LinkedList<PingReply>();
                    }
                    remove.add(pr);
                } else {
                    pongs.add(pr);
                }
                ++hops;
            }
        }
        return remove;
    }

    private void removePongs(String loc, List<PingReply> l) {
        if (l != null) {
            BucketQueue<PingReply> bq = this.PONGS.get(loc);
            for (PingReply pr : l) {
                bq.removeAll(pr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPong(PingReply pr) {
        if (!this.connectionServices.isSupernode()) {
            return;
        }
        if (!pr.isUltrapeer()) {
            return;
        }
        if (pr.getHops() >= 6) {
            return;
        }
        Map<String, BucketQueue<PingReply>> map = this.PONGS;
        synchronized (map) {
            if (this.PONGS.containsKey(pr.getClientLocale())) {
                BucketQueue<PingReply> bq = this.PONGS.get(pr.getClientLocale());
                bq.insert(pr, pr.getHops());
            } else {
                BucketQueue<PingReply> bq = new BucketQueue<PingReply>(6, 1);
                bq.insert(pr, pr.getHops());
                this.PONGS.put(pr.getClientLocale(), bq);
            }
        }
    }
}

