/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.settings.ThirdPartySearchResultsSettings;
import org.limewire.promotion.InitializeException;
import org.limewire.promotion.PromotionBinderRepository;
import org.limewire.promotion.PromotionSearcher;
import org.limewire.promotion.PromotionServices;

@Singleton
final class PromotionServicesImpl
implements PromotionServices {
    private final PromotionBinderRepository promotionBinderRepository;
    private final PromotionSearcher promotionSearcher;
    private volatile boolean isRunning;

    @Inject
    public PromotionServicesImpl(PromotionBinderRepository promotionBinderRepository, PromotionSearcher promotionSearcher) {
        this.promotionBinderRepository = promotionBinderRepository;
        this.promotionSearcher = promotionSearcher;
    }

    public void init() {
        try {
            this.promotionBinderRepository.init(ThirdPartySearchResultsSettings.SEARCH_URL.getValue(), ThirdPartySearchResultsSettings.BUCKET_ID_MODULUS.getValue());
            this.promotionSearcher.init(ThirdPartySearchResultsSettings.MAX_NUMBER_OF_SEARCH_RESULTS.getValue());
            this.isRunning = true;
        }
        catch (InitializeException initializeException) {
            this.shutDown();
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void shutDown() {
        this.promotionSearcher.shutDown();
        this.isRunning = false;
    }
}

