/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.AbstractPushEndpoint;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointCache;
import com.limegroup.gnutella.PushEndpointImpl;
import com.limegroup.gnutella.dht.db.SearchListener;
import com.limegroup.gnutella.uploader.HTTPHeaderUtils;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.Connectable;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.io.NetworkInstanceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class PushEndpointCacheImpl
implements PushEndpointCache {
    private static final Log LOG = LogFactory.getLog(PushEndpointCacheImpl.class);
    private final Map<GUID, CachedPushEndpoint> GUID_PROXY_MAP = Collections.synchronizedMap(new WeakHashMap());
    private final HTTPHeaderUtils httpHeaderUtils;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    PushEndpointCacheImpl(@Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, HTTPHeaderUtils httpHeaderUtils, NetworkInstanceUtils networkInstanceUtils) {
        this.httpHeaderUtils = httpHeaderUtils;
        this.networkInstanceUtils = networkInstanceUtils;
        backgroundExecutor.scheduleWithFixedDelay(new WeakCleaner(), 30000L, 30000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void overwriteProxies(byte[] guid, String httpString) {
        Set<Connectable> newSet = this.httpHeaderUtils.decodePushProxies(httpString, ",");
        this.overwriteProxies(guid, newSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overwriteProxies(byte[] guid, Set<? extends IpPort> newSet) {
        GUID g = new GUID(guid);
        Map<GUID, CachedPushEndpoint> map = this.GUID_PROXY_MAP;
        synchronized (map) {
            CachedPushEndpoint wrapper = this.GUID_PROXY_MAP.get(g);
            if (wrapper == null) {
                wrapper = new CachedPushEndpoint(g, newSet);
                this.GUID_PROXY_MAP.put(g, wrapper);
            } else {
                wrapper.overwriteProxies(newSet);
            }
        }
    }

    @Override
    public void removePushProxy(byte[] bytes, IpPort pushProxy) {
        GUID guid;
        CachedPushEndpoint cachedPushEndpoint;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing push proxy: " + pushProxy + " for " + new GUID(bytes));
        }
        if ((cachedPushEndpoint = this.GUID_PROXY_MAP.get(guid = new GUID(bytes))) != null) {
            cachedPushEndpoint.removePushProxy(pushProxy);
        }
    }

    @Override
    public void setAddr(byte[] guid, IpPort addr) {
        GUID g = new GUID(guid);
        CachedPushEndpoint current = this.getCached(g);
        if (current != null) {
            current.setIpPort(addr);
        }
    }

    @Override
    public void setFWTVersionSupported(byte[] guid, int version) {
        GUID g = new GUID(guid);
        CachedPushEndpoint current = this.getCached(g);
        if (current != null) {
            current.setFWTVersion(version);
        }
    }

    @Override
    public CachedPushEndpoint getCached(GUID guid) {
        return this.GUID_PROXY_MAP.get(guid);
    }

    @Override
    public PushEndpoint getPushEndpoint(GUID guid) {
        CachedPushEndpoint cached = this.GUID_PROXY_MAP.get(guid);
        return cached != null ? cached.createClone() : null;
    }

    @Override
    public void findPushEndpoint(GUID guid, SearchListener<PushEndpoint> listener) {
        PushEndpoint pushEndpoint = this.getPushEndpoint(guid);
        if (pushEndpoint != null) {
            listener.handleResult(pushEndpoint);
        } else {
            listener.searchFailed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GUID updateProxiesFor(GUID guid, PushEndpoint pushEndpoint, boolean valid) {
        CachedPushEndpoint existing;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating proxies for: " + guid + " with: " + pushEndpoint + ", valid: " + valid);
        }
        GUID guidRef = null;
        Map<GUID, CachedPushEndpoint> map = this.GUID_PROXY_MAP;
        synchronized (map) {
            existing = this.GUID_PROXY_MAP.get(guid);
            if (existing != null) {
                guidRef = existing.getGuid();
            }
            if (existing == null || guidRef == null) {
                existing = new CachedPushEndpoint(guid, pushEndpoint.getFeatures(), pushEndpoint.getFWTVersion(), valid ? pushEndpoint.getProxies() : IpPort.EMPTY_SET);
                this.GUID_PROXY_MAP.put(guid, existing);
                return guid;
            }
        }
        existing.updateProxies(pushEndpoint.getProxies(), valid);
        return guidRef;
    }

    @Override
    public void clear() {
        this.GUID_PROXY_MAP.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CachedPushEndpoint
    extends AbstractPushEndpoint {
        private final WeakReference<GUID> _guidRef;
        private Set<IpPort> _proxies;
        private byte _features;
        private int _fwtVersion;
        private IpPort _externalAddr;
        private final byte[] guid;

        CachedPushEndpoint(GUID guid, Set<? extends IpPort> proxies) {
            this(guid, 0, 0, proxies);
        }

        CachedPushEndpoint(GUID guid, byte features, int version, Set<? extends IpPort> proxies) {
            this.guid = guid.bytes();
            this._guidRef = new WeakReference<GUID>(guid);
            this._features = features;
            this._fwtVersion = version;
            this.overwriteProxies(proxies);
        }

        public synchronized void removePushProxy(IpPort pushProxy) {
            this.updateProxies(new IpPortSet(pushProxy), false);
        }

        public synchronized void updateProxies(Set<? extends IpPort> s, boolean add) {
            IpPortSet existing = new IpPortSet((Collection<? extends IpPort>)this._proxies);
            if (add) {
                existing.addAll(s);
            } else {
                existing.removeAll(s);
            }
            this._proxies = Collections.unmodifiableSet(existing);
        }

        public synchronized void overwriteProxies(Set<? extends IpPort> proxies) {
            this._proxies = Collections.unmodifiableSet(new IpPortSet((Collection<? extends IpPort>)proxies));
        }

        public synchronized Set<IpPort> getProxies() {
            return this._proxies;
        }

        @Override
        public synchronized byte getFeatures() {
            return this._features;
        }

        @Override
        public synchronized int getFWTVersion() {
            return this._fwtVersion;
        }

        public synchronized void setFeatures(byte features) {
            this._features = features;
        }

        public synchronized void setFWTVersion(int version) {
            this._fwtVersion = version;
        }

        public synchronized void setIpPort(IpPort addr) {
            this._externalAddr = addr;
        }

        public synchronized IpPort getIpPort() {
            return this._externalAddr;
        }

        public GUID getGuid() {
            return (GUID)this._guidRef.get();
        }

        @Override
        public synchronized PushEndpoint createClone() {
            return new PushEndpointImpl(this.guid, this.getProxies(), this.getFeatures(), this.getFWTVersion(), this.getValidExternalAddress(), PushEndpointCacheImpl.this, PushEndpointCacheImpl.this.networkInstanceUtils);
        }

        @Override
        public byte[] getClientGUID() {
            return this.guid;
        }

        @Override
        public synchronized int getPort() {
            IpPort address = this._externalAddr;
            return address != null ? address.getPort() : 6346;
        }

        @Override
        public synchronized IpPort getValidExternalAddress() {
            return this._externalAddr;
        }

        @Override
        public boolean isLocal() {
            return false;
        }

        @Override
        public synchronized void updateProxies(boolean good) {
            if (!good) {
                this._proxies = Collections.emptySet();
            }
        }

        @Override
        public synchronized String getAddress() {
            IpPort address = this._externalAddr;
            return address != null ? this._externalAddr.getAddress() : "1.1.1.1";
        }

        @Override
        public InetAddress getInetAddress() {
            return null;
        }

        @Override
        public InetSocketAddress getInetSocketAddress() {
            return null;
        }
    }

    private final class WeakCleaner
    implements Runnable {
        private WeakCleaner() {
        }

        public void run() {
            PushEndpointCacheImpl.this.GUID_PROXY_MAP.size();
        }
    }
}

