/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.limewire.collection.IntervalSet;
import org.limewire.io.IpPort;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResponseImpl
implements Response {
    private final long index;
    private final long size;
    private final byte[] nameBytes;
    private final String name;
    private final int incomingNameByteArraySize;
    private LimeXMLDocument document;
    private final Set<URN> urns;
    private final byte[] extBytes;
    private volatile RemoteFileDesc cachedRFD;
    private final boolean isMetaFile;
    private final Set<? extends IpPort> alternateLocations;
    private final long creationTime;
    private final IntervalSet ranges;
    private final boolean verified;

    public ResponseImpl(long index, long size, String name, int incomingNameByteArraySize, Set<? extends URN> urns, LimeXMLDocument doc, Set<? extends IpPort> alternateLocations, long creationTime, byte[] extensions, IntervalSet ranges, boolean verified) {
        if ((index & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid index: " + index);
        }
        if (size < 0L || size > 0xFFFFFFFFFFL) {
            throw new IllegalArgumentException("invalid size: " + size);
        }
        this.index = index;
        this.size = size;
        this.name = name == null ? "" : name;
        this.isMetaFile = this.name.toLowerCase(Locale.US).endsWith(".torrent");
        byte[] temp = null;
        try {
            temp = this.name.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException namex) {
            ErrorService.error(namex);
        }
        this.nameBytes = temp;
        this.urns = urns == null ? Collections.emptySet() : Collections.unmodifiableSet(urns);
        this.alternateLocations = alternateLocations;
        this.creationTime = creationTime;
        this.extBytes = extensions;
        this.incomingNameByteArraySize = incomingNameByteArraySize;
        this.document = doc;
        this.ranges = ranges;
        this.verified = verified;
    }

    @Override
    public void writeToStream(OutputStream os) throws IOException {
        int i;
        ByteUtils.int2leb((int)this.index, os);
        if (this.size > Integer.MAX_VALUE) {
            ByteUtils.int2leb(-1, os);
        } else {
            ByteUtils.int2leb((int)this.size, os);
        }
        for (i = 0; i < this.nameBytes.length; ++i) {
            os.write(this.nameBytes[i]);
        }
        os.write(0);
        for (i = 0; i < this.extBytes.length; ++i) {
            os.write(this.extBytes[i]);
        }
        os.write(0);
    }

    @Override
    public void setDocument(LimeXMLDocument doc) {
        this.document = doc;
    }

    @Override
    public int getIncomingLength() {
        if (this.incomingNameByteArraySize != -1) {
            return 8 + this.incomingNameByteArraySize + 1 + this.extBytes.length + 1;
        }
        return 8 + this.nameBytes.length + 1 + this.extBytes.length + 1;
    }

    @Override
    public long getIndex() {
        return this.index;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LimeXMLDocument getDocument() {
        return this.document;
    }

    @Override
    public Set<URN> getUrns() {
        return this.urns;
    }

    @Override
    public Set<? extends IpPort> getLocations() {
        return this.alternateLocations;
    }

    @Override
    public long getCreateTime() {
        return this.creationTime;
    }

    @Override
    public boolean isMetaFile() {
        return this.isMetaFile;
    }

    @Override
    public byte[] getExtBytes() {
        return this.extBytes;
    }

    @Override
    public IntervalSet getRanges() {
        return this.ranges;
    }

    @Override
    public boolean isVerified() {
        return this.verified;
    }

    @Override
    public RemoteFileDesc toRemoteFileDesc(HostData data, RemoteFileDescFactory remoteFileDescFactory) {
        RemoteFileDesc rfd;
        if (this.cachedRFD != null && this.cachedRFD.getPort() == data.getPort() && this.cachedRFD.getHost().equals(data.getIP())) {
            return this.cachedRFD;
        }
        this.cachedRFD = rfd = remoteFileDescFactory.createRemoteFileDesc(data.getIP(), data.getPort(), this.getIndex(), this.getName(), this.getSize(), data.getClientGUID(), data.getSpeed(), data.isChatEnabled(), data.getQuality(), data.isBrowseHostEnabled(), this.getDocument(), this.getUrns(), data.isReplyToMulticastQuery(), data.isFirewalled(), data.getVendorCode(), data.getPushProxies(), this.getCreateTime(), data.getFWTVersionSupported(), data.isTLSCapable());
        return rfd;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response r = (Response)o;
        return this.getIndex() == r.getIndex() && this.getSize() == r.getSize() && this.getName().equals(r.getName()) && (this.getDocument() == null ? r.getDocument() == null : this.getDocument().equals(r.getDocument())) && ((Object)this.getUrns()).equals(r.getUrns());
    }

    public int hashCode() {
        return (int)((long)(961 * this.getName().hashCode()) + 31L * this.getSize() + this.getIndex());
    }

    public String toString() {
        return "index:        " + this.index + "\r\n" + "size:         " + this.size + "\r\n" + "name:         " + this.name + "\r\n" + "xml document: " + this.document + "\r\n" + "urns:         " + this.urns;
    }
}

