/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.UrnCallback;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Comparators;
import org.limewire.concurrent.ExecutorsHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class SavedFileManager
implements Runnable {
    private static final Log LOG = LogFactory.getLog(SavedFileManager.class);
    private static final ExecutorService QUEUE = ExecutorsHelper.newProcessingQueue("SavedFileLoader");
    private final UrnCache urnCache;
    private Set<URN> _urns = new HashSet<URN>();
    private Set<String> _names = new TreeSet<String>(Comparators.caseInsensitiveStringComparator());

    @Inject
    SavedFileManager(UrnCache urnCache, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor) {
        this.urnCache = urnCache;
        backgroundExecutor.scheduleWithFixedDelay(this, 10000L, 180000L, TimeUnit.MILLISECONDS);
    }

    public synchronized void addSavedFile(File f, Set<? extends URN> urns) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding: " + f + " with: " + urns);
        }
        this._names.add(f.getName());
        for (URN uRN : urns) {
            this._urns.add(uRN);
        }
    }

    public synchronized boolean isSaved(URN urn, String name) {
        return urn != null && this._urns.contains(urn) || this._names.contains(name);
    }

    @Override
    public void run() {
        QUEUE.execute(new Runnable(){

            public void run() {
                SavedFileManager.this.load();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        LOG.trace("Loading Saved Files");
        HashSet urns = new HashSet();
        TreeSet<String> names = new TreeSet<String>(Comparators.caseInsensitiveStringComparator());
        UrnCallback callback = new UrnCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void urnsCalculated(File f, Set<? extends URN> urns) {
                SavedFileManager savedFileManager = SavedFileManager.this;
                synchronized (savedFileManager) {
                    SavedFileManager.this._urns.addAll(urns);
                }
            }

            @Override
            public boolean isOwner(Object o) {
                return o == SavedFileManager.this;
            }
        };
        Set<File> saveDirs = SharingSettings.getAllSaveDirectories();
        for (File next : saveDirs) {
            this.loadDirectory(next, urns, names, callback);
        }
        SavedFileManager savedFileManager = this;
        synchronized (savedFileManager) {
            this._urns.addAll(urns);
            this._names.addAll(names);
        }
    }

    private void loadDirectory(File directory, Set<? super URN> tempUrns, Set<String> tempNames, UrnCallback callback) {
        File[] savedFiles = directory.listFiles();
        if (savedFiles == null) {
            return;
        }
        for (int i = 0; i < savedFiles.length; ++i) {
            File file = savedFiles[i];
            if (!file.isFile() || !file.exists()) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Loading: " + file);
            }
            tempNames.add(file.getName());
            Set<URN> urns = this.urnCache.getUrns(file);
            if (urns.isEmpty()) {
                this.urnCache.calculateAndCacheUrns(file, callback);
                continue;
            }
            tempUrns.addAll(urns);
        }
    }
}

