/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.SpamServices;
import com.limegroup.gnutella.UDPReplyHandlerCache;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.filters.SpamFilterFactory;
import com.limegroup.gnutella.settings.FilterSettings;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import org.limewire.collection.Comparators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class SpamServicesImpl
implements SpamServices {
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<IPFilter> ipFilter;
    private final SpamFilterFactory spamFilterFactory;
    private final UDPReplyHandlerCache udpReplyHandlerCache;

    @Inject
    public SpamServicesImpl(Provider<ConnectionManager> connectionManager, Provider<IPFilter> ipFilter, SpamFilterFactory spamFilterFactory, UDPReplyHandlerCache udpReplyHandlerCache) {
        this.connectionManager = connectionManager;
        this.ipFilter = ipFilter;
        this.spamFilterFactory = spamFilterFactory;
        this.udpReplyHandlerCache = udpReplyHandlerCache;
    }

    @Override
    public void adjustSpamFilters() {
        this.udpReplyHandlerCache.setPersonalFilter(this.spamFilterFactory.createPersonalFilter());
        for (RoutedConnection c : this.connectionManager.get().getConnections()) {
            if (this.ipFilter.get().allow(c.getAddress())) {
                c.setPersonalFilter(this.spamFilterFactory.createPersonalFilter());
                c.setRouteFilter(this.spamFilterFactory.createRouteFilter());
                continue;
            }
            c.close();
        }
    }

    @Override
    public void reloadIPFilter() {
        this.ipFilter.get().refreshHosts(new IPFilter.IPFilterCallback(){

            public void ipFiltersLoaded() {
                SpamServicesImpl.this.adjustSpamFilters();
            }
        });
    }

    @Override
    public boolean isAllowed(InetAddress host) {
        return this.ipFilter.get().allow(host.getAddress());
    }

    @Override
    public void blockHost(String host) {
        String[] bannedIPs = FilterSettings.BLACK_LISTED_IP_ADDRESSES.getValue();
        Arrays.sort(bannedIPs, Comparators.stringComparator());
        if (Arrays.binarySearch(bannedIPs, host, Comparators.stringComparator()) < 0) {
            String[] more_banned = new String[bannedIPs.length + 1];
            System.arraycopy(bannedIPs, 0, more_banned, 0, bannedIPs.length);
            more_banned[bannedIPs.length] = host;
            FilterSettings.BLACK_LISTED_IP_ADDRESSES.setValue(more_banned);
            this.reloadIPFilter();
        }
    }

    @Override
    public void unblockHost(String host) {
        String[] bannedIPs = FilterSettings.BLACK_LISTED_IP_ADDRESSES.getValue();
        List<String> bannedList = Arrays.asList(bannedIPs);
        if (bannedList.remove(host)) {
            FilterSettings.BLACK_LISTED_IP_ADDRESSES.setValue(bannedList.toArray(new String[0]));
            this.reloadIPFilter();
        }
    }
}

