/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.GuidMapManager;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.MessageDispatcher;
import com.limegroup.gnutella.MessageHandlerBinder;
import com.limegroup.gnutella.MessageRouterImpl;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.PongCacher;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.UDPReplyHandlerCache;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.messagehandlers.InspectionRequestHandler;
import com.limegroup.gnutella.messagehandlers.LimeACKHandler;
import com.limegroup.gnutella.messagehandlers.OOBHandler;
import com.limegroup.gnutella.messagehandlers.UDPCrawlerPingHandler;
import com.limegroup.gnutella.messages.FeatureSearchData;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingReplyFactory;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryReplyFactory;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.messages.StaticMessages;
import com.limegroup.gnutella.messages.vendor.HeadPongFactory;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessageFactory;
import com.limegroup.gnutella.search.QueryDispatcher;
import com.limegroup.gnutella.search.QueryHandlerFactory;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.MessageSettings;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.version.UpdateHandler;
import com.limegroup.gnutella.xml.LimeXMLDocumentHelper;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.Connectable;
import org.limewire.io.IpPortImpl;
import org.limewire.io.NetworkUtils;
import org.limewire.net.SocketsManager;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class StandardMessageRouter
extends MessageRouterImpl {
    private static final Log LOG = LogFactory.getLog(StandardMessageRouter.class);
    private final Statistics statistics;
    private final ReplyNumberVendorMessageFactory replyNumberVendorMessageFactory;
    @InspectionPoint(value="false positive queries")
    private final Message.MessageCounter falsePositives = new Message.MessageCounter(50);
    @InspectionPoint(value="not serviced queries")
    private final Message.MessageCounter notServiced = new Message.MessageCounter(500);
    @InspectionPoint(value="ignored busy queries")
    private final Message.MessageCounter ignoredBusy = new Message.MessageCounter(500);

    @Inject
    public StandardMessageRouter(NetworkManager networkManager, QueryRequestFactory queryRequestFactory, QueryHandlerFactory queryHandlerFactory, OnDemandUnicaster onDemandUnicaster, HeadPongFactory headPongFactory, PingReplyFactory pingReplyFactory, ConnectionManager connectionManager, @Named(value="forMeReplyHandler") ReplyHandler forMeReplyHandler, QueryUnicaster queryUnicaster, FileManager fileManager, ContentManager contentManager, DHTManager dhtManager, UploadManager uploadManager, DownloadManager downloadManager, UDPService udpService, SearchResultHandler searchResultHandler, SocketsManager socketsManager, HostCatcher hostCatcher, QueryReplyFactory queryReplyFactory, StaticMessages staticMessages, Provider<MessageDispatcher> messageDispatcher, MulticastService multicastService, QueryDispatcher queryDispatcher, Provider<ActivityCallback> activityCallback, ConnectionServices connectionServices, ApplicationServices applicationServices, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<PongCacher> pongCacher, Provider<SimppManager> simppManager, Provider<UpdateHandler> updateHandler, GuidMapManager guidMapManager, UDPReplyHandlerCache udpReplyHandlerCache, Provider<InspectionRequestHandler> inspectionRequestHandlerFactory, Provider<UDPCrawlerPingHandler> udpCrawlerPingHandlerFactory, Statistics statistics, ReplyNumberVendorMessageFactory replyNumberVendorMessageFactory, PingRequestFactory pingRequestFactory, MessageHandlerBinder messageHandlerBinder, Provider<OOBHandler> oobHandlerFactory, Provider<MACCalculatorRepositoryManager> MACCalculatorRepositoryManager2, Provider<LimeACKHandler> limeACKHandler) {
        super(networkManager, queryRequestFactory, queryHandlerFactory, onDemandUnicaster, headPongFactory, pingReplyFactory, connectionManager, forMeReplyHandler, queryUnicaster, fileManager, contentManager, dhtManager, uploadManager, downloadManager, udpService, searchResultHandler, socketsManager, hostCatcher, queryReplyFactory, staticMessages, messageDispatcher, multicastService, queryDispatcher, activityCallback, connectionServices, applicationServices, backgroundExecutor, pongCacher, simppManager, updateHandler, guidMapManager, udpReplyHandlerCache, inspectionRequestHandlerFactory, udpCrawlerPingHandlerFactory, pingRequestFactory, messageHandlerBinder, oobHandlerFactory, MACCalculatorRepositoryManager2, limeACKHandler);
        this.statistics = statistics;
        this.replyNumberVendorMessageFactory = replyNumberVendorMessageFactory;
    }

    @Override
    protected void respondToPingRequest(PingRequest ping, ReplyHandler handler) {
        byte ttl;
        byte hops = ping.getHops();
        if (hops + (ttl = ping.getTTL()) > 2 && !this.connectionManager.allowAnyConnection()) {
            return;
        }
        if (NetworkUtils.isValidAddress(this.networkManager.getAddress()) && NetworkUtils.isValidPort(this.networkManager.getPort())) {
            if (hops == 1 && ttl == 1) {
                this.handleCrawlerPing(ping, handler);
                return;
            }
            if (ping.isHeartbeat()) {
                this.sendPingReply(this.pingReplyFactory.create(ping.getGUID(), (byte)1), handler);
                return;
            }
            int newTTL = hops + 1;
            if (hops + ttl <= 2) {
                newTTL = 1;
            }
            if (this.connectionManager.hasFreeSlots() || this.statistics.calculateDailyUptime() > 1800) {
                PingReply pr = this.pingReplyFactory.create(ping.getGUID(), (byte)newTTL);
                this.sendPingReply(pr, handler);
            }
        }
        List<PingReply> pongs = ((PongCacher)this.pongCacher.get()).getBestPongs(ping.getLocale());
        byte[] guid = ping.getGUID();
        InetAddress pingerIP = handler.getInetAddress();
        for (PingReply pr : pongs) {
            if (pr.getInetAddress().equals(pingerIP)) continue;
            this.sendPingReply(this.pingReplyFactory.mutateGUID(pr, guid), handler);
        }
    }

    @Override
    protected void respondToUDPPingRequest(PingRequest request, InetSocketAddress addr, ReplyHandler handler) {
        if (!this.networkManager.isIpPortValid()) {
            return;
        }
        IpPortImpl ipport = null;
        if (request.requestsIP()) {
            ipport = new IpPortImpl(addr);
        }
        List<Object> dhthosts = Collections.emptyList();
        int maxHosts = ConnectionSettings.NUM_RETURN_PONGS.getValue();
        if (request.requestsDHTIPP() && this.dhtManager.isRunning()) {
            dhthosts = this.dhtManager.getActiveDHTNodes(maxHosts);
        }
        int numDHTHosts = dhthosts.size();
        byte[] data = request.getSupportsCachedPongData();
        Collection<Object> gnuthosts = Collections.emptyList();
        if (data != null) {
            boolean isUltrapeer = data.length >= 1 && (data[0] & 1) == 1;
            int dhtFraction = ConnectionSettings.DHT_TO_GNUT_HOSTS_PONG.getValue();
            int maxDHTHosts = Math.round((float)dhtFraction / 100.0f * (float)maxHosts);
            gnuthosts = this.connectionServices.getPreferencedHosts(isUltrapeer, request.getLocale(), maxHosts - Math.min(numDHTHosts, maxDHTHosts));
            dhthosts = dhthosts.subList(0, Math.min(numDHTHosts, maxHosts - gnuthosts.size()));
        }
        PingReply reply = ipport != null ? this.pingReplyFactory.create(request.getGUID(), (byte)1, ipport, gnuthosts, dhthosts) : this.pingReplyFactory.create(request.getGUID(), (byte)1, gnuthosts, dhthosts);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Responding to UDPPingRequest " + (request.requestsDHTIPP() ? "with DHTIPP " : "") + "from : " + addr + " with Gnutella hosts: \n" + gnuthosts + "\n and DHT hosts: \n" + dhthosts);
        }
        this.sendPingReply(reply, handler);
    }

    private void handleCrawlerPing(PingRequest m, ReplyHandler handler) {
        List<RoutedConnection> leafConnections = this.connectionManager.getInitializedClientConnections();
        for (RoutedConnection connection : leafConnections) {
            PingReply pr = this.pingReplyFactory.createExternal(m.getGUID(), (byte)2, connection.getPort(), connection.getInetAddress().getAddress(), false);
            pr.hop();
            this.sendPingReply(pr, handler);
        }
    }

    @Override
    protected boolean respondToQueryRequest(QueryRequest queryRequest, byte[] clientGUID, ReplyHandler handler) {
        if (!FeatureSearchData.supportsFeature(queryRequest.getFeatureSelector())) {
            return false;
        }
        if (!this.uploadManager.mayBeServiceable()) {
            this.ignoredBusy.countMessage(queryRequest);
            return false;
        }
        if (!NetworkUtils.isValidPort(this.networkManager.getPort()) || !NetworkUtils.isValidAddress(this.networkManager.getAddress())) {
            return false;
        }
        Response[] responses = this.fileManager.query(queryRequest);
        if (responses.length == 0) {
            this.falsePositives.countMessage(queryRequest);
        }
        return this.sendResponses(responses, queryRequest, handler);
    }

    private boolean sendResponses(Response[] responses, QueryRequest query, ReplyHandler handler) {
        if (responses == null || responses.length < 1) {
            return false;
        }
        if (!this.uploadManager.isServiceable()) {
            ArrayList<Response> filtered = new ArrayList<Response>(responses.length);
            for (Response r : responses) {
                if (!r.isMetaFile() || !this.fileManager.isFileApplicationShared(r.getName())) continue;
                filtered.add(r);
            }
            if (filtered.isEmpty()) {
                this.notServiced.countMessage(query);
                return false;
            }
            if (filtered.size() != responses.length) {
                responses = filtered.toArray(new Response[filtered.size()]);
            }
        }
        if (query.desiresOutOfBandReplies() && !this.isConnectedTo(query, handler) && this.networkManager.canReceiveSolicited() && NetworkUtils.isValidAddressAndPort(query.getReplyAddress(), query.getReplyPort())) {
            if (((LimeACKHandler)this.limeAckHandler.get()).bufferResponsesForLaterDelivery(query, responses)) {
                InetAddress addr = null;
                try {
                    addr = InetAddress.getByName(query.getReplyAddress());
                }
                catch (UnknownHostException uhe) {
                    // empty catch block
                }
                final int port = query.getReplyPort();
                if (addr != null) {
                    int resultCount = responses.length > 255 ? 255 : responses.length;
                    final ReplyNumberVendorMessage vm = query.desiresOutOfBandRepliesV3() ? this.replyNumberVendorMessageFactory.createV3ReplyNumberVendorMessage(new GUID(query.getGUID()), resultCount) : this.replyNumberVendorMessageFactory.createV2ReplyNumberVendorMessage(new GUID(query.getGUID()), resultCount);
                    this.udpService.send(vm, addr, port);
                    if (MessageSettings.OOB_REDUNDANCY.getValue() && query.desiresOutOfBandRepliesV3()) {
                        final InetAddress addrf = addr;
                        this.backgroundExecutor.schedule(new Runnable(){

                            public void run() {
                                StandardMessageRouter.this.udpService.send(vm, addrf, port);
                            }
                        }, 100L, TimeUnit.MILLISECONDS);
                    }
                    return true;
                }
            } else {
                return false;
            }
        }
        Iterable<QueryReply> iterable = this.responsesToQueryReplies(responses, query);
        try {
            for (QueryReply queryReply : iterable) {
                this.sendQueryReply(queryReply);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return true;
    }

    private final boolean isConnectedTo(QueryRequest query, ReplyHandler handler) {
        return query.matchesReplyAddress(handler.getInetAddress().getAddress());
    }

    @Override
    protected List<QueryReply> createQueryReply(byte[] guid, byte ttl, long speed, Response[] res, byte[] clientGUID, boolean busy, boolean uploaded, boolean measuredSpeed, boolean isFromMcast, boolean isFWTransfer, SecurityToken securityToken) {
        Set<Connectable> proxies;
        String xmlCollectionString;
        ArrayList<QueryReply> queryReplies = new ArrayList<QueryReply>();
        QueryReply queryReply = null;
        int port = -1;
        byte[] ip = null;
        if (isFromMcast) {
            ip = this.networkManager.getNonForcedAddress();
            port = this.networkManager.getNonForcedPort();
            if (!NetworkUtils.isValidPort(port) || !NetworkUtils.isValidAddress(ip)) {
                isFromMcast = false;
            }
        }
        if (!isFromMcast) {
            if (isFWTransfer) {
                port = this.udpService.getStableUDPPort();
                ip = this.networkManager.getExternalAddress();
                if (!NetworkUtils.isValidAddress(ip) || !NetworkUtils.isValidPort(port)) {
                    isFWTransfer = false;
                }
            }
            if (!isFWTransfer) {
                ip = this.networkManager.getAddress();
                port = this.networkManager.getPort();
                if (!NetworkUtils.isValidAddress(ip) || !NetworkUtils.isValidPort(port)) {
                    return Collections.emptyList();
                }
            }
        }
        if ((xmlCollectionString = LimeXMLDocumentHelper.getAggregateString(res)) == null) {
            xmlCollectionString = "";
        }
        byte[] xmlBytes = null;
        try {
            xmlBytes = xmlCollectionString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ueex) {
            throw new IllegalStateException(ueex);
        }
        boolean notIncoming = !this.networkManager.acceptedIncomingConnection();
        Set<Connectable> set = proxies = notIncoming ? this.connectionManager.getPushProxies() : null;
        if (xmlBytes.length > 32768) {
            LinkedList<Response[]> splitResps = new LinkedList<Response[]>();
            this.splitAndAddResponses(splitResps, res);
            while (!splitResps.isEmpty()) {
                Response[] currResps = (Response[])splitResps.remove(0);
                String currXML = LimeXMLDocumentHelper.getAggregateString(currResps);
                byte[] currXMLBytes = null;
                try {
                    currXMLBytes = currXML.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException ueex) {
                    throw new IllegalStateException(ueex);
                }
                if (currXMLBytes.length > 32768 && currResps.length > 1) {
                    this.splitAndAddResponses(splitResps, currResps);
                    continue;
                }
                byte[] xmlCompressed = null;
                xmlCompressed = !currXML.equals("") ? LimeXMLUtils.compress(currXMLBytes) : DataUtils.EMPTY_BYTE_ARRAY;
                queryReply = this.queryReplyFactory.createQueryReply(guid, ttl, port, ip, speed, currResps, this._clientGUID, xmlCompressed, notIncoming, busy, uploaded, measuredSpeed, ChatSettings.CHAT_ENABLED.getValue(), isFromMcast, isFWTransfer, proxies, securityToken);
                queryReplies.add(queryReply);
            }
        } else {
            byte[] xmlCompressed = null;
            xmlCompressed = !xmlCollectionString.equals("") ? LimeXMLUtils.compress(xmlBytes) : DataUtils.EMPTY_BYTE_ARRAY;
            queryReply = this.queryReplyFactory.createQueryReply(guid, ttl, port, ip, speed, res, this._clientGUID, xmlCompressed, notIncoming, busy, uploaded, measuredSpeed, ChatSettings.CHAT_ENABLED.getValue(), isFromMcast, isFWTransfer, proxies, securityToken);
            queryReplies.add(queryReply);
        }
        return queryReplies;
    }

    private Response[][] splitResponses(Response[] in) {
        int i;
        int middle = in.length / 2;
        Response[][] retResps = new Response[][]{new Response[middle], new Response[in.length - middle]};
        for (i = 0; i < middle; ++i) {
            retResps[0][i] = in[i];
        }
        for (i = 0; i < in.length - middle; ++i) {
            retResps[1][i] = in[i + middle];
        }
        return retResps;
    }

    private void splitAndAddResponses(List<Response[]> addTo, Response[] toSplit) {
        Response[][] splits = this.splitResponses(toSplit);
        addTo.add(splits[0]);
        addTo.add(splits[1]);
    }
}

