/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.settings.ApplicationSettings;
import org.limewire.util.Clock;

@Singleton
public class Statistics {
    private final Clock clock;
    private static final int SECONDS_PER_DAY = 86400;
    private static final int WINDOW_MILLISECONDS = 604800000;
    private long startTime;

    @Inject
    Statistics(Clock clock) {
        this.clock = clock;
        this.startTime = clock.now();
    }

    public long getUptime() {
        return this.clock.now() - this.startTime;
    }

    public int calculateDailyUptime() {
        return (int)(this.calculateFractionalUptime() * 86400.0f);
    }

    public float calculateFractionalUptime() {
        float W = 6.048E8f;
        float T = Math.min(6.048E8f, (float)(this.clock.now() - ApplicationSettings.LAST_SHUTDOWN_TIME.getValue()));
        float t = Math.min(6.048E8f, (float)this.getUptime());
        float P = ApplicationSettings.FRACTIONAL_UPTIME.getValue();
        if (t < 0.0f || T < 0.0f || t > T) {
            return P;
        }
        return t / 6.048E8f + (6.048E8f - T) / 6.048E8f * P;
    }

    public void shutdown() {
        ApplicationSettings.FRACTIONAL_UPTIME.setValue(this.calculateFractionalUptime());
        ApplicationSettings.LAST_SHUTDOWN_TIME.setValue(this.clock.now());
        int sessions = ApplicationSettings.SESSIONS.getValue();
        ApplicationSettings.SESSIONS.setValue(sessions + 1);
    }
}

