/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.UDPReplyHandlerCache;
import com.limegroup.gnutella.UDPReplyHandlerFactory;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.filters.SpamFilterFactory;
import java.net.InetSocketAddress;
import org.limewire.collection.FixedsizeForgetfulHashMap;
import org.limewire.concurrent.AbstractLazySingletonProvider;
import org.limewire.inject.Providers;

@Singleton
public class UDPReplyHandlerCacheImpl
implements UDPReplyHandlerCache {
    private final UDPReplyHandlerFactory udpReplyHandlerFactory;
    private volatile Provider<SpamFilter> personalFilter;
    private final FixedsizeForgetfulHashMap<InetSocketAddress, UDPReplyHandler> udpReplyHandlerCache = new FixedsizeForgetfulHashMap(500);

    @Inject
    public UDPReplyHandlerCacheImpl(UDPReplyHandlerFactory udpReplyHandlerFactory, final SpamFilterFactory spamFilterFactory) {
        this.udpReplyHandlerFactory = udpReplyHandlerFactory;
        this.personalFilter = new AbstractLazySingletonProvider<SpamFilter>(){

            @Override
            protected SpamFilter createObject() {
                return spamFilterFactory.createPersonalFilter();
            }
        };
    }

    public synchronized UDPReplyHandler getUDPReplyHandler(InetSocketAddress addr) {
        UDPReplyHandler handler = (UDPReplyHandler)this.udpReplyHandlerCache.get(addr);
        if (handler == null) {
            handler = this.udpReplyHandlerFactory.createUDPReplyHandler(addr, this.personalFilter.get());
            this.udpReplyHandlerCache.put(addr, handler);
        }
        return handler;
    }

    public synchronized void setPersonalFilter(SpamFilter personalFilter) {
        if (personalFilter == null) {
            throw new NullPointerException("personalFiter must not be null");
        }
        this.personalFilter = Providers.of(personalFilter);
        this.clear();
    }

    public SpamFilter getPersonalFilter() {
        return this.personalFilter.get();
    }

    public synchronized void clear() {
        this.udpReplyHandlerCache.clear();
    }
}

