/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.UDPReplyHandlerFactory;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.filters.SpamFilter;
import java.net.InetAddress;
import java.net.InetSocketAddress;

@Singleton
public class UDPReplyHandlerFactoryImpl
implements UDPReplyHandlerFactory {
    private final UDPService udpService;

    @Inject
    public UDPReplyHandlerFactoryImpl(UDPService udpService) {
        this.udpService = udpService;
    }

    public UDPReplyHandler createUDPReplyHandler(InetSocketAddress addr, SpamFilter personalFilter) {
        return new UDPReplyHandler(addr, personalFilter, this.udpService);
    }

    public UDPReplyHandler createUDPReplyHandler(InetAddress addr, int port, SpamFilter personalFilter) {
        return new UDPReplyHandler(addr, port, personalFilter, this.udpService);
    }
}

