/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.LifecycleManager;
import com.limegroup.gnutella.UPnPListener;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.Argument;
import org.cybergarage.upnp.ControlPoint;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.DeviceList;
import org.cybergarage.upnp.Service;
import org.cybergarage.upnp.device.DeviceChangeListener;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.NetworkUtils;
import org.limewire.service.ErrorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class UPnPManager {
    private static final Log LOG = LogFactory.getLog(UPnPManager.class);
    private static final String ROUTER_DEVICE = "urn:schemas-upnp-org:device:InternetGatewayDevice:1";
    private static final String WAN_DEVICE = "urn:schemas-upnp-org:device:WANDevice:1";
    private static final String WANCON_DEVICE = "urn:schemas-upnp-org:device:WANConnectionDevice:1";
    private static final String SERVICE_TYPE = "urn:schemas-upnp-org:service:WANIPConnection:1";
    private static final String TCP_PREFIX = "LimeTCP";
    private static final String UDP_PREFIX = "LimeUDP";
    private String _guidSuffix;
    private volatile Device _router;
    private volatile Service _service;
    private volatile Mapping _tcp;
    private volatile Mapping _udp;
    private final Object DEVICE_LOCK = new Object();
    private final LifecycleManager lifecycleManager;
    private final Provider<Acceptor> acceptor;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final ControlPoint controlPoint;
    private final CopyOnWriteArrayList<UPnPListener> listeners = new CopyOnWriteArrayList();
    @InspectablePrimitive(value="upnp manager creation time")
    private final long creationTime = System.currentTimeMillis();
    @InspectablePrimitive(value="upnp manager start time")
    private volatile long startTime;
    @InspectablePrimitive(value="upnp manager device found time")
    private volatile long deviceFoundTime;
    @InspectionPoint(value="upnp stats")
    private final Inspectable UPnPStats = new Inspectable(){

        public Object inspect() {
            if (!UPnPManager.this.isNATPresent()) {
                return "N/A";
            }
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("name", UPnPManager.this._router.getFriendlyName());
            if (UPnPManager.this.mappingsExist()) {
                ret.put("mappings", true);
            }
            return ret;
        }
    };

    @Inject
    UPnPManager(LifecycleManager lifecycleManager, Provider<Acceptor> acceptor) {
        this.lifecycleManager = lifecycleManager;
        this.acceptor = acceptor;
        this.controlPoint = new ControlPoint();
    }

    public void addListener(UPnPListener uPnPListener) {
        this.listeners.add(uPnPListener);
    }

    private void notifyListeners() {
        for (UPnPListener listener : this.listeners) {
            listener.natFound();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this.started.getAndSet(true)) {
            this.startTime = System.currentTimeMillis();
            LOG.debug("Starting UPnP Manager.");
            this.controlPoint.addDeviceChangeListener(new DeviceListener());
            Object object = this.DEVICE_LOCK;
            synchronized (object) {
                try {
                    this.controlPoint.start();
                }
                catch (Exception bad) {
                    ConnectionSettings.DISABLE_UPNP.setValue(true);
                    ErrorService.error(bad);
                }
            }
        }
    }

    public void stop() {
        this.controlPoint.stop();
    }

    public boolean isNATPresent() {
        return this._router != null && this._service != null;
    }

    public boolean mappingsExist() {
        return this._tcp != null || this._udp != null;
    }

    public InetAddress getNATAddress() throws UnknownHostException {
        if (!this.isNATPresent()) {
            return null;
        }
        Action getIP = this._service.getAction("GetExternalIPAddress");
        if (getIP == null) {
            LOG.debug("Couldn't find GetExternalIPAddress action!");
            return null;
        }
        if (!getIP.postControlAction()) {
            LOG.debug("couldn't get our external address");
            return null;
        }
        Argument ret = getIP.getOutputArgumentList().getArgument("NewExternalIPAddress");
        return InetAddress.getByName(ret.getValue());
    }

    private void discoverService() {
        for (Device current : this._router.getDeviceList()) {
            if (!current.getDeviceType().equals(WAN_DEVICE)) continue;
            DeviceList l = current.getDeviceList();
            if (LOG.isDebugEnabled()) {
                LOG.debug("found " + current.getDeviceType() + ", size: " + l.size() + ", on: " + current.getFriendlyName());
            }
            for (int i = 0; i < current.getDeviceList().size(); ++i) {
                Device current2 = l.getDevice(i);
                if (!current2.getDeviceType().equals(WANCON_DEVICE)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("found " + current2.getDeviceType() + ", on: " + current2.getFriendlyName());
                }
                this._service = current2.getService(SERVICE_TYPE);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int mapPort(int port) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Attempting to map port: " + port);
        }
        Random gen = null;
        String localAddress = NetworkUtils.ip2string(this.acceptor.get().getAddress(false));
        int localPort = port;
        Mapping udp = new Mapping("", port, localAddress, localPort, "UDP", UDP_PREFIX + this.getGUIDSuffix());
        int tries = 20;
        while (!this.addMapping(udp) && tries >= 0) {
            --tries;
            if (gen == null) {
                gen = new Random();
            }
            port = gen.nextInt(50000) + 2000;
            udp = new Mapping("", port, localAddress, localPort, "UDP", UDP_PREFIX + this.getGUIDSuffix());
        }
        if (tries < 0) {
            LOG.debug("couldn't map a port :(");
            return 0;
        }
        Mapping tcp = new Mapping("", port, localAddress, localPort, "TCP", TCP_PREFIX + this.getGUIDSuffix());
        if (!this.addMapping(tcp)) {
            LOG.debug(" couldn't map tcp to whatever udp was mapped. leaving udp around...");
            tcp = null;
        }
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            this._tcp = tcp;
            this._udp = udp;
        }
        ThreadExecutor.startThread(new StaleCleaner(), "Stale Mapping Cleaner");
        return port;
    }

    private boolean addMapping(Mapping m) {
        Action add;
        if (LOG.isDebugEnabled()) {
            LOG.debug("adding " + m);
        }
        if ((add = this._service.getAction("AddPortMapping")) == null) {
            LOG.debug("Couldn't find AddPortMapping action!");
            return false;
        }
        add.setArgumentValue("NewRemoteHost", m._externalAddress);
        add.setArgumentValue("NewExternalPort", m._externalPort);
        add.setArgumentValue("NewInternalClient", m._internalAddress);
        add.setArgumentValue("NewInternalPort", m._internalPort);
        add.setArgumentValue("NewProtocol", m._protocol);
        add.setArgumentValue("NewPortMappingDescription", m._description);
        add.setArgumentValue("NewEnabled", "1");
        add.setArgumentValue("NewLeaseDuration", 0);
        boolean success = add.postControlAction();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Post succeeded: " + success);
        }
        return success;
    }

    private boolean removeMapping(Mapping m) {
        Action remove;
        if (LOG.isDebugEnabled()) {
            LOG.debug("removing " + m);
        }
        if ((remove = this._service.getAction("DeletePortMapping")) == null) {
            LOG.debug("Couldn't find DeletePortMapping action!");
            return false;
        }
        remove.setArgumentValue("NewRemoteHost", m._externalAddress);
        remove.setArgumentValue("NewExternalPort", m._externalPort);
        remove.setArgumentValue("NewProtocol", m._protocol);
        boolean success = remove.postControlAction();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Remove succeeded: " + success);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMappingsOnShutdown() {
        Mapping udp;
        Mapping tcp;
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            tcp = this._tcp;
            udp = this._udp;
        }
        Thread waiter = new Thread("UPnP Waiter"){

            public void run() {
                Thread cleaner = new Thread("UPnP Cleaner"){

                    public void run() {
                        LOG.debug("start cleaning");
                        if (tcp != null) {
                            UPnPManager.this.removeMapping(tcp);
                        }
                        if (udp != null) {
                            UPnPManager.this.removeMapping(udp);
                        }
                        LOG.debug("done cleaning");
                    }
                };
                cleaner.setDaemon(true);
                cleaner.start();
                Thread.yield();
                try {
                    LOG.debug("waiting for UPnP cleaners to finish");
                    cleaner.join(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                LOG.debug("UPnP cleaners done");
            }
        };
        this.lifecycleManager.addShutdownItem(waiter);
    }

    public void finalize() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGUIDSuffix() {
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            if (this._guidSuffix == null) {
                this._guidSuffix = ApplicationSettings.CLIENT_ID.getValue().substring(0, 10);
            }
            return this._guidSuffix;
        }
    }

    private class StaleCleaner
    implements Runnable {
        private StaleCleaner() {
        }

        private String list(List l) {
            String s = "";
            for (Argument next : l) {
                s = s + next.getName() + "->" + next.getValue() + ", ";
            }
            return s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LOG.debug("Looking for stale mappings...");
            HashSet<Mapping> mappings = new HashSet<Mapping>();
            Action getGeneric = UPnPManager.this._service.getAction("GetGenericPortMappingEntry");
            if (getGeneric == null) {
                LOG.debug("Couldn't find GetGenericPortMappingEntry action!");
                return;
            }
            try {
                int i = 0;
                while (true) {
                    getGeneric.setArgumentValue("NewPortMappingIndex", i);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Stale Iteration: " + i + ", generic.input: " + this.list(getGeneric.getInputArgumentList()) + ", generic.output: " + this.list(getGeneric.getOutputArgumentList()));
                    }
                    if (getGeneric.postControlAction()) {
                        mappings.add(new Mapping(getGeneric.getArgumentValue("NewRemoteHost"), getGeneric.getArgumentValue("NewExternalPort"), getGeneric.getArgumentValue("NewInternalClient"), getGeneric.getArgumentValue("NewInternalPort"), getGeneric.getArgumentValue("NewProtocol"), getGeneric.getArgumentValue("NewPortMappingDescription")));
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (NumberFormatException bad) {
                LOG.error("NFE reading mappings!", bad);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stale cleaner found " + mappings.size() + " total mappings");
            }
            for (Mapping current : mappings) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Analyzing: " + current);
                }
                if (current._description == null || current._internalAddress == null || !current._description.equals(UPnPManager.TCP_PREFIX + UPnPManager.this.getGUIDSuffix()) && !current._description.equals(UPnPManager.UDP_PREFIX + UPnPManager.this.getGUIDSuffix())) continue;
                Object object = UPnPManager.this.DEVICE_LOCK;
                synchronized (object) {
                    if (UPnPManager.this._udp != null && current._externalPort == ((UPnPManager)UPnPManager.this)._udp._externalPort && current._internalAddress.equals(((UPnPManager)UPnPManager.this)._udp._internalAddress) && current._internalPort == ((UPnPManager)UPnPManager.this)._udp._internalPort) {
                        continue;
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("mapping " + current + " appears to be stale");
                }
                UPnPManager.this.removeMapping(current);
            }
        }
    }

    private final class Mapping {
        public final String _externalAddress;
        public final int _externalPort;
        public final String _internalAddress;
        public final int _internalPort;
        public final String _protocol;
        public final String _description;

        public Mapping(String externalAddress, String externalPort, String internalAddress, String internalPort, String protocol, String description) throws NumberFormatException {
            this._externalAddress = externalAddress;
            this._externalPort = Integer.parseInt(externalPort);
            this._internalAddress = internalAddress;
            this._internalPort = Integer.parseInt(internalPort);
            this._protocol = protocol;
            this._description = description;
        }

        public Mapping(String externalAddress, int externalPort, String internalAddress, int internalPort, String protocol, String description) {
            if (!NetworkUtils.isValidPort(externalPort) || !NetworkUtils.isValidPort(internalPort)) {
                throw new IllegalArgumentException();
            }
            this._externalAddress = externalAddress;
            this._externalPort = externalPort;
            this._internalAddress = internalAddress;
            this._internalPort = internalPort;
            this._protocol = protocol;
            this._description = description;
        }

        public String toString() {
            return this._externalAddress + ":" + this._externalPort + "->" + this._internalAddress + ":" + this._internalPort + "@" + this._protocol + " desc: " + this._description;
        }
    }

    private class DeviceListener
    implements DeviceChangeListener {
        private DeviceListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deviceAdded(Device dev) {
            if (UPnPManager.this.isNATPresent()) {
                return;
            }
            UPnPManager.this.deviceFoundTime = System.currentTimeMillis();
            Object object = UPnPManager.this.DEVICE_LOCK;
            synchronized (object) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Device added: " + dev.getFriendlyName());
                }
                if (dev.getDeviceType().equals(UPnPManager.ROUTER_DEVICE) && dev.isRootDevice()) {
                    UPnPManager.this._router = dev;
                }
                if (UPnPManager.this._router != null) {
                    UPnPManager.this.discoverService();
                    if (UPnPManager.this._service == null) {
                        LOG.debug("couldn't find service");
                        UPnPManager.this._router = null;
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Found service, router: " + UPnPManager.this._router.getFriendlyName() + ", service: " + UPnPManager.this._service);
                        }
                        UPnPManager.this.stop();
                    }
                } else {
                    LOG.debug("didn't get router device");
                }
            }
            if (UPnPManager.this.isNATPresent()) {
                UPnPManager.this.notifyListeners();
            }
        }

        public void deviceRemoved(Device dev) {
        }
    }
}

