/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.UrnType;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.security.MerkleTree;
import com.limegroup.gnutella.security.SHA1;
import com.limegroup.gnutella.security.Tiger;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.limewire.io.IOUtils;
import org.limewire.util.Base32;
import org.limewire.util.SystemUtils;

public final class URN
implements HTTPHeaderValue,
Serializable {
    private static final long serialVersionUID = -6053855548211564799L;
    public static final Set<URN> NO_URN_SET = Collections.emptySet();
    public static final URN INVALID = new URN("bad:bad", Type.INVALID);
    public static final int MIN_IDLE_TIME = 300000;
    private static final String SPACE = " ";
    private static final String QUESTION_MARK = "?";
    private static final String SLASH = "/";
    private static final String TWO = "2";
    private static final String DOT = ".";
    private transient String _urnString;
    private transient Type _urnType;
    private volatile transient int hashCode = 0;
    private static final Map<File, AtomicInteger> progressMap = Collections.synchronizedMap(new HashMap());
    private static final ThreadLocal<byte[]> threadLocal = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[65536];
        }
    };

    public static int getHashingProgress(File file) {
        AtomicInteger progress = progressMap.get(file);
        if (progress == null) {
            return -1;
        }
        return progress.get();
    }

    public static URN createSHA1Urn(File file) throws IOException, InterruptedException {
        return URN.createSHA1AndTTRootUrns(file).getSHA1();
    }

    public static URN createSHA1Urn(String urnString) throws IOException {
        String typeString = URN.getTypeString(urnString).toLowerCase(Locale.US);
        if (typeString.indexOf(Type.SHA1.getDescriptor()) == 4) {
            return URN.createUrnFromString(urnString);
        }
        if (typeString.indexOf(Type.BITPRINT.getDescriptor()) == 4) {
            return URN.createSHA1UrnFromBitprint(urnString);
        }
        throw new IOException("unsupported or malformed URN");
    }

    public static URN createGUIDUrn(String urnString) throws IOException {
        URN urn = URN.createUrnFromString(urnString);
        if (urn.getUrnType() != Type.GUID) {
            throw new IOException("Not a GUID urn: " + urnString);
        }
        return urn;
    }

    public static URN createGUIDUrn(GUID guid) {
        return new URN("urn:" + Type.GUID.getDescriptor() + guid.toHexString(), Type.GUID);
    }

    public static URN createTTRootUrn(String urnString) throws IOException {
        String typeString = URN.getTypeString(urnString).toLowerCase(Locale.US);
        if (typeString.indexOf(Type.TTROOT.getDescriptor()) == 4) {
            return new URN(urnString, Type.TTROOT);
        }
        throw new IOException("unsupported or malformed URN");
    }

    public static String getTigerTreeRoot(String urnString) throws IOException {
        String typeString = URN.getTypeString(urnString).toLowerCase(Locale.US);
        if (typeString.indexOf(Type.BITPRINT.getDescriptor()) == 4) {
            return URN.getTTRootFromBitprint(urnString);
        }
        throw new IOException("unsupported or malformed URN");
    }

    public static URN createSHA1UrnFromURL(URL url) throws IOException {
        return URN.createSHA1UrnFromUriRes(url.getFile());
    }

    public static URN createSHA1UrnFromUriRes(String sha1String) throws IOException {
        sha1String.trim();
        if (URN.isValidUriResSHA1Format(sha1String)) {
            return URN.createUrnFromString(sha1String.substring(13));
        }
        throw new IOException("could not parse string format: " + sha1String);
    }

    public static URN createSHA1UrnFromHttpRequest(String requestLine) throws IOException {
        if (!URN.isValidUrnHttpRequest(requestLine)) {
            throw new IOException("INVALID URN HTTP REQUEST");
        }
        String urnString = URN.extractUrnFromHttpRequest(requestLine);
        if (urnString == null) {
            throw new IOException("COULD NOT CONSTRUCT URN");
        }
        return URN.createSHA1Urn(urnString);
    }

    public static URN createSHA1UrnFromBytes(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length != 20) {
            throw new IOException("invalid bytes!");
        }
        String hash = Base32.encode(bytes);
        return URN.createUrnFromString("urn:sha1:" + hash);
    }

    public static URN createTTRootFromBytes(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length != 24) {
            throw new IOException("invalid bytes!");
        }
        String hash = Base32.encode(bytes);
        return new URN("urn:" + Type.TTROOT.getDescriptor() + hash, Type.TTROOT);
    }

    private static URN createUrnFromString(String urnString) throws IOException {
        if (!URN.isValidUrn(urnString)) {
            throw new IOException("invalid urn string: " + urnString);
        }
        String typeString = URN.getTypeString(urnString);
        Type type = Type.createUrnType(typeString);
        if (type == null) {
            throw new IOException("urn type not recognized: " + typeString);
        }
        return new URN(urnString, type);
    }

    private static URN createSHA1UrnFromBitprint(String bitprintString) throws IOException {
        int dotIdx = bitprintString.indexOf(DOT);
        if (dotIdx == -1) {
            throw new IOException("invalid bitprint: " + bitprintString);
        }
        String sha1 = bitprintString.substring(bitprintString.indexOf(58, 4) + 1, dotIdx);
        return URN.createUrnFromString("urn:" + Type.SHA1.getDescriptor() + sha1);
    }

    private static String getTTRootFromBitprint(String bitprintString) throws IOException {
        int dotIdx = bitprintString.indexOf(DOT);
        if (dotIdx == -1 || dotIdx == bitprintString.length() - 1) {
            throw new IOException("invalid bitprint: " + bitprintString);
        }
        String tt = bitprintString.substring(dotIdx + 1);
        if (tt.length() != 39) {
            throw new IOException("wrong length: " + tt.length());
        }
        return tt;
    }

    private URN(String urnString, Type urnType) {
        int lastColon = urnString.lastIndexOf(":");
        String nameSpace = urnString.substring(0, lastColon + 1);
        String hash = urnString.substring(lastColon + 1);
        this._urnString = nameSpace.toLowerCase(Locale.US) + hash.toUpperCase(Locale.US);
        this._urnType = urnType;
    }

    public byte[] getBytes() {
        return Base32.decode(this.getNamespaceSpecificString());
    }

    public String getNamespaceSpecificString() {
        return this._urnString.substring(this._urnString.lastIndexOf(58) + 1);
    }

    public Type getUrnType() {
        return this._urnType;
    }

    public String httpStringValue() {
        return this._urnString;
    }

    public static boolean isUrn(String urnString) {
        return URN.isValidUrn(urnString);
    }

    public boolean isSHA1() {
        return this._urnType == Type.SHA1;
    }

    public boolean isTTRoot() {
        return this._urnType == Type.TTROOT;
    }

    public boolean isGUID() {
        return this._urnType == Type.GUID;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof URN)) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        URN urn = (URN)o;
        return this._urnString.equals(urn._urnString) && this._urnType.equals((Object)urn._urnType);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this._urnString.hashCode();
            this.hashCode = result = 37 * result + this._urnType.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this._urnString;
    }

    private static boolean isValidUriResSHA1Format(String sha1String) {
        String copy = sha1String.toLowerCase(Locale.US);
        if (copy.startsWith("/uri-res/n2r?urn:sha1:")) {
            return sha1String.length() == 54;
        }
        return false;
    }

    private static String extractUrnFromHttpRequest(String requestLine) {
        int qIndex = requestLine.indexOf(QUESTION_MARK) + 1;
        int spaceIndex = requestLine.indexOf(SPACE, qIndex);
        if (qIndex == -1 || spaceIndex == -1) {
            return null;
        }
        return requestLine.substring(qIndex, spaceIndex);
    }

    private static boolean isValidUrnHttpRequest(String requestLine) {
        return URN.isValidLength(requestLine) && URN.isValidUriRes(requestLine) && URN.isValidResolutionProtocol(requestLine) && URN.isValidHTTPSpecifier(requestLine);
    }

    private static final boolean isValidLength(String requestLine) {
        int size = requestLine.length();
        return size == 63 || size == 107;
    }

    private static final boolean isValidUriRes(String requestLine) {
        int firstSlash = requestLine.indexOf(SLASH);
        if (firstSlash == -1 || firstSlash == requestLine.length()) {
            return false;
        }
        int secondSlash = requestLine.indexOf(SLASH, firstSlash + 1);
        if (secondSlash == -1) {
            return false;
        }
        String uriStr = requestLine.substring(firstSlash + 1, secondSlash);
        return uriStr.equalsIgnoreCase("uri-res");
    }

    private static boolean isValidResolutionProtocol(String requestLine) {
        int nIndex = requestLine.indexOf(TWO);
        if (nIndex == -1) {
            return false;
        }
        String n2s = requestLine.substring(nIndex - 1, nIndex + 3);
        return n2s.equalsIgnoreCase("N2R?") || n2s.equalsIgnoreCase("N2X?");
    }

    private static boolean isValidHTTPSpecifier(String requestLine) {
        int spaceIndex = requestLine.lastIndexOf(SPACE);
        if (spaceIndex == -1) {
            return false;
        }
        String httpStr = requestLine.substring(spaceIndex + 1);
        return httpStr.equalsIgnoreCase("HTTP/1.0") || httpStr.equalsIgnoreCase("HTTP/1.1");
    }

    private static String getTypeString(String fullUrnString) throws IOException {
        String type = fullUrnString.trim();
        if (type.length() <= 4) {
            throw new IOException("no type string");
        }
        return type.substring(0, type.indexOf(58, 4) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UrnSet createSHA1AndTTRootUrns(File file) throws IOException, InterruptedException {
        SHA1 md = new SHA1();
        MerkleTree tt = new MerkleTree(new Tiger());
        byte[] buffer = threadLocal.get();
        AtomicInteger progress = new AtomicInteger(0);
        progressMap.put(file, progress);
        FileInputStream fis = null;
        try {
            int read;
            fis = new FileInputStream(file);
            while ((read = ((InputStream)fis).read(buffer)) != -1) {
                long start = System.nanoTime();
                md.update(buffer, 0, read);
                tt.update(buffer, 0, read);
                progress.addAndGet(read);
                if (SystemUtils.getIdleTime() >= 300000L || !SharingSettings.FRIENDLY_HASHING.getValue()) continue;
                long interval = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
                if (interval > 0L) {
                    Thread.sleep(interval * 3L);
                    continue;
                }
                Thread.yield();
            }
        }
        finally {
            progressMap.remove(file);
            IOUtils.close(fis);
        }
        UrnSet ret = new UrnSet();
        URN sha1 = new URN("urn:" + Type.SHA1.getDescriptor() + Base32.encode(md.digest()), Type.SHA1);
        URN ttroot = new URN("urn:" + Type.TTROOT.getDescriptor() + Base32.encode(tt.digest()), Type.TTROOT);
        ret.add(sha1);
        ret.add(ttroot);
        return ret;
    }

    private static boolean isValidUrn(String urnString) {
        int colon1Index = urnString.indexOf(":");
        if (colon1Index == -1 || colon1Index + 1 > urnString.length()) {
            return false;
        }
        int urnIndex1 = colon1Index - 3;
        int urnIndex2 = colon1Index + 1;
        if (urnIndex1 < 0 || urnIndex2 < 0) {
            return false;
        }
        int colon2Index = urnString.indexOf(":", colon1Index + 1);
        if (colon2Index == -1 || colon2Index + 1 > urnString.length()) {
            return false;
        }
        String urnType = urnString.substring(0, colon2Index + 1);
        Type type = Type.createUrnType(urnType);
        if (type == null) {
            return false;
        }
        return type.getLength() == urnString.substring(colon2Index + 1).length();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeUTF(this._urnString);
        s.writeObject((Object)this._urnType);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._urnString = s.readUTF();
        Object type = s.readObject();
        if (type instanceof UrnType) {
            type = Type.createFromDescriptor(((UrnType)type).getType());
        }
        this._urnType = (Type)((Object)type);
        if (this._urnType != Type.SHA1 && this._urnType != Type.TTROOT) {
            throw new InvalidObjectException("invalid urn type: " + type);
        }
        if (!URN.isValidUrn(this._urnString)) {
            throw new InvalidObjectException("invalid urn: " + this._urnString);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SHA1("sha1:", 32),
        BITPRINT("bitprint:", 72),
        TTROOT("ttroot:", 39),
        ANY_TYPE("", -1),
        INVALID("Invalid", -1),
        GUID("guid:", 32);

        private final String descriptor;
        private final int length;
        public static final Set<Type> SHA1_SET;
        public static final Set<Type> ANY_TYPE_SET;
        public static final Set<Type> NO_TYPE_SET;
        public static final String URN_NAMESPACE_ID = "urn:";

        private Type(String descriptor, int length) {
            this.descriptor = descriptor;
            this.length = length;
        }

        public String getDescriptor() {
            return this.descriptor;
        }

        public int getLength() {
            return this.length;
        }

        public String toString() {
            return URN_NAMESPACE_ID + this.descriptor;
        }

        static Type createFromDescriptor(String desc) {
            desc = desc.toLowerCase(Locale.US).trim();
            for (Type type : Type.values()) {
                if (!type.descriptor.equals(desc)) continue;
                return type;
            }
            return null;
        }

        public static Type createUrnType(String value) {
            value = value.toLowerCase(Locale.US).trim();
            for (Type type : Type.values()) {
                if (!type.toString().equals(value)) continue;
                return type;
            }
            return null;
        }

        public static boolean isSupportedUrnType(String value) {
            return Type.createUrnType(value) != null;
        }

        static {
            SHA1_SET = EnumSet.of(SHA1);
            ANY_TYPE_SET = EnumSet.of(ANY_TYPE);
            NO_TYPE_SET = EnumSet.noneOf(Type.class);
        }
    }
}

