/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.google.inject.Singleton;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AbstractAlternateLocation;
import com.limegroup.gnutella.altlocs.AltLocListener;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.util.ClassCNetworks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class AltLocManager {
    private static final Log LOG = LogFactory.getLog(AltLocManager.class);
    private final Map<URN, URNData> urnMap = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(AlternateLocation al, Object source) {
        URNData data;
        if (LOG.isTraceEnabled()) {
            LOG.trace("alternate location added: " + al);
        }
        URN sha1 = al.getSHA1Urn();
        AlternateLocationCollection<DirectAltLoc> dCol = null;
        AlternateLocationCollection<PushAltLoc> pCol = null;
        Object object = this.urnMap;
        synchronized (object) {
            data = this.urnMap.get(sha1);
            if (data == null) {
                data = new URNData();
                this.urnMap.put(sha1, data);
            }
        }
        object = data;
        synchronized (object) {
            if (al instanceof DirectAltLoc) {
                if (data.direct == AlternateLocationCollection.EMPTY) {
                    data.direct = AlternateLocationCollection.create(sha1);
                }
                dCol = data.direct;
            } else if (al instanceof PushAltLoc) {
                PushAltLoc push = (PushAltLoc)al;
                if (push.supportsFWTVersion() < 1) {
                    if (data.push == AlternateLocationCollection.EMPTY) {
                        data.push = AlternateLocationCollection.create(sha1);
                    }
                    pCol = data.push;
                } else {
                    if (data.fwt == AlternateLocationCollection.EMPTY) {
                        data.fwt = AlternateLocationCollection.create(sha1);
                    }
                    pCol = data.fwt;
                }
            } else {
                throw new IllegalStateException("unknown loc class: " + al.getClass());
            }
        }
        boolean ret = false;
        if (dCol != null) {
            ret = dCol.add((DirectAltLoc)al);
        } else if (pCol != null) {
            ret = pCol.add((PushAltLoc)al);
        } else {
            throw new IllegalStateException("didn't set a collection!");
        }
        for (AltLocListener listener : data.getListeners()) {
            if (listener == source) continue;
            listener.locationAdded(al);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(AlternateLocation al, Object source) {
        URN sha1 = al.getSHA1Urn();
        URNData data = this.urnMap.get(sha1);
        if (data == null) {
            return false;
        }
        AlternateLocationCollection<DirectAltLoc> dCol = null;
        AlternateLocationCollection<PushAltLoc> pCol = null;
        URNData uRNData = data;
        synchronized (uRNData) {
            if (al instanceof DirectAltLoc) {
                dCol = data.direct;
            } else {
                PushAltLoc push = (PushAltLoc)al;
                pCol = push.supportsFWTVersion() < 1 ? data.push : data.fwt;
            }
        }
        AlternateLocationCollection<AbstractAlternateLocation> col = null;
        boolean ret = false;
        if (dCol != null) {
            ret = dCol.remove((DirectAltLoc)al);
            col = dCol;
        } else if (pCol != null) {
            ret = pCol.remove((PushAltLoc)al);
            col = pCol;
        } else {
            return false;
        }
        if (!col.hasAlternateLocations()) {
            this.removeIfEmpty(sha1, data);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIfEmpty(URN sha1, URNData data) {
        boolean empty = false;
        URNData uRNData = data;
        synchronized (uRNData) {
            if (!data.direct.hasAlternateLocations() && !data.push.hasAlternateLocations() && !data.fwt.hasAlternateLocations() && data.getListeners().isEmpty()) {
                empty = true;
            }
        }
        if (empty) {
            this.urnMap.remove(sha1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlternateLocationCollection<DirectAltLoc> getDirect(URN sha1) {
        URNData data = this.urnMap.get(sha1);
        if (data == null) {
            return AlternateLocationCollection.getEmptyCollection();
        }
        URNData uRNData = data;
        synchronized (uRNData) {
            return data.direct;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlternateLocationCollection<PushAltLoc> getPushNoFWT(URN sha1) {
        URNData data = this.urnMap.get(sha1);
        if (data == null) {
            return AlternateLocationCollection.getEmptyCollection();
        }
        URNData uRNData = data;
        synchronized (uRNData) {
            return data.push;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlternateLocationCollection<PushAltLoc> getPushFWT(URN sha1) {
        URNData data = this.urnMap.get(sha1);
        if (data == null) {
            return AlternateLocationCollection.getEmptyCollection();
        }
        URNData uRNData = data;
        synchronized (uRNData) {
            return data.fwt;
        }
    }

    public void purge() {
        this.urnMap.clear();
    }

    public void purge(URN sha1) {
        this.urnMap.remove(sha1);
    }

    public boolean hasAltlocs(URN sha1) {
        URNData data = this.urnMap.get(sha1);
        if (data == null) {
            return false;
        }
        return data.hasAltLocs();
    }

    public int getNumLocs(URN sha1) {
        URNData data = this.urnMap.get(sha1);
        if (data == null) {
            return 0;
        }
        return data.getNumLocs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(URN sha1, AltLocListener listener) {
        URNData data;
        Map<URN, URNData> map = this.urnMap;
        synchronized (map) {
            data = this.urnMap.get(sha1);
            if (data == null) {
                data = new URNData();
                this.urnMap.put(sha1, data);
            }
        }
        data.addListener(listener);
    }

    public void removeListener(URN sha1, AltLocListener listener) {
        URNData data = this.urnMap.get(sha1);
        if (data == null) {
            return;
        }
        data.removeListener(listener);
        this.removeIfEmpty(sha1, data);
    }

    @InspectableContainer
    private class ALMInspectables {
        @InspectionPoint(value="alternate locations class C stats")
        public final Inspectable classC = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object inspect() {
                ClassCNetworks direct = new ClassCNetworks();
                ClassCNetworks pushProxies = new ClassCNetworks();
                Map map = AltLocManager.this.urnMap;
                synchronized (map) {
                    for (URNData data : AltLocManager.this.urnMap.values()) {
                        for (DirectAltLoc dal : data.direct) {
                            direct.add(dal.getHost().getInetAddress(), 1);
                        }
                        for (PushAltLoc push : data.push) {
                            pushProxies.addAll(push.getPushAddress().getProxies());
                        }
                        for (PushAltLoc push : data.fwt) {
                            pushProxies.addAll(push.getPushAddress().getProxies());
                        }
                    }
                }
                HashMap<String, byte[]> ret = new HashMap<String, byte[]>();
                ret.put("direct", direct.getTopInspectable(10));
                ret.put("proxies", pushProxies.getTopInspectable(10));
                return ret;
            }
        };

        private ALMInspectables() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class URNData {
        public AlternateLocationCollection<DirectAltLoc> direct = AlternateLocationCollection.getEmptyCollection();
        public AlternateLocationCollection<PushAltLoc> push = AlternateLocationCollection.getEmptyCollection();
        public AlternateLocationCollection<PushAltLoc> fwt = AlternateLocationCollection.getEmptyCollection();
        private volatile List<AltLocListener> listeners = Collections.emptyList();

        private URNData() {
        }

        public synchronized boolean hasAltLocs() {
            return this.direct.hasAlternateLocations() || this.push.hasAlternateLocations() || this.fwt.hasAlternateLocations();
        }

        public synchronized int getNumLocs() {
            return this.direct.getAltLocsSize() + this.push.getAltLocsSize() + this.fwt.getAltLocsSize();
        }

        public synchronized void addListener(AltLocListener listener) {
            ArrayList<AltLocListener> updated = new ArrayList<AltLocListener>(this.listeners);
            updated.add(listener);
            this.listeners = updated;
        }

        public synchronized void removeListener(AltLocListener listener) {
            ArrayList<AltLocListener> updated = new ArrayList<AltLocListener>(this.listeners);
            updated.remove(listener);
            this.listeners = updated;
        }

        public List<AltLocListener> getListeners() {
            return this.listeners;
        }
    }
}

