/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AbstractAlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import java.io.IOException;
import java.util.Iterator;
import org.limewire.collection.FixedSizeSortedSet;
import org.limewire.service.ErrorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlternateLocationCollection<T extends AlternateLocation>
implements HTTPHeaderValue,
Iterable<T> {
    private static final int MAX_SIZE = 100;
    public static final AlternateLocationCollection EMPTY;
    private final FixedSizeSortedSet<T> LOCATIONS = new FixedSizeSortedSet(100);
    private final URN SHA1;

    public static <T extends AlternateLocation> AlternateLocationCollection<T> getEmptyCollection() {
        return EMPTY;
    }

    public static <T extends AlternateLocation> AlternateLocationCollection<T> create(URN sha1) {
        return new AlternateLocationCollection<T>(sha1);
    }

    private AlternateLocationCollection(URN sha1) {
        if (sha1 == null) {
            throw new NullPointerException("null URN");
        }
        if (!sha1.isSHA1()) {
            throw new IllegalArgumentException("URN must be a SHA1");
        }
        this.SHA1 = sha1;
    }

    public URN getSHA1Urn() {
        return this.SHA1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T al) {
        URN sha1 = al.getSHA1Urn();
        if (!sha1.equals(this.SHA1)) {
            throw new IllegalArgumentException("SHA1 does not match");
        }
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            AlternateLocation alt = (AlternateLocation)this.LOCATIONS.get(al);
            boolean ret = false;
            if (alt == null) {
                ret = true;
                this.LOCATIONS.add(al);
            } else {
                this.LOCATIONS.remove(alt);
                alt.increment();
                if (alt instanceof AbstractAlternateLocation) {
                    AbstractAlternateLocation absAlt = (AbstractAlternateLocation)alt;
                    absAlt.promote();
                    absAlt.resetSent();
                }
                ret = false;
                this.LOCATIONS.add(alt);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T al) {
        URN sha1 = al.getSHA1Urn();
        if (!sha1.equals(this.SHA1)) {
            return false;
        }
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            AlternateLocation loc = (AlternateLocation)this.LOCATIONS.get(al);
            if (loc == null) {
                return false;
            }
            if (loc.isDemoted()) {
                this.LOCATIONS.remove(loc);
                return true;
            }
            this.LOCATIONS.remove(loc);
            if (loc instanceof AbstractAlternateLocation) {
                AbstractAlternateLocation absAlt = (AbstractAlternateLocation)loc;
                absAlt.demote();
            }
            this.LOCATIONS.add(loc);
            return false;
        }
    }

    public synchronized void clear() {
        this.LOCATIONS.clear();
    }

    public synchronized boolean hasAlternateLocations() {
        return !this.LOCATIONS.isEmpty();
    }

    public synchronized boolean contains(AlternateLocation loc) {
        return this.LOCATIONS.contains(loc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String httpStringValue() {
        String commaSpace = ", ";
        StringBuilder writeBuffer = new StringBuilder();
        boolean wrote = false;
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            for (AlternateLocation current : this.LOCATIONS) {
                writeBuffer.append(current.httpStringValue());
                writeBuffer.append(", ");
                wrote = true;
            }
        }
        if (wrote) {
            writeBuffer.setLength(writeBuffer.length() - 2);
        }
        return writeBuffer.toString();
    }

    public synchronized int getAltLocsSize() {
        return this.LOCATIONS.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.LOCATIONS.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Alternate Locations: ");
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            for (AlternateLocation curLoc : this.LOCATIONS) {
                sb.append(curLoc.toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlternateLocationCollection)) {
            return false;
        }
        AlternateLocationCollection alc = (AlternateLocationCollection)o;
        boolean ret = this.SHA1.equals(alc.SHA1);
        if (!ret) {
            return false;
        }
        Class<AlternateLocationCollection> clazz = AlternateLocationCollection.class;
        synchronized (AlternateLocationCollection.class) {
            AlternateLocationCollection alternateLocationCollection = this;
            synchronized (alternateLocationCollection) {
                AlternateLocationCollection alternateLocationCollection2 = alc;
                synchronized (alternateLocationCollection2) {
                    ret = this.LOCATIONS.equals(alc.LOCATIONS);
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return ret;
        }
    }

    static {
        EmptyCollection col = null;
        try {
            col = new EmptyCollection();
        }
        catch (IOException bad) {
            ErrorService.error(bad);
        }
        EMPTY = col;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyCollection
    extends AlternateLocationCollection<AlternateLocation> {
        EmptyCollection() throws IOException {
            super(URN.createSHA1Urn("urn:sha1:PLSTHIPQGSSZTS5FJUPAKUZWUGYQYPFB"));
        }

        @Override
        public boolean add(AlternateLocation loc) {
            throw new UnsupportedOperationException();
        }
    }
}

