/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.DirectDHTAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SSLSettings;
import java.io.IOException;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.IP;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortForSelf;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.service.ErrorService;

@Singleton
public class AlternateLocationFactoryImpl
implements AlternateLocationFactory {
    private final NetworkManager networkManager;
    private final PushEndpointFactory pushEndpointFactory;
    private final ApplicationServices applicationServices;
    private final ConnectionServices connectionServices;
    private final NetworkInstanceUtils networkInstanceUtils;
    private final IpPortForSelf ipPortForSelf;

    @Inject
    public AlternateLocationFactoryImpl(NetworkManager networkManager, PushEndpointFactory pushEndpointFactory, ApplicationServices applicationServices, ConnectionServices connectionServices, NetworkInstanceUtils networkInstanceUtils, IpPortForSelf ipPortForSelf) {
        this.networkManager = networkManager;
        this.pushEndpointFactory = pushEndpointFactory;
        this.applicationServices = applicationServices;
        this.connectionServices = connectionServices;
        this.networkInstanceUtils = networkInstanceUtils;
        this.ipPortForSelf = ipPortForSelf;
    }

    public AlternateLocation create(URN urn) {
        if (urn == null) {
            throw new NullPointerException("null sha1");
        }
        try {
            boolean open = this.connectionServices.isConnected() ? this.networkManager.acceptedIncomingConnection() : ConnectionSettings.EVER_ACCEPTED_INCOMING.getValue();
            if (open && this.networkInstanceUtils.isValidExternalIpPort(this.ipPortForSelf)) {
                return new DirectAltLoc(new ConnectableImpl(NetworkUtils.ip2string(this.networkManager.getAddress()), this.networkManager.getPort(), SSLSettings.isIncomingTLSEnabled()), urn, this.networkInstanceUtils, this.ipPortForSelf);
            }
            return new PushAltLoc(this.pushEndpointFactory.createForSelf(), urn, this.applicationServices);
        }
        catch (IOException bad) {
            ErrorService.error(bad);
            return null;
        }
    }

    public AlternateLocation create(RemoteFileDesc rfd) throws IOException {
        if (rfd == null) {
            throw new NullPointerException("cannot accept null RFD");
        }
        URN urn = rfd.getSHA1Urn();
        if (urn == null) {
            throw new NullPointerException("cannot accept null URN");
        }
        if (!rfd.needsPush()) {
            return new DirectAltLoc(new ConnectableImpl(rfd.getHost(), rfd.getPort(), rfd.isTLSCapable()), urn, this.networkInstanceUtils, this.ipPortForSelf);
        }
        PushEndpoint copy = rfd.getPushAddr() != null ? rfd.getPushAddr() : this.pushEndpointFactory.createPushEndpoint(rfd.getClientGUID(), IpPort.EMPTY_SET, (byte)0, 0, null);
        return new PushAltLoc(copy, urn, this.applicationServices);
    }

    public AlternateLocation createPushAltLoc(PushEndpoint pe, URN urn) {
        return new PushAltLoc(pe, urn, this.applicationServices);
    }

    public AlternateLocation createDirectDHTAltLoc(IpPort ipp, URN urn, long fileSize, byte[] ttroot) throws IOException {
        return new DirectDHTAltLoc(ipp, urn, fileSize, ttroot, this.networkInstanceUtils, this.ipPortForSelf);
    }

    public AlternateLocation createDirectAltLoc(IpPort ipp, URN urn) throws IOException {
        return new DirectAltLoc(ipp, urn, this.networkInstanceUtils, this.ipPortForSelf);
    }

    public AlternateLocation create(String location, URN urn, boolean tlsCapable) throws IOException {
        if (location == null || location.equals("")) {
            throw new IOException("null or empty location");
        }
        if (urn == null) {
            throw new IOException("null URN.");
        }
        if (location.indexOf(";") == -1) {
            IpPort addr = this.createUrlFromMini(location, urn, tlsCapable);
            return new DirectAltLoc(addr, urn, this.networkInstanceUtils, this.ipPortForSelf);
        }
        PushEndpoint pe = this.pushEndpointFactory.createPushEndpoint(location);
        return new PushAltLoc(pe, urn, this.applicationServices);
    }

    public AlternateLocation create(String location, URN urn) throws IOException {
        return this.create(location, urn, false);
    }

    private IpPort createUrlFromMini(String location, URN urn, boolean tlsCapable) throws IOException {
        int port = location.indexOf(58);
        String loc = port == -1 ? location : location.substring(0, port);
        try {
            new IP(loc);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException("invalid location: " + location);
        }
        if (loc.indexOf(47) != -1) {
            throw new IOException("invalid location: " + location);
        }
        if (!NetworkUtils.isValidAddress(loc)) {
            throw new IOException("invalid location: " + location);
        }
        if (port == -1) {
            port = 6346;
        } else {
            if (location.length() < port + 1) {
                throw new IOException("invalid location: " + location);
            }
            try {
                port = Integer.parseInt(location.substring(port + 1));
            }
            catch (NumberFormatException nfe) {
                throw new IOException("invalid location: " + location);
            }
        }
        if (!NetworkUtils.isValidPort(port)) {
            throw new IOException("invalid port: " + port);
        }
        return new ConnectableImpl(loc, port, tlsCapable);
    }
}

