/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.altlocs.AbstractAlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.util.DataUtils;
import java.io.IOException;
import org.limewire.io.Connectable;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortForSelf;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.service.ErrorService;

public class DirectAltLoc
extends AbstractAlternateLocation {
    public static final String TLS_IDX = "tls=";
    private final IpPort _node;
    protected volatile boolean _demoted = false;
    private final NetworkInstanceUtils networkInstanceUtils;
    private final IpPortForSelf ipPortForSelf;

    protected DirectAltLoc(IpPort address, URN sha1, NetworkInstanceUtils networkInstanceUtils, IpPortForSelf ipPortForSelf) throws IOException {
        super(sha1);
        this.networkInstanceUtils = networkInstanceUtils;
        this.ipPortForSelf = ipPortForSelf;
        if (!networkInstanceUtils.isValidExternalIpPort(address)) {
            throw new IOException("not a valid external address:port in direct altloc " + address);
        }
        this._node = address;
        if (this._node == ipPortForSelf) {
            this.hashCode = ipPortForSelf.hashCode();
        }
    }

    protected String generateHTTPString() {
        String ret = this._node.getInetAddress().getHostAddress();
        if (this._node.getPort() != 6346) {
            ret = ret + ":" + this._node.getPort();
        }
        return ret;
    }

    public RemoteFileDesc createRemoteFileDesc(long size, RemoteFileDescFactory remoteFileDescFactory) {
        UrnSet urnSet = new UrnSet(this.getSHA1Urn());
        int quality = 3;
        RemoteFileDesc ret = remoteFileDescFactory.createRemoteFileDesc(this._node.getAddress(), this._node.getPort(), 0L, "/uri-res/N2R?" + this.SHA1_URN, size, DataUtils.EMPTY_GUID, 1000, true, quality, false, null, urnSet, false, false, "ALT", null, -1L, this._node instanceof Connectable ? ((Connectable)this._node).isTLSCapable() : false);
        return ret;
    }

    public synchronized AlternateLocation createClone() {
        DirectAltLoc ret = null;
        try {
            ret = new DirectAltLoc(this._node, this.SHA1_URN, this.networkInstanceUtils, this.ipPortForSelf);
        }
        catch (IOException ioe) {
            ErrorService.error(ioe);
            return null;
        }
        ret._demoted = this._demoted;
        ret._count = this._count;
        return ret;
    }

    public boolean isMe() {
        return this.networkInstanceUtils.isMe(this._node);
    }

    public IpPort getHost() {
        return this._node;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DirectAltLoc)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DirectAltLoc other = (DirectAltLoc)o;
        if (this._node == other._node) {
            return true;
        }
        return this._node.getInetAddress().equals(other._node.getInetAddress()) && this._node.getPort() == other._node.getPort();
    }

    synchronized void demote() {
        this._demoted = true;
    }

    synchronized void promote() {
        this._demoted = false;
    }

    public synchronized boolean isDemoted() {
        return this._demoted;
    }

    public int compareTo(AlternateLocation o) {
        if (this == o) {
            return 0;
        }
        int ret = super.compareTo(o);
        if (!(o instanceof DirectAltLoc)) {
            if (ret != 0) {
                return ret;
            }
            return -1;
        }
        DirectAltLoc other = (DirectAltLoc)o;
        if (this._demoted != other._demoted) {
            if (this._demoted) {
                return 1;
            }
            return -1;
        }
        if (ret != 0) {
            return ret;
        }
        if (this._node == other._node) {
            return 0;
        }
        ret = this._node.getAddress().compareTo(other._node.getAddress());
        if (ret != 0) {
            return ret;
        }
        ret = this._node.getPort() - other._node.getPort();
        return ret;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = super.hashCode();
            result = 37 * result + this._node.getAddress().hashCode();
            this.hashCode = result = 37 * result + this._node.getPort();
        }
        return this.hashCode;
    }

    public String toString() {
        return this._node + "," + this._count + "," + this._demoted;
    }
}

