/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.DownloadManagerEvent;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.dht.db.PushEndpointService;
import com.limegroup.gnutella.dht.db.SearchListener;
import com.limegroup.gnutella.downloader.CoreDownloader;
import com.limegroup.gnutella.downloader.DownloadStatusEvent;
import com.limegroup.gnutella.downloader.MagnetDownloader;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IpPort;
import org.limewire.listener.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DownloaderGuidAlternateLocationFinder
implements EventListener<DownloadManagerEvent> {
    private static final Log LOG = LogFactory.getLog(DownloaderGuidAlternateLocationFinder.class);
    private final PushEndpointService pushEndpointManager;
    private final AlternateLocationFactory alternateLocationFactory;
    private final AltLocManager altLocManager;
    final EventListener<DownloadStatusEvent> downloadStatusListener = new EventListener<DownloadStatusEvent>(){

        @Override
        public void handleEvent(DownloadStatusEvent event) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("per download event received: " + event);
            }
            DownloaderGuidAlternateLocationFinder.this.handleStatusEvent(event);
        }
    };

    @Inject
    public DownloaderGuidAlternateLocationFinder(@Named(value="pushEndpointManager") PushEndpointService pushEndpointManager, AlternateLocationFactory alternateLocationFactory, AltLocManager altLocManager) {
        this.pushEndpointManager = pushEndpointManager;
        this.alternateLocationFactory = alternateLocationFactory;
        this.altLocManager = altLocManager;
    }

    @Override
    public void handleEvent(DownloadManagerEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("event received: " + event);
        }
        switch ((DownloadManagerEvent.Type)((Object)event.getType())) {
            case ADDED: {
                CoreDownloader downloader = (CoreDownloader)event.getSource();
                if (!(downloader instanceof MagnetDownloader)) break;
                MagnetDownloader magnetDownloader = (MagnetDownloader)downloader;
                magnetDownloader.addListener(this.downloadStatusListener);
                break;
            }
            case REMOVED: {
                CoreDownloader downloader = (CoreDownloader)event.getSource();
                if (!(downloader instanceof MagnetDownloader)) break;
                downloader.removeListener(this.downloadStatusListener);
            }
        }
    }

    private long getSize(MagnetDownloader downloader) {
        long size = downloader.getMagnet().getFileSize();
        if (size == -1L) {
            size = downloader.getContentLength();
        }
        return size;
    }

    private void searchForPushEndpoints(MagnetDownloader magnetDownloader) {
        MagnetOptions magnet = magnetDownloader.getMagnet();
        URN sha1Urn = magnet.getSHA1Urn();
        if (sha1Urn == null) {
            LOG.debug("no sha1 urn");
            return;
        }
        long size = this.getSize(magnetDownloader);
        if (size == -1L) {
            LOG.debug("no file size");
            return;
        }
        this.searchForPushEndpoints(sha1Urn, magnet.getGUIDUrns());
    }

    void handleStatusEvent(DownloadStatusEvent event) {
        switch ((Downloader.DownloadStatus)((Object)event.getType())) {
            case GAVE_UP: 
            case WAITING_FOR_USER: {
                CoreDownloader downloader = (CoreDownloader)event.getSource();
                if (!(downloader instanceof MagnetDownloader)) break;
                MagnetDownloader magnetDownloader = (MagnetDownloader)downloader;
                this.searchForPushEndpoints(magnetDownloader);
            }
        }
    }

    void searchForPushEndpoints(URN sha1Urn, Set<URN> guidUrns) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Searching for guid urns: " + guidUrns);
        }
        for (URN guidUrn : guidUrns) {
            try {
                GUID guid = new GUID(guidUrn.getNamespaceSpecificString());
                this.pushEndpointManager.findPushEndpoint(guid, new PushendpointHandler(sha1Urn));
            }
            catch (IllegalArgumentException iae) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error("invalid hex string of guid", iae);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PushendpointHandler
    implements SearchListener<PushEndpoint> {
        private final URN sha1;

        public PushendpointHandler(URN sha1Urn) {
            this.sha1 = sha1Urn;
        }

        @Override
        public void handleResult(PushEndpoint result) {
            IpPort ipPort;
            if (LOG.isDebugEnabled()) {
                LOG.debug("endpoint found: " + result);
            }
            if ((ipPort = result.getValidExternalAddress()) != null && result.getProxies().size() == 1 && result.getProxies().contains(ipPort)) {
                try {
                    LOG.debug("creating direct altloc");
                    AlternateLocation alternateLocation = DownloaderGuidAlternateLocationFinder.this.alternateLocationFactory.createDirectAltLoc(ipPort, this.sha1);
                    DownloaderGuidAlternateLocationFinder.this.altLocManager.add(alternateLocation, null);
                }
                catch (IOException ie) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error("error creating direct alt loc from " + ipPort, ie);
                    }
                }
            } else {
                LOG.debug("creating push altloc");
                AlternateLocation alternateLocation = DownloaderGuidAlternateLocationFinder.this.alternateLocationFactory.createPushAltLoc(result, this.sha1);
                DownloaderGuidAlternateLocationFinder.this.altLocManager.add(alternateLocation, null);
            }
        }

        @Override
        public void searchFailed() {
        }
    }
}

