/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.auth;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.auth.ContentResponseData;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IOUtils;
import org.limewire.service.ErrorService;
import org.limewire.util.CommonUtils;
import org.limewire.util.GenericsUtils;

class ContentCache {
    private static final Log LOG = LogFactory.getLog(ContentCache.class);
    private static final long EXPIRY_TIME = 604800000L;
    private final File CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "responses.cache");
    private Map<URN, ContentResponseData> responses = new HashMap<URN, ContentResponseData>();
    private boolean dirty = false;

    ContentCache() {
    }

    synchronized int getSize() {
        return this.responses.size();
    }

    synchronized boolean hasResponseFor(URN urn) {
        return this.responses.containsKey(urn);
    }

    synchronized void addResponse(URN urn, ContentResponseData response) {
        this.responses.put(urn, response);
        this.dirty = true;
    }

    synchronized ContentResponseData getResponse(URN urn) {
        return this.responses.get(urn);
    }

    synchronized void initialize() {
        this.dirty = false;
        this.deserialize();
    }

    synchronized void writeToDisk() {
        if (this.dirty) {
            this.persistCache();
        }
        this.dirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deserialize() {
        long cutoff = System.currentTimeMillis() - 604800000L;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.CACHE_FILE)));
            Map map = (Map)ois.readObject();
            Map<URN, ContentResponseData> checked = GenericsUtils.scanForMap(map, URN.class, ContentResponseData.class, GenericsUtils.ScanMode.REMOVE);
            if (checked.size() != map.size()) {
                this.dirty = true;
            }
            Iterator<ContentResponseData> i = checked.values().iterator();
            while (i.hasNext()) {
                ContentResponseData data = i.next();
                if (data.getCreationTime() >= cutoff) continue;
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Removing old response [" + data + "]");
                }
                i.remove();
                this.dirty = true;
            }
            this.responses = checked;
        }
        catch (Throwable t) {
            try {
                this.dirty = true;
                LOG.error("Can't read responses", t);
            }
            catch (Throwable throwable) {
                IOUtils.close(ois);
                if (this.responses == null) {
                    this.responses = new HashMap<URN, ContentResponseData>();
                }
                throw throwable;
            }
            IOUtils.close(ois);
            if (this.responses == null) {
                this.responses = new HashMap<URN, ContentResponseData>();
            }
        }
        IOUtils.close(ois);
        if (this.responses == null) {
            this.responses = new HashMap<URN, ContentResponseData>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistCache() {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.CACHE_FILE)));
            oos.writeObject(this.responses);
            oos.flush();
            IOUtils.close(oos);
        }
        catch (IOException e) {
            ErrorService.error(e);
        }
        finally {
            IOUtils.close(oos);
        }
    }
}

